/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Metadata;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedSetMultimap;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class SetMultimapPropertyFactory
implements PropertyCodeGenerator.Factory {
    public Optional<CodeGenerator> create(PropertyCodeGenerator.Config config) {
        DeclaredType type = (DeclaredType)ModelUtils.maybeDeclared(config.getProperty().getType()).orNull();
        if (type == null || !Util.erasesToAnyOf(type, SetMultimap.class, ImmutableSetMultimap.class)) {
            return Optional.absent();
        }
        TypeMirror keyType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
        TypeMirror valueType = Util.upperBound(config.getElements(), type.getTypeArguments().get(1));
        Optional<TypeMirror> unboxedKeyType = ModelUtils.maybeUnbox(keyType, config.getTypes());
        Optional<TypeMirror> unboxedValueType = ModelUtils.maybeUnbox(valueType, config.getTypes());
        boolean overridesPutMethod = SetMultimapPropertyFactory.hasPutMethodOverride(config, (TypeMirror)unboxedKeyType.or((Object)keyType), (TypeMirror)unboxedValueType.or((Object)valueType));
        return Optional.of((Object)new CodeGenerator(config.getMetadata(), config.getProperty(), overridesPutMethod, keyType, unboxedKeyType, valueType, unboxedValueType));
    }

    private static boolean hasPutMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType, TypeMirror valueType) {
        return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.putMethod(config.getProperty()), keyType, valueType);
    }

    private static class CodeGenerator
    extends PropertyCodeGenerator {
        private final boolean overridesPutMethod;
        private final TypeMirror keyType;
        private final Optional<TypeMirror> unboxedKeyType;
        private final TypeMirror valueType;
        private final Optional<TypeMirror> unboxedValueType;

        CodeGenerator(Metadata metadata, Metadata.Property property, boolean overridesPutMethod, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType) {
            super(metadata, property);
            this.overridesPutMethod = overridesPutMethod;
            this.keyType = keyType;
            this.unboxedKeyType = unboxedKeyType;
            this.valueType = valueType;
            this.unboxedValueType = unboxedValueType;
        }

        @Override
        public void addBuilderFieldDeclaration(SourceBuilder code) {
            code.addLine("private final %1$s<%2$s, %3$s> %4$s = %1$s.create();", LinkedHashMultimap.class, this.keyType, this.valueType, this.property.getName());
        }

        @Override
        public void addBuilderFieldAccessors(SourceBuilder code) {
            this.addPut(code, this.metadata);
            this.addSingleKeyPutAll(code, this.metadata);
            this.addMultimapPutAll(code, this.metadata);
            this.addRemove(code, this.metadata);
            this.addRemoveAll(code, this.metadata);
            this.addMutate(code, this.metadata);
            this.addClear(code, this.metadata);
            this.addGetter(code, this.metadata);
        }

        private void addPut(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a {@code key}-{@code value} mapping to the multimap to be returned", new Object[0]).addLine(" * from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the multimap already contains this mapping, then {@code %s}", BuilderMethods.putMethod(this.property)).addLine(" * has no effect (only the previously added mapping is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
                code.add(" * @throws NullPointerException if ", new Object[0]);
                if (this.unboxedKeyType.isPresent()) {
                    code.add("{@code value}", new Object[0]);
                } else if (this.unboxedValueType.isPresent()) {
                    code.add("{@code key}", new Object[0]);
                } else {
                    code.add("either {@code key} or {@code value}", new Object[0]);
                }
                code.add(" is null\n", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s value) {", metadata.getBuilder(), BuilderMethods.putMethod(this.property), this.unboxedKeyType.or((Object)this.keyType), this.unboxedValueType.or((Object)this.valueType));
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine("  %s.checkNotNull(key);", Preconditions.class);
            }
            if (!this.unboxedValueType.isPresent()) {
                code.addLine("  %s.checkNotNull(value);", Preconditions.class);
            }
            code.addLine("  this.%s.put(key, value);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addSingleKeyPutAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a collection of {@code values} with the same {@code key} to the", new Object[0]).addLine(" * multimap to be returned from %s, ignoring duplicate values", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate value is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (this.unboxedKeyType.isPresent()) {
                code.addLine(" * @throws NullPointerException if {@code values} is null or contains a null element", new Object[0]);
            } else {
                code.addLine(" * @throws NullPointerException if either {@code key} or {@code values} is", new Object[0]).addLine(" *     null, or if {@code values} contains a null element", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s<? extends %s> values) {", metadata.getBuilder(), BuilderMethods.putAllMethod(this.property), this.unboxedKeyType.or((Object)this.keyType), Iterable.class, this.valueType).addLine("  for (%s value : values) {", this.unboxedValueType.or((Object)this.valueType)).addLine("    %s(key, value);", BuilderMethods.putMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMultimapPutAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each mapping in {@code multimap} to the multimap to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate mappings", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate mapping is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code multimap} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" */", new Object[0]);
            this.addAccessorAnnotations(code);
            code.addLine("public %s %s(%s<? extends %s, ? extends %s> multimap) {", metadata.getBuilder(), BuilderMethods.putAllMethod(this.property), Multimap.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s<? extends %s>> entry", Map.Entry.class, this.keyType, Collection.class, this.valueType).addLine("      : multimap.asMap().entrySet()) {", new Object[0]).addLine("    %s(entry.getKey(), entry.getValue());", BuilderMethods.putAllMethod(this.property), this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addRemove(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes a single key-value pair with the key {@code key} and the value {@code value}", new Object[0]).addLine(" * from the multimap to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
                code.add(" * @throws NullPointerException if ", new Object[0]);
                if (this.unboxedKeyType.isPresent()) {
                    code.add("{@code value}", new Object[0]);
                } else if (this.unboxedValueType.isPresent()) {
                    code.add("{@code key}", new Object[0]);
                } else {
                    code.add("either {@code key} or {@code value}", new Object[0]);
                }
                code.add(" is null\n", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s value) {", metadata.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedKeyType.or((Object)this.keyType), this.unboxedValueType.or((Object)this.valueType));
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine("  %s.checkNotNull(key);", Preconditions.class);
            }
            if (!this.unboxedValueType.isPresent()) {
                code.addLine("  %s.checkNotNull(value);", Preconditions.class);
            }
            code.addLine("  this.%s.remove(key, value);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addRemoveAll(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all values associated with the key {@code key} from the multimap to", new Object[0]).addLine(" * be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName());
            if (!this.unboxedKeyType.isPresent()) {
                code.add(" * @throws NullPointerException if {@code key} is null\n", new Object[0]);
            }
            code.addLine(" */", new Object[0]).addLine("public %s %s(%s key) {", metadata.getBuilder(), BuilderMethods.removeAllMethod(this.property), this.unboxedKeyType.or((Object)this.keyType));
            if (!this.unboxedKeyType.isPresent()) {
                code.addLine("  %s.checkNotNull(key);", Preconditions.class);
            }
            code.addLine("  this.%s.removeAll(key);", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addMutate(SourceBuilder code, Metadata metadata) {
            ParameterizedType consumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).consumer().orNull();
            if (consumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the multimap to be returned from %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the multimap in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<%s<%s, %s>> mutator) {", metadata.getBuilder(), BuilderMethods.mutator(this.property), consumer.getQualifiedName(), SetMultimap.class, this.keyType, this.valueType);
            if (this.overridesPutMethod) {
                code.addLine("  mutator.accept(new CheckedSetMultimap<>(%s, this::%s));", this.property.getName(), BuilderMethods.putMethod(this.property));
            } else {
                code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.putMethod(this.property)).addLine("  mutator.accept(%s);", this.property.getName());
            }
            code.addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addClear(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the multimap to be returned from", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", metadata.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", metadata.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getName()).addLine("  return (%s) this;", metadata.getBuilder()).addLine("}", new Object[0]);
        }

        private void addGetter(SourceBuilder code, Metadata metadata) {
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the multimap that will be returned by", new Object[0]).addLine(" * %s.", metadata.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s() {", SetMultimap.class, this.keyType, this.valueType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableSetMultimap(%s);", Multimaps.class, this.property.getName()).addLine("}", new Object[0]);
        }

        @Override
        public void addFinalFieldAssignment(SourceBuilder code, String finalField, String builder) {
            code.addLine("%s = %s.copyOf(%s.%s);", finalField, ImmutableSetMultimap.class, builder, this.property.getName());
        }

        @Override
        public void addMergeFromValue(Block code, String value) {
            code.addLine("%s(%s.%s());", BuilderMethods.putAllMethod(this.property), value, this.property.getGetterName());
        }

        @Override
        public void addMergeFromBuilder(Block code, String builder) {
            code.addLine("%s(((%s) %s).%s);", BuilderMethods.putAllMethod(this.property), this.metadata.getGeneratedBuilder(), builder, this.property.getName());
        }

        @Override
        public void addSetFromResult(SourceBuilder code, String builder, String variable) {
            code.addLine("%s.%s(%s);", builder, BuilderMethods.putAllMethod(this.property), variable);
        }

        @Override
        public void addClearField(Block code) {
            code.addLine("%s.clear();", this.property.getName());
        }

        public Set<StaticExcerpt> getStaticExcerpts() {
            ImmutableSet.Builder staticMethods = ImmutableSet.builder();
            if (this.overridesPutMethod) {
                staticMethods.addAll(CheckedSetMultimap.excerpts());
            }
            return staticMethods.build();
        }
    }
}

