/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.StaticExcerpt;
import org.inferred.freebuilder.processor.util.feature.FunctionPackage;

public class CheckedMultiset {
    private static final StaticExcerpt CHECKED_MULTISET = new StaticExcerpt(StaticExcerpt.Type.TYPE, "CheckedMultiset"){

        @Override
        public void addTo(SourceBuilder code) {
            ParameterizedType biConsumer = (ParameterizedType)code.feature(FunctionPackage.FUNCTION_PACKAGE).biConsumer().orNull();
            if (biConsumer == null) {
                return;
            }
            code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A multiset implementation that delegates to a provided setCount method", new Object[0]).addLine(" * to perform element validation and insertion into a backing multiset.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class CheckedMultiset<E> extends %s<E> {", ForwardingMultiset.class).addLine("", new Object[0]).addLine("  private final %s<E> multiset;", Multiset.class).addLine("  private final %s<E, Integer> setCount;", biConsumer.getQualifiedName()).addLine("", new Object[0]).addLine("  CheckedMultiset(%s<E> multiset, %s<E, Integer> setCount) {", Multiset.class, biConsumer.getQualifiedName()).addLine("    this.multiset = multiset;", new Object[0]).addLine("    this.setCount = setCount;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override protected %s<E> delegate() {", Multiset.class).addLine("    return multiset;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean add(@%s E element) {", Nullable.class).addLine("    return standardAdd(element);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int add(@%s E element, int occurrences) {", Nullable.class).addLine("    %s.checkArgument(occurrences >= 0,", Preconditions.class).addLine("        \"occurrences cannot be negative: %%s\", occurrences);", new Object[0]).addLine("    int oldCount = multiset.count(element);", new Object[0]).addLine("    if (occurrences > 0) {", new Object[0]).addLine("      long newCount = (long) oldCount + occurrences;", new Object[0]).addLine("      %s.checkArgument(newCount <= %s.MAX_VALUE,", Preconditions.class, Integer.class).addLine("          \"too many occurrences: %%s\", newCount);", new Object[0]).addLine("      setCount.accept(element, (int) newCount);", new Object[0]).addLine("    }", new Object[0]).addLine("    return oldCount;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean addAll(%s<? extends E> elementsToAdd) {", Collection.class).addLine("    return standardAddAll(elementsToAdd);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int setCount(@%s E element, int count) {", Nullable.class).addLine("    return standardSetCount(element, count);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean setCount(", new Object[0]).addLine("      @%s E element, int oldCount, int newCount) {", Nullable.class).addLine("    return standardSetCount(element, oldCount, newCount);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }
    };

    public static Set<StaticExcerpt> excerpts() {
        return ImmutableSet.of((Object)CHECKED_MULTISET);
    }
}

