/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.naming;

import com.google.common.base.MoreObjects;
import java.util.regex.Matcher;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.naming.BeanConvention;
import org.inferred.freebuilder.processor.naming.NamingConvention;
import org.inferred.freebuilder.processor.naming.PrefixlessConvention;

public class NamingConventions {
    public static NamingConvention determineNamingConvention(TypeElement type, Iterable<ExecutableElement> methods, Messager messager, Types types) {
        ExecutableElement beanMethod = null;
        ExecutableElement prefixlessMethod = null;
        for (ExecutableElement method : methods) {
            switch (NamingConventions.methodNameConvention(method)) {
                case BEAN: {
                    beanMethod = (ExecutableElement)MoreObjects.firstNonNull(beanMethod, (Object)method);
                    break;
                }
                case PREFIXLESS: {
                    prefixlessMethod = (ExecutableElement)MoreObjects.firstNonNull(prefixlessMethod, (Object)method);
                    break;
                }
            }
        }
        if (prefixlessMethod != null) {
            if (beanMethod != null) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Type contains an illegal mix of get-prefixed and unprefixed getter methods, e.g. '" + beanMethod.getSimpleName() + "' and '" + prefixlessMethod.getSimpleName() + "'", type);
            }
            return new PrefixlessConvention(messager, types);
        }
        return new BeanConvention(messager, types);
    }

    private static Convention methodNameConvention(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        Matcher getterMatcher = BeanConvention.GETTER_PATTERN.matcher(name);
        if (!getterMatcher.matches()) {
            return Convention.PREFIXLESS;
        }
        String prefix = getterMatcher.group(1);
        if (prefix.equals("get")) {
            return Convention.BEAN;
        }
        return Convention.UNKNOWN;
    }

    private NamingConventions() {
    }

    private static enum Convention {
        BEAN,
        PREFIXLESS,
        UNKNOWN;

    }
}

