/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import com.google.common.base.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import org.inferred.freebuilder.processor.util.ParameterizedType;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;
import org.inferred.freebuilder.processor.util.feature.SourceLevel;

public enum FunctionPackage implements Feature<FunctionPackage>
{
    AVAILABLE("Lambdas"),
    UNAVAILABLE("No lambdas");

    public static final FeatureType<FunctionPackage> FUNCTION_PACKAGE;
    private static final ParameterizedType CONSUMER;
    private static final ParameterizedType BI_CONSUMER;
    private static final ParameterizedType UNARY_OPERATOR;
    private final String humanReadableFormat;

    private FunctionPackage(String humanReadableFormat) {
        this.humanReadableFormat = humanReadableFormat;
    }

    public Optional<ParameterizedType> consumer() {
        return this.ifAvailable(CONSUMER);
    }

    public Optional<ParameterizedType> biConsumer() {
        return this.ifAvailable(BI_CONSUMER);
    }

    public Optional<ParameterizedType> unaryOperator() {
        return this.ifAvailable(UNARY_OPERATOR);
    }

    public String toString() {
        return this.humanReadableFormat;
    }

    private <T> Optional<T> ifAvailable(T value) {
        return this == AVAILABLE ? Optional.of(value) : Optional.absent();
    }

    static {
        FUNCTION_PACKAGE = new FeatureType<FunctionPackage>(){

            @Override
            protected FunctionPackage testDefault(FeatureSet features) {
                return this.determineFromSourceLevel(features);
            }

            @Override
            protected FunctionPackage forEnvironment(ProcessingEnvironment env, FeatureSet features) {
                return this.determineFromSourceLevel(features);
            }

            private FunctionPackage determineFromSourceLevel(FeatureSet features) {
                boolean isJava8OrHigher = features.get(SourceLevel.SOURCE_LEVEL).compareTo(SourceLevel.JAVA_8) >= 0;
                return isJava8OrHigher ? AVAILABLE : UNAVAILABLE;
            }
        };
        CONSUMER = QualifiedName.of("java.util.function", "Consumer", new String[0]).withParameters("T");
        BI_CONSUMER = QualifiedName.of("java.util.function", "BiConsumer", new String[0]).withParameters("T", "U");
        UNARY_OPERATOR = QualifiedName.of("java.util.function", "UnaryOperator", new String[0]).withParameters("T");
    }
}

