// Autogenerated code. Do not modify.
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.TypeClass;

/**
 * Auto-generated superclass of {@link Datatype.Builder}, derived from the API of {@link Datatype}.
 */
@Generated("org.inferred.freebuilder.processor.Processor")
abstract class Datatype_Builder {

  /** Creates a new builder using {@code value} as a template. */
  public static Datatype.Builder from(Datatype value) {
    return new Datatype.Builder().mergeFrom(value);
  }

  private enum Property {
    TYPE("type"),
    INTERFACE_TYPE("interfaceType"),
    BUILDER("builder"),
    EXTENSIBLE("extensible"),
    GENERATED_BUILDER("generatedBuilder"),
    VALUE_TYPE("valueType"),
    PARTIAL_TYPE("partialType"),
    PROPERTY_ENUM("propertyEnum"),
    BUILDER_SERIALIZABLE("builderSerializable"),
    HAS_TO_BUILDER_METHOD("hasToBuilderMethod"),
    VALUE_TYPE_VISIBILITY("valueTypeVisibility"),
    ;

    private final String name;

    private Property(String name) {
      this.name = name;
    }

    @Override
    public String toString() {
      return name;
    }
  }

  private TypeClass type;
  private boolean interfaceType;
  private Type builder;
  private boolean extensible;
  // Store a nullable object instead of an Optional. Escape analysis then
  // allows the JVM to optimize away the Optional objects created by and
  // passed to our API.
  private BuilderFactory builderFactory = null;
  private TypeClass generatedBuilder;
  private TypeClass valueType;
  private TypeClass partialType;
  private Set<QualifiedName> visibleNestedTypes = ImmutableSet.of();
  private TypeClass propertyEnum;
  private final LinkedHashMap<Datatype.StandardMethod, Datatype.UnderrideLevel>
      standardMethodUnderrides =
          new LinkedHashMap<Datatype.StandardMethod, Datatype.UnderrideLevel>();
  private boolean builderSerializable;
  private boolean hasToBuilderMethod;
  private List<Excerpt> generatedBuilderAnnotations = ImmutableList.of();
  private List<Excerpt> valueTypeAnnotations = ImmutableList.of();
  private Datatype.Visibility valueTypeVisibility;
  private List<Excerpt> nestedClasses = ImmutableList.of();
  private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

  /**
   * Sets the value to be returned by {@link Datatype#getType()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code type} is null
   */
  public Datatype.Builder setType(TypeClass type) {
    this.type = Preconditions.checkNotNull(type);
    _unsetProperties.remove(Property.TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getType() {
    Preconditions.checkState(!_unsetProperties.contains(Property.TYPE), "type not set");
    return type;
  }

  /**
   * Sets the value to be returned by {@link Datatype#isInterfaceType()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setInterfaceType(boolean interfaceType) {
    this.interfaceType = interfaceType;
    _unsetProperties.remove(Property.INTERFACE_TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#isInterfaceType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean isInterfaceType() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.INTERFACE_TYPE), "interfaceType not set");
    return interfaceType;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilder()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code builder} is null
   */
  public Datatype.Builder setBuilder(Type builder) {
    this.builder = Preconditions.checkNotNull(builder);
    _unsetProperties.remove(Property.BUILDER);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getBuilder()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public Type getBuilder() {
    Preconditions.checkState(!_unsetProperties.contains(Property.BUILDER), "builder not set");
    return builder;
  }

  /**
   * Sets the value to be returned by {@link Datatype#isExtensible()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setExtensible(boolean extensible) {
    this.extensible = extensible;
    _unsetProperties.remove(Property.EXTENSIBLE);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#isExtensible()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean isExtensible() {
    Preconditions.checkState(!_unsetProperties.contains(Property.EXTENSIBLE), "extensible not set");
    return extensible;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code builderFactory} is null
   */
  public Datatype.Builder setBuilderFactory(BuilderFactory builderFactory) {
    this.builderFactory = Preconditions.checkNotNull(builderFactory);
    return (Datatype.Builder) this;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setBuilderFactory(Optional<? extends BuilderFactory> builderFactory) {
    if (builderFactory.isPresent()) {
      return setBuilderFactory(builderFactory.get());
    } else {
      return clearBuilderFactory();
    }
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setNullableBuilderFactory(@Nullable BuilderFactory builderFactory) {
    if (builderFactory != null) {
      return setBuilderFactory(builderFactory);
    } else {
      return clearBuilderFactory();
    }
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()} to {@link
   * Optional#absent() Optional.absent()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearBuilderFactory() {
    builderFactory = null;
    return (Datatype.Builder) this;
  }

  /** Returns the value that will be returned by {@link Datatype#getBuilderFactory()}. */
  public Optional<BuilderFactory> getBuilderFactory() {
    return Optional.fromNullable(builderFactory);
  }

  /**
   * Sets the value to be returned by {@link Datatype#getGeneratedBuilder()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code generatedBuilder} is null
   */
  public Datatype.Builder setGeneratedBuilder(TypeClass generatedBuilder) {
    this.generatedBuilder = Preconditions.checkNotNull(generatedBuilder);
    _unsetProperties.remove(Property.GENERATED_BUILDER);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getGeneratedBuilder()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getGeneratedBuilder() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.GENERATED_BUILDER), "generatedBuilder not set");
    return generatedBuilder;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getValueType()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code valueType} is null
   */
  public Datatype.Builder setValueType(TypeClass valueType) {
    this.valueType = Preconditions.checkNotNull(valueType);
    _unsetProperties.remove(Property.VALUE_TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getValueType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getValueType() {
    Preconditions.checkState(!_unsetProperties.contains(Property.VALUE_TYPE), "valueType not set");
    return valueType;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getPartialType()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code partialType} is null
   */
  public Datatype.Builder setPartialType(TypeClass partialType) {
    this.partialType = Preconditions.checkNotNull(partialType);
    _unsetProperties.remove(Property.PARTIAL_TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getPartialType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getPartialType() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.PARTIAL_TYPE), "partialType not set");
    return partialType;
  }

  /**
   * Adds {@code element} to the set to be returned from {@link Datatype#getVisibleNestedTypes()}.
   * If the set already contains {@code element}, then {@code addVisibleNestedTypes} has no effect
   * (only the previously added element is retained).
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addVisibleNestedTypes(QualifiedName element) {
    if (visibleNestedTypes instanceof ImmutableSet) {
      visibleNestedTypes = new LinkedHashSet<QualifiedName>(visibleNestedTypes);
    }
    visibleNestedTypes.add(Preconditions.checkNotNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the set to be returned from {@link
   * Datatype#getVisibleNestedTypes()}, ignoring duplicate elements (only the first duplicate
   * element is added).
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addVisibleNestedTypes(QualifiedName... elements) {
    return addAllVisibleNestedTypes(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the set to be returned from {@link
   * Datatype#getVisibleNestedTypes()}, ignoring duplicate elements (only the first duplicate
   * element is added).
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllVisibleNestedTypes(Iterable<? extends QualifiedName> elements) {
    for (QualifiedName element : elements) {
      addVisibleNestedTypes(element);
    }
    return (Datatype.Builder) this;
  }

  /**
   * Removes {@code element} from the set to be returned from {@link
   * Datatype#getVisibleNestedTypes()}. Does nothing if {@code element} is not a member of the set.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder removeVisibleNestedTypes(QualifiedName element) {
    if (visibleNestedTypes instanceof ImmutableSet) {
      visibleNestedTypes = new LinkedHashSet<QualifiedName>(visibleNestedTypes);
    }
    visibleNestedTypes.remove(Preconditions.checkNotNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Clears the set to be returned from {@link Datatype#getVisibleNestedTypes()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearVisibleNestedTypes() {
    if (visibleNestedTypes instanceof ImmutableSet) {
      visibleNestedTypes = ImmutableSet.of();
    } else {
      visibleNestedTypes.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the set that will be returned by {@link
   * Datatype#getVisibleNestedTypes()}. Changes to this builder will be reflected in the view.
   */
  public Set<QualifiedName> getVisibleNestedTypes() {
    if (visibleNestedTypes instanceof ImmutableSet) {
      visibleNestedTypes = new LinkedHashSet<QualifiedName>(visibleNestedTypes);
    }
    return Collections.unmodifiableSet(visibleNestedTypes);
  }

  /**
   * Sets the value to be returned by {@link Datatype#getPropertyEnum()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code propertyEnum} is null
   */
  public Datatype.Builder setPropertyEnum(TypeClass propertyEnum) {
    this.propertyEnum = Preconditions.checkNotNull(propertyEnum);
    _unsetProperties.remove(Property.PROPERTY_ENUM);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getPropertyEnum()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getPropertyEnum() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.PROPERTY_ENUM), "propertyEnum not set");
    return propertyEnum;
  }

  /**
   * Associates {@code key} with {@code value} in the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}. If the map previously contained a mapping for the key,
   * the old value is replaced by the specified value.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if either {@code key} or {@code value} are null
   */
  public Datatype.Builder putStandardMethodUnderrides(
      Datatype.StandardMethod key, Datatype.UnderrideLevel value) {
    Preconditions.checkNotNull(key);
    Preconditions.checkNotNull(value);
    standardMethodUnderrides.put(key, value);
    return (Datatype.Builder) this;
  }

  /**
   * Copies all of the mappings from {@code map} to the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code map} is null or contains a null key or value
   */
  public Datatype.Builder putAllStandardMethodUnderrides(
      Map<? extends Datatype.StandardMethod, ? extends Datatype.UnderrideLevel> map) {
    for (Map.Entry<? extends Datatype.StandardMethod, ? extends Datatype.UnderrideLevel> entry :
        map.entrySet()) {
      putStandardMethodUnderrides(entry.getKey(), entry.getValue());
    }
    return (Datatype.Builder) this;
  }

  /**
   * Removes the mapping for {@code key} from the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}, if one is present.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code key} is null
   */
  public Datatype.Builder removeStandardMethodUnderrides(Datatype.StandardMethod key) {
    Preconditions.checkNotNull(key);
    standardMethodUnderrides.remove(key);
    return (Datatype.Builder) this;
  }

  /**
   * Removes all of the mappings from the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearStandardMethodUnderrides() {
    standardMethodUnderrides.clear();
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the map that will be returned by {@link
   * Datatype#getStandardMethodUnderrides()}. Changes to this builder will be reflected in the view.
   */
  public Map<Datatype.StandardMethod, Datatype.UnderrideLevel> getStandardMethodUnderrides() {
    return Collections.unmodifiableMap(standardMethodUnderrides);
  }

  /**
   * Sets the value to be returned by {@link Datatype#isBuilderSerializable()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setBuilderSerializable(boolean builderSerializable) {
    this.builderSerializable = builderSerializable;
    _unsetProperties.remove(Property.BUILDER_SERIALIZABLE);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#isBuilderSerializable()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean isBuilderSerializable() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.BUILDER_SERIALIZABLE), "builderSerializable not set");
    return builderSerializable;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getHasToBuilderMethod()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setHasToBuilderMethod(boolean hasToBuilderMethod) {
    this.hasToBuilderMethod = hasToBuilderMethod;
    _unsetProperties.remove(Property.HAS_TO_BUILDER_METHOD);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getHasToBuilderMethod()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean getHasToBuilderMethod() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD), "hasToBuilderMethod not set");
    return hasToBuilderMethod;
  }

  /**
   * Adds {@code element} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addGeneratedBuilderAnnotations(Excerpt element) {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = new ArrayList<Excerpt>(generatedBuilderAnnotations);
    }
    generatedBuilderAnnotations.add(Preconditions.checkNotNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addGeneratedBuilderAnnotations(Excerpt... elements) {
    return addAllGeneratedBuilderAnnotations(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllGeneratedBuilderAnnotations(Iterable<? extends Excerpt> elements) {
    if (elements instanceof Collection) {
      int elementsSize = ((Collection<?>) elements).size();
      if (elementsSize != 0) {
        if (generatedBuilderAnnotations instanceof ImmutableList) {
          generatedBuilderAnnotations = new ArrayList<Excerpt>(generatedBuilderAnnotations);
        }
        ((ArrayList<?>) generatedBuilderAnnotations)
            .ensureCapacity(generatedBuilderAnnotations.size() + elementsSize);
      }
    }
    for (Excerpt element : elements) {
      addGeneratedBuilderAnnotations(element);
    }
    return (Datatype.Builder) this;
  }

  /**
   * Clears the list to be returned from {@link Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearGeneratedBuilderAnnotations() {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = ImmutableList.of();
    } else {
      generatedBuilderAnnotations.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the list that will be returned by {@link
   * Datatype#getGeneratedBuilderAnnotations()}. Changes to this builder will be reflected in the
   * view.
   */
  public List<Excerpt> getGeneratedBuilderAnnotations() {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = new ArrayList<Excerpt>(generatedBuilderAnnotations);
    }
    return Collections.unmodifiableList(generatedBuilderAnnotations);
  }

  /**
   * Adds {@code element} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addValueTypeAnnotations(Excerpt element) {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = new ArrayList<Excerpt>(valueTypeAnnotations);
    }
    valueTypeAnnotations.add(Preconditions.checkNotNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addValueTypeAnnotations(Excerpt... elements) {
    return addAllValueTypeAnnotations(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllValueTypeAnnotations(Iterable<? extends Excerpt> elements) {
    if (elements instanceof Collection) {
      int elementsSize = ((Collection<?>) elements).size();
      if (elementsSize != 0) {
        if (valueTypeAnnotations instanceof ImmutableList) {
          valueTypeAnnotations = new ArrayList<Excerpt>(valueTypeAnnotations);
        }
        ((ArrayList<?>) valueTypeAnnotations)
            .ensureCapacity(valueTypeAnnotations.size() + elementsSize);
      }
    }
    for (Excerpt element : elements) {
      addValueTypeAnnotations(element);
    }
    return (Datatype.Builder) this;
  }

  /**
   * Clears the list to be returned from {@link Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearValueTypeAnnotations() {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = ImmutableList.of();
    } else {
      valueTypeAnnotations.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the list that will be returned by {@link
   * Datatype#getValueTypeAnnotations()}. Changes to this builder will be reflected in the view.
   */
  public List<Excerpt> getValueTypeAnnotations() {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = new ArrayList<Excerpt>(valueTypeAnnotations);
    }
    return Collections.unmodifiableList(valueTypeAnnotations);
  }

  /**
   * Sets the value to be returned by {@link Datatype#getValueTypeVisibility()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code valueTypeVisibility} is null
   */
  public Datatype.Builder setValueTypeVisibility(Datatype.Visibility valueTypeVisibility) {
    this.valueTypeVisibility = Preconditions.checkNotNull(valueTypeVisibility);
    _unsetProperties.remove(Property.VALUE_TYPE_VISIBILITY);
    return (Datatype.Builder) this;
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getValueTypeVisibility()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Visibility getValueTypeVisibility() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY), "valueTypeVisibility not set");
    return valueTypeVisibility;
  }

  /**
   * Adds {@code element} to the list to be returned from {@link Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addNestedClasses(Excerpt element) {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = new ArrayList<Excerpt>(nestedClasses);
    }
    nestedClasses.add(Preconditions.checkNotNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addNestedClasses(Excerpt... elements) {
    return addAllNestedClasses(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllNestedClasses(Iterable<? extends Excerpt> elements) {
    if (elements instanceof Collection) {
      int elementsSize = ((Collection<?>) elements).size();
      if (elementsSize != 0) {
        if (nestedClasses instanceof ImmutableList) {
          nestedClasses = new ArrayList<Excerpt>(nestedClasses);
        }
        ((ArrayList<?>) nestedClasses).ensureCapacity(nestedClasses.size() + elementsSize);
      }
    }
    for (Excerpt element : elements) {
      addNestedClasses(element);
    }
    return (Datatype.Builder) this;
  }

  /**
   * Clears the list to be returned from {@link Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearNestedClasses() {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = ImmutableList.of();
    } else {
      nestedClasses.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the list that will be returned by {@link
   * Datatype#getNestedClasses()}. Changes to this builder will be reflected in the view.
   */
  public List<Excerpt> getNestedClasses() {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = new ArrayList<Excerpt>(nestedClasses);
    }
    return Collections.unmodifiableList(nestedClasses);
  }

  /** Sets all property values using the given {@code Datatype} as a template. */
  public Datatype.Builder mergeFrom(Datatype value) {
    Datatype_Builder _defaults = new Datatype.Builder();
    if (_defaults._unsetProperties.contains(Property.TYPE)
        || !value.getType().equals(_defaults.getType())) {
      setType(value.getType());
    }
    if (_defaults._unsetProperties.contains(Property.INTERFACE_TYPE)
        || value.isInterfaceType() != _defaults.isInterfaceType()) {
      setInterfaceType(value.isInterfaceType());
    }
    if (_defaults._unsetProperties.contains(Property.BUILDER)
        || !value.getBuilder().equals(_defaults.getBuilder())) {
      setBuilder(value.getBuilder());
    }
    if (_defaults._unsetProperties.contains(Property.EXTENSIBLE)
        || value.isExtensible() != _defaults.isExtensible()) {
      setExtensible(value.isExtensible());
    }
    if (value.getBuilderFactory().isPresent()) {
      setBuilderFactory(value.getBuilderFactory().get());
    }
    if (_defaults._unsetProperties.contains(Property.GENERATED_BUILDER)
        || !value.getGeneratedBuilder().equals(_defaults.getGeneratedBuilder())) {
      setGeneratedBuilder(value.getGeneratedBuilder());
    }
    if (_defaults._unsetProperties.contains(Property.VALUE_TYPE)
        || !value.getValueType().equals(_defaults.getValueType())) {
      setValueType(value.getValueType());
    }
    if (_defaults._unsetProperties.contains(Property.PARTIAL_TYPE)
        || !value.getPartialType().equals(_defaults.getPartialType())) {
      setPartialType(value.getPartialType());
    }
    if (value instanceof Value && visibleNestedTypes == ImmutableSet.<QualifiedName>of()) {
      visibleNestedTypes = ImmutableSet.copyOf(value.getVisibleNestedTypes());
    } else {
      addAllVisibleNestedTypes(value.getVisibleNestedTypes());
    }
    if (_defaults._unsetProperties.contains(Property.PROPERTY_ENUM)
        || !value.getPropertyEnum().equals(_defaults.getPropertyEnum())) {
      setPropertyEnum(value.getPropertyEnum());
    }
    putAllStandardMethodUnderrides(value.getStandardMethodUnderrides());
    if (_defaults._unsetProperties.contains(Property.BUILDER_SERIALIZABLE)
        || value.isBuilderSerializable() != _defaults.isBuilderSerializable()) {
      setBuilderSerializable(value.isBuilderSerializable());
    }
    if (_defaults._unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)
        || value.getHasToBuilderMethod() != _defaults.getHasToBuilderMethod()) {
      setHasToBuilderMethod(value.getHasToBuilderMethod());
    }
    if (value instanceof Value && generatedBuilderAnnotations == ImmutableList.<Excerpt>of()) {
      generatedBuilderAnnotations = ImmutableList.copyOf(value.getGeneratedBuilderAnnotations());
    } else {
      addAllGeneratedBuilderAnnotations(value.getGeneratedBuilderAnnotations());
    }
    if (value instanceof Value && valueTypeAnnotations == ImmutableList.<Excerpt>of()) {
      valueTypeAnnotations = ImmutableList.copyOf(value.getValueTypeAnnotations());
    } else {
      addAllValueTypeAnnotations(value.getValueTypeAnnotations());
    }
    if (_defaults._unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)
        || !value.getValueTypeVisibility().equals(_defaults.getValueTypeVisibility())) {
      setValueTypeVisibility(value.getValueTypeVisibility());
    }
    if (value instanceof Value && nestedClasses == ImmutableList.<Excerpt>of()) {
      nestedClasses = ImmutableList.copyOf(value.getNestedClasses());
    } else {
      addAllNestedClasses(value.getNestedClasses());
    }
    return (Datatype.Builder) this;
  }

  /**
   * Copies values from the given {@code Builder}. Does not affect any properties not set on the
   * input.
   */
  public Datatype.Builder mergeFrom(Datatype.Builder template) {
    // Upcast to access private fields; otherwise, oddly, we get an access violation.
    Datatype_Builder base = template;
    Datatype_Builder _defaults = new Datatype.Builder();
    if (!base._unsetProperties.contains(Property.TYPE)
        && (_defaults._unsetProperties.contains(Property.TYPE)
            || !template.getType().equals(_defaults.getType()))) {
      setType(template.getType());
    }
    if (!base._unsetProperties.contains(Property.INTERFACE_TYPE)
        && (_defaults._unsetProperties.contains(Property.INTERFACE_TYPE)
            || template.isInterfaceType() != _defaults.isInterfaceType())) {
      setInterfaceType(template.isInterfaceType());
    }
    if (!base._unsetProperties.contains(Property.BUILDER)
        && (_defaults._unsetProperties.contains(Property.BUILDER)
            || !template.getBuilder().equals(_defaults.getBuilder()))) {
      setBuilder(template.getBuilder());
    }
    if (!base._unsetProperties.contains(Property.EXTENSIBLE)
        && (_defaults._unsetProperties.contains(Property.EXTENSIBLE)
            || template.isExtensible() != _defaults.isExtensible())) {
      setExtensible(template.isExtensible());
    }
    if (template.getBuilderFactory().isPresent()) {
      setBuilderFactory(template.getBuilderFactory().get());
    }
    if (!base._unsetProperties.contains(Property.GENERATED_BUILDER)
        && (_defaults._unsetProperties.contains(Property.GENERATED_BUILDER)
            || !template.getGeneratedBuilder().equals(_defaults.getGeneratedBuilder()))) {
      setGeneratedBuilder(template.getGeneratedBuilder());
    }
    if (!base._unsetProperties.contains(Property.VALUE_TYPE)
        && (_defaults._unsetProperties.contains(Property.VALUE_TYPE)
            || !template.getValueType().equals(_defaults.getValueType()))) {
      setValueType(template.getValueType());
    }
    if (!base._unsetProperties.contains(Property.PARTIAL_TYPE)
        && (_defaults._unsetProperties.contains(Property.PARTIAL_TYPE)
            || !template.getPartialType().equals(_defaults.getPartialType()))) {
      setPartialType(template.getPartialType());
    }
    addAllVisibleNestedTypes(base.visibleNestedTypes);
    if (!base._unsetProperties.contains(Property.PROPERTY_ENUM)
        && (_defaults._unsetProperties.contains(Property.PROPERTY_ENUM)
            || !template.getPropertyEnum().equals(_defaults.getPropertyEnum()))) {
      setPropertyEnum(template.getPropertyEnum());
    }
    putAllStandardMethodUnderrides(base.standardMethodUnderrides);
    if (!base._unsetProperties.contains(Property.BUILDER_SERIALIZABLE)
        && (_defaults._unsetProperties.contains(Property.BUILDER_SERIALIZABLE)
            || template.isBuilderSerializable() != _defaults.isBuilderSerializable())) {
      setBuilderSerializable(template.isBuilderSerializable());
    }
    if (!base._unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)
        && (_defaults._unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)
            || template.getHasToBuilderMethod() != _defaults.getHasToBuilderMethod())) {
      setHasToBuilderMethod(template.getHasToBuilderMethod());
    }
    addAllGeneratedBuilderAnnotations(base.generatedBuilderAnnotations);
    addAllValueTypeAnnotations(base.valueTypeAnnotations);
    if (!base._unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)
        && (_defaults._unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)
            || !template.getValueTypeVisibility().equals(_defaults.getValueTypeVisibility()))) {
      setValueTypeVisibility(template.getValueTypeVisibility());
    }
    addAllNestedClasses(base.nestedClasses);
    return (Datatype.Builder) this;
  }

  /** Resets the state of this builder. */
  public Datatype.Builder clear() {
    Datatype_Builder _defaults = new Datatype.Builder();
    type = _defaults.type;
    interfaceType = _defaults.interfaceType;
    builder = _defaults.builder;
    extensible = _defaults.extensible;
    builderFactory = _defaults.builderFactory;
    generatedBuilder = _defaults.generatedBuilder;
    valueType = _defaults.valueType;
    partialType = _defaults.partialType;
    clearVisibleNestedTypes();
    propertyEnum = _defaults.propertyEnum;
    standardMethodUnderrides.clear();
    builderSerializable = _defaults.builderSerializable;
    hasToBuilderMethod = _defaults.hasToBuilderMethod;
    clearGeneratedBuilderAnnotations();
    clearValueTypeAnnotations();
    valueTypeVisibility = _defaults.valueTypeVisibility;
    clearNestedClasses();
    _unsetProperties.clear();
    _unsetProperties.addAll(_defaults._unsetProperties);
    return (Datatype.Builder) this;
  }

  /**
   * Returns a newly-created {@link Datatype} based on the contents of the {@code Builder}.
   *
   * @throws IllegalStateException if any field has not been set
   */
  public Datatype build() {
    Preconditions.checkState(_unsetProperties.isEmpty(), "Not set: %s", _unsetProperties);
    return new Value(this);
  }

  /**
   * Returns a newly-created partial {@link Datatype} for use in unit tests. State checking will not
   * be performed. Unset properties will throw an {@link UnsupportedOperationException} when
   * accessed via the partial object.
   *
   * <p>Partials should only ever be used in tests. They permit writing robust test cases that won't
   * fail if this type gains more application-level constraints (e.g. new required fields) in
   * future. If you require partially complete values in production code, consider using a Builder.
   */
  @VisibleForTesting()
  public Datatype buildPartial() {
    return new Partial(this);
  }

  private static final class Value extends Datatype {
    private final TypeClass type;
    private final boolean interfaceType;
    private final Type builder;
    private final boolean extensible;
    // Store a nullable object instead of an Optional. Escape analysis then
    // allows the JVM to optimize away the Optional objects created by our
    // getter method.
    private final BuilderFactory builderFactory;
    private final TypeClass generatedBuilder;
    private final TypeClass valueType;
    private final TypeClass partialType;
    private final ImmutableSet<QualifiedName> visibleNestedTypes;
    private final TypeClass propertyEnum;
    private final ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel>
        standardMethodUnderrides;
    private final boolean builderSerializable;
    private final boolean hasToBuilderMethod;
    private final ImmutableList<Excerpt> generatedBuilderAnnotations;
    private final ImmutableList<Excerpt> valueTypeAnnotations;
    private final Datatype.Visibility valueTypeVisibility;
    private final ImmutableList<Excerpt> nestedClasses;

    private Value(Datatype_Builder builder) {
      this.type = builder.type;
      this.interfaceType = builder.interfaceType;
      this.builder = builder.builder;
      this.extensible = builder.extensible;
      this.builderFactory = builder.builderFactory;
      this.generatedBuilder = builder.generatedBuilder;
      this.valueType = builder.valueType;
      this.partialType = builder.partialType;
      this.visibleNestedTypes = ImmutableSet.copyOf(builder.visibleNestedTypes);
      this.propertyEnum = builder.propertyEnum;
      this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
      this.builderSerializable = builder.builderSerializable;
      this.hasToBuilderMethod = builder.hasToBuilderMethod;
      this.generatedBuilderAnnotations = ImmutableList.copyOf(builder.generatedBuilderAnnotations);
      this.valueTypeAnnotations = ImmutableList.copyOf(builder.valueTypeAnnotations);
      this.valueTypeVisibility = builder.valueTypeVisibility;
      this.nestedClasses = ImmutableList.copyOf(builder.nestedClasses);
    }

    @Override
    public TypeClass getType() {
      return type;
    }

    @Override
    public boolean isInterfaceType() {
      return interfaceType;
    }

    @Override
    public Type getBuilder() {
      return builder;
    }

    @Override
    public boolean isExtensible() {
      return extensible;
    }

    @Override
    public Optional<BuilderFactory> getBuilderFactory() {
      return Optional.fromNullable(builderFactory);
    }

    @Override
    public TypeClass getGeneratedBuilder() {
      return generatedBuilder;
    }

    @Override
    public TypeClass getValueType() {
      return valueType;
    }

    @Override
    public TypeClass getPartialType() {
      return partialType;
    }

    @Override
    public ImmutableSet<QualifiedName> getVisibleNestedTypes() {
      return visibleNestedTypes;
    }

    @Override
    public TypeClass getPropertyEnum() {
      return propertyEnum;
    }

    @Override
    public ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel>
        getStandardMethodUnderrides() {
      return standardMethodUnderrides;
    }

    @Override
    public boolean isBuilderSerializable() {
      return builderSerializable;
    }

    @Override
    public boolean getHasToBuilderMethod() {
      return hasToBuilderMethod;
    }

    @Override
    public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
      return generatedBuilderAnnotations;
    }

    @Override
    public ImmutableList<Excerpt> getValueTypeAnnotations() {
      return valueTypeAnnotations;
    }

    @Override
    public Datatype.Visibility getValueTypeVisibility() {
      return valueTypeVisibility;
    }

    @Override
    public ImmutableList<Excerpt> getNestedClasses() {
      return nestedClasses;
    }

    @Override
    public boolean equals(Object obj) {
      if (!(obj instanceof Value)) {
        return false;
      }
      Value other = (Value) obj;
      if (!type.equals(other.type)) {
        return false;
      }
      if (interfaceType != other.interfaceType) {
        return false;
      }
      if (!builder.equals(other.builder)) {
        return false;
      }
      if (extensible != other.extensible) {
        return false;
      }
      if (builderFactory != other.builderFactory
          && (builderFactory == null || !builderFactory.equals(other.builderFactory))) {
        return false;
      }
      if (!generatedBuilder.equals(other.generatedBuilder)) {
        return false;
      }
      if (!valueType.equals(other.valueType)) {
        return false;
      }
      if (!partialType.equals(other.partialType)) {
        return false;
      }
      if (!visibleNestedTypes.equals(other.visibleNestedTypes)) {
        return false;
      }
      if (!propertyEnum.equals(other.propertyEnum)) {
        return false;
      }
      if (!standardMethodUnderrides.equals(other.standardMethodUnderrides)) {
        return false;
      }
      if (builderSerializable != other.builderSerializable) {
        return false;
      }
      if (hasToBuilderMethod != other.hasToBuilderMethod) {
        return false;
      }
      if (!generatedBuilderAnnotations.equals(other.generatedBuilderAnnotations)) {
        return false;
      }
      if (!valueTypeAnnotations.equals(other.valueTypeAnnotations)) {
        return false;
      }
      if (!valueTypeVisibility.equals(other.valueTypeVisibility)) {
        return false;
      }
      if (!nestedClasses.equals(other.nestedClasses)) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      return Arrays.hashCode(
          new Object[] {
            type,
            interfaceType,
            builder,
            extensible,
            builderFactory,
            generatedBuilder,
            valueType,
            partialType,
            visibleNestedTypes,
            propertyEnum,
            standardMethodUnderrides,
            builderSerializable,
            hasToBuilderMethod,
            generatedBuilderAnnotations,
            valueTypeAnnotations,
            valueTypeVisibility,
            nestedClasses
          });
    }

    @Override
    public String toString() {
      StringBuilder result =
          new StringBuilder("Datatype{type=")
              .append(type)
              .append(", interfaceType=")
              .append(interfaceType)
              .append(", builder=")
              .append(builder)
              .append(", extensible=")
              .append(extensible);
      if (builderFactory != null) {
        result.append(", builderFactory=").append(builderFactory);
      }
      return result
          .append(", generatedBuilder=")
          .append(generatedBuilder)
          .append(", valueType=")
          .append(valueType)
          .append(", partialType=")
          .append(partialType)
          .append(", visibleNestedTypes=")
          .append(visibleNestedTypes)
          .append(", propertyEnum=")
          .append(propertyEnum)
          .append(", standardMethodUnderrides=")
          .append(standardMethodUnderrides)
          .append(", builderSerializable=")
          .append(builderSerializable)
          .append(", hasToBuilderMethod=")
          .append(hasToBuilderMethod)
          .append(", generatedBuilderAnnotations=")
          .append(generatedBuilderAnnotations)
          .append(", valueTypeAnnotations=")
          .append(valueTypeAnnotations)
          .append(", valueTypeVisibility=")
          .append(valueTypeVisibility)
          .append(", nestedClasses=")
          .append(nestedClasses)
          .append("}")
          .toString();
    }
  }

  private static final class Partial extends Datatype {
    private final TypeClass type;
    private final boolean interfaceType;
    private final Type builder;
    private final boolean extensible;
    // Store a nullable object instead of an Optional. Escape analysis then
    // allows the JVM to optimize away the Optional objects created by our
    // getter method.
    private final BuilderFactory builderFactory;
    private final TypeClass generatedBuilder;
    private final TypeClass valueType;
    private final TypeClass partialType;
    private final ImmutableSet<QualifiedName> visibleNestedTypes;
    private final TypeClass propertyEnum;
    private final ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel>
        standardMethodUnderrides;
    private final boolean builderSerializable;
    private final boolean hasToBuilderMethod;
    private final ImmutableList<Excerpt> generatedBuilderAnnotations;
    private final ImmutableList<Excerpt> valueTypeAnnotations;
    private final Datatype.Visibility valueTypeVisibility;
    private final ImmutableList<Excerpt> nestedClasses;
    private final EnumSet<Property> _unsetProperties;

    Partial(Datatype_Builder builder) {
      this.type = builder.type;
      this.interfaceType = builder.interfaceType;
      this.builder = builder.builder;
      this.extensible = builder.extensible;
      this.builderFactory = builder.builderFactory;
      this.generatedBuilder = builder.generatedBuilder;
      this.valueType = builder.valueType;
      this.partialType = builder.partialType;
      this.visibleNestedTypes = ImmutableSet.copyOf(builder.visibleNestedTypes);
      this.propertyEnum = builder.propertyEnum;
      this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
      this.builderSerializable = builder.builderSerializable;
      this.hasToBuilderMethod = builder.hasToBuilderMethod;
      this.generatedBuilderAnnotations = ImmutableList.copyOf(builder.generatedBuilderAnnotations);
      this.valueTypeAnnotations = ImmutableList.copyOf(builder.valueTypeAnnotations);
      this.valueTypeVisibility = builder.valueTypeVisibility;
      this.nestedClasses = ImmutableList.copyOf(builder.nestedClasses);
      this._unsetProperties = builder._unsetProperties.clone();
    }

    @Override
    public TypeClass getType() {
      if (_unsetProperties.contains(Property.TYPE)) {
        throw new UnsupportedOperationException("type not set");
      }
      return type;
    }

    @Override
    public boolean isInterfaceType() {
      if (_unsetProperties.contains(Property.INTERFACE_TYPE)) {
        throw new UnsupportedOperationException("interfaceType not set");
      }
      return interfaceType;
    }

    @Override
    public Type getBuilder() {
      if (_unsetProperties.contains(Property.BUILDER)) {
        throw new UnsupportedOperationException("builder not set");
      }
      return builder;
    }

    @Override
    public boolean isExtensible() {
      if (_unsetProperties.contains(Property.EXTENSIBLE)) {
        throw new UnsupportedOperationException("extensible not set");
      }
      return extensible;
    }

    @Override
    public Optional<BuilderFactory> getBuilderFactory() {
      return Optional.fromNullable(builderFactory);
    }

    @Override
    public TypeClass getGeneratedBuilder() {
      if (_unsetProperties.contains(Property.GENERATED_BUILDER)) {
        throw new UnsupportedOperationException("generatedBuilder not set");
      }
      return generatedBuilder;
    }

    @Override
    public TypeClass getValueType() {
      if (_unsetProperties.contains(Property.VALUE_TYPE)) {
        throw new UnsupportedOperationException("valueType not set");
      }
      return valueType;
    }

    @Override
    public TypeClass getPartialType() {
      if (_unsetProperties.contains(Property.PARTIAL_TYPE)) {
        throw new UnsupportedOperationException("partialType not set");
      }
      return partialType;
    }

    @Override
    public ImmutableSet<QualifiedName> getVisibleNestedTypes() {
      return visibleNestedTypes;
    }

    @Override
    public TypeClass getPropertyEnum() {
      if (_unsetProperties.contains(Property.PROPERTY_ENUM)) {
        throw new UnsupportedOperationException("propertyEnum not set");
      }
      return propertyEnum;
    }

    @Override
    public ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel>
        getStandardMethodUnderrides() {
      return standardMethodUnderrides;
    }

    @Override
    public boolean isBuilderSerializable() {
      if (_unsetProperties.contains(Property.BUILDER_SERIALIZABLE)) {
        throw new UnsupportedOperationException("builderSerializable not set");
      }
      return builderSerializable;
    }

    @Override
    public boolean getHasToBuilderMethod() {
      if (_unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)) {
        throw new UnsupportedOperationException("hasToBuilderMethod not set");
      }
      return hasToBuilderMethod;
    }

    @Override
    public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
      return generatedBuilderAnnotations;
    }

    @Override
    public ImmutableList<Excerpt> getValueTypeAnnotations() {
      return valueTypeAnnotations;
    }

    @Override
    public Datatype.Visibility getValueTypeVisibility() {
      if (_unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)) {
        throw new UnsupportedOperationException("valueTypeVisibility not set");
      }
      return valueTypeVisibility;
    }

    @Override
    public ImmutableList<Excerpt> getNestedClasses() {
      return nestedClasses;
    }

    @Override
    public boolean equals(Object obj) {
      if (!(obj instanceof Partial)) {
        return false;
      }
      Partial other = (Partial) obj;
      if (type != other.type && (type == null || !type.equals(other.type))) {
        return false;
      }
      if (interfaceType != other.interfaceType) {
        return false;
      }
      if (builder != other.builder && (builder == null || !builder.equals(other.builder))) {
        return false;
      }
      if (extensible != other.extensible) {
        return false;
      }
      if (builderFactory != other.builderFactory
          && (builderFactory == null || !builderFactory.equals(other.builderFactory))) {
        return false;
      }
      if (generatedBuilder != other.generatedBuilder
          && (generatedBuilder == null || !generatedBuilder.equals(other.generatedBuilder))) {
        return false;
      }
      if (valueType != other.valueType
          && (valueType == null || !valueType.equals(other.valueType))) {
        return false;
      }
      if (partialType != other.partialType
          && (partialType == null || !partialType.equals(other.partialType))) {
        return false;
      }
      if (!visibleNestedTypes.equals(other.visibleNestedTypes)) {
        return false;
      }
      if (propertyEnum != other.propertyEnum
          && (propertyEnum == null || !propertyEnum.equals(other.propertyEnum))) {
        return false;
      }
      if (!standardMethodUnderrides.equals(other.standardMethodUnderrides)) {
        return false;
      }
      if (builderSerializable != other.builderSerializable) {
        return false;
      }
      if (hasToBuilderMethod != other.hasToBuilderMethod) {
        return false;
      }
      if (!generatedBuilderAnnotations.equals(other.generatedBuilderAnnotations)) {
        return false;
      }
      if (!valueTypeAnnotations.equals(other.valueTypeAnnotations)) {
        return false;
      }
      if (valueTypeVisibility != other.valueTypeVisibility
          && (valueTypeVisibility == null
              || !valueTypeVisibility.equals(other.valueTypeVisibility))) {
        return false;
      }
      if (!nestedClasses.equals(other.nestedClasses)) {
        return false;
      }
      return _unsetProperties.equals(other._unsetProperties);
    }

    @Override
    public int hashCode() {
      return Arrays.hashCode(
          new Object[] {
            type,
            interfaceType,
            builder,
            extensible,
            builderFactory,
            generatedBuilder,
            valueType,
            partialType,
            visibleNestedTypes,
            propertyEnum,
            standardMethodUnderrides,
            builderSerializable,
            hasToBuilderMethod,
            generatedBuilderAnnotations,
            valueTypeAnnotations,
            valueTypeVisibility,
            nestedClasses,
            _unsetProperties
          });
    }

    @Override
    public String toString() {
      StringBuilder result = new StringBuilder("partial Datatype{");
      if (!_unsetProperties.contains(Property.TYPE)) {
        result.append("type=").append(type).append(", ");
      }
      if (!_unsetProperties.contains(Property.INTERFACE_TYPE)) {
        result.append("interfaceType=").append(interfaceType).append(", ");
      }
      if (!_unsetProperties.contains(Property.BUILDER)) {
        result.append("builder=").append(builder).append(", ");
      }
      if (!_unsetProperties.contains(Property.EXTENSIBLE)) {
        result.append("extensible=").append(extensible).append(", ");
      }
      if (builderFactory != null) {
        result.append("builderFactory=").append(builderFactory).append(", ");
      }
      if (!_unsetProperties.contains(Property.GENERATED_BUILDER)) {
        result.append("generatedBuilder=").append(generatedBuilder).append(", ");
      }
      if (!_unsetProperties.contains(Property.VALUE_TYPE)) {
        result.append("valueType=").append(valueType).append(", ");
      }
      if (!_unsetProperties.contains(Property.PARTIAL_TYPE)) {
        result.append("partialType=").append(partialType).append(", ");
      }
      result.append("visibleNestedTypes=").append(visibleNestedTypes);
      if (!_unsetProperties.contains(Property.PROPERTY_ENUM)) {
        result.append(", propertyEnum=").append(propertyEnum);
      }
      result.append(", standardMethodUnderrides=").append(standardMethodUnderrides);
      if (!_unsetProperties.contains(Property.BUILDER_SERIALIZABLE)) {
        result.append(", builderSerializable=").append(builderSerializable);
      }
      if (!_unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)) {
        result.append(", hasToBuilderMethod=").append(hasToBuilderMethod);
      }
      result
          .append(", generatedBuilderAnnotations=")
          .append(generatedBuilderAnnotations)
          .append(", valueTypeAnnotations=")
          .append(valueTypeAnnotations);
      if (!_unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)) {
        result.append(", valueTypeVisibility=").append(valueTypeVisibility);
      }
      return result.append(", nestedClasses=").append(nestedClasses).append("}").toString();
    }
  }
}
