/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Optional;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Datatype_Builder;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.TypeClass;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public abstract class Datatype {
    public abstract TypeClass getType();

    public abstract boolean isInterfaceType();

    public abstract Type getBuilder();

    public abstract boolean isExtensible();

    public abstract Optional<BuilderFactory> getBuilderFactory();

    public abstract TypeClass getGeneratedBuilder();

    public abstract TypeClass getValueType();

    public abstract TypeClass getPartialType();

    public abstract ImmutableSet<QualifiedName> getVisibleNestedTypes();

    public abstract TypeClass getPropertyEnum();

    public UnderrideLevel standardMethodUnderride(StandardMethod standardMethod) {
        UnderrideLevel underrideLevel = this.getStandardMethodUnderrides().get((Object)standardMethod);
        return underrideLevel == null ? UnderrideLevel.ABSENT : underrideLevel;
    }

    public abstract ImmutableMap<StandardMethod, UnderrideLevel> getStandardMethodUnderrides();

    public abstract boolean isBuilderSerializable();

    public abstract boolean getHasToBuilderMethod();

    public abstract ImmutableList<Excerpt> getGeneratedBuilderAnnotations();

    public abstract ImmutableList<Excerpt> getValueTypeAnnotations();

    public abstract Visibility getValueTypeVisibility();

    public abstract ImmutableList<Excerpt> getNestedClasses();

    public Builder toBuilder() {
        return new Builder().mergeFrom(this);
    }

    public static class Builder
    extends Datatype_Builder {
        public Builder() {
            super.setValueTypeVisibility(Visibility.PRIVATE);
            super.setHasToBuilderMethod(false);
        }

        @Override
        public Builder setValueTypeVisibility(Visibility visibility) {
            return super.setValueTypeVisibility(Visibility.mostVisible(this.getValueTypeVisibility(), visibility));
        }

        @Override
        public Datatype build() {
            Datatype datatype = super.build();
            QualifiedName generatedBuilder = datatype.getGeneratedBuilder().getQualifiedName();
            Preconditions.checkState(datatype.getValueType().getQualifiedName().getEnclosingType().equals(generatedBuilder), "%s not a nested class of %s", datatype.getValueType(), generatedBuilder);
            Preconditions.checkState(datatype.getPartialType().getQualifiedName().getEnclosingType().equals(generatedBuilder), "%s not a nested class of %s", datatype.getPartialType(), generatedBuilder);
            Preconditions.checkState(datatype.getPropertyEnum().getQualifiedName().getEnclosingType().equals(generatedBuilder), "%s not a nested class of %s", datatype.getPropertyEnum(), generatedBuilder);
            Preconditions.checkState(!datatype.getVisibleNestedTypes().isEmpty(), "No nested types provided");
            for (QualifiedName nestedType : datatype.getVisibleNestedTypes()) {
                Preconditions.checkState(nestedType.isNestedIn(generatedBuilder), "%s not nested in %s", nestedType, generatedBuilder);
            }
            return datatype;
        }
    }

    public static class Visibility
    extends Excerpt {
        public static final Visibility PUBLIC = new Visibility(0, "PUBLIC", "public ");
        public static final Visibility PROTECTED = new Visibility(1, "PROTECTED", "protected ");
        public static final Visibility PACKAGE = new Visibility(2, "PACKAGE", "");
        public static final Visibility PRIVATE = new Visibility(3, "PRIVATE", "private ");
        private final int order;
        private final String name;
        private final String excerpt;

        Visibility(int order, String name, String excerpt) {
            this.order = order;
            this.name = name;
            this.excerpt = excerpt;
        }

        public static Visibility mostVisible(Visibility a, Visibility b) {
            return a.order < b.order ? a : b;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.add(this.excerpt, new Object[0]);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("excerpt", this.excerpt);
        }
    }

    public static enum UnderrideLevel {
        ABSENT,
        OVERRIDEABLE,
        FINAL;

    }

    public static enum StandardMethod {
        TO_STRING,
        HASH_CODE,
        EQUALS;

    }
}

