/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.TypeClass;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

abstract class Datatype_Builder {
    private TypeClass type;
    private boolean interfaceType;
    private Type builder;
    private boolean extensible;
    private BuilderFactory builderFactory = null;
    private TypeClass generatedBuilder;
    private TypeClass valueType;
    private TypeClass partialType;
    private Set<QualifiedName> visibleNestedTypes = ImmutableSet.of();
    private TypeClass propertyEnum;
    private final LinkedHashMap<Datatype.StandardMethod, Datatype.UnderrideLevel> standardMethodUnderrides = new LinkedHashMap();
    private boolean builderSerializable;
    private boolean hasToBuilderMethod;
    private List<Excerpt> generatedBuilderAnnotations = ImmutableList.of();
    private List<Excerpt> valueTypeAnnotations = ImmutableList.of();
    private Datatype.Visibility valueTypeVisibility;
    private List<Excerpt> nestedClasses = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Datatype_Builder() {
    }

    public static Datatype.Builder from(Datatype value) {
        return new Datatype.Builder().mergeFrom(value);
    }

    public Datatype.Builder setType(TypeClass type) {
        this.type = Objects.requireNonNull(type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapType(UnaryOperator<TypeClass> mapper) {
        Objects.requireNonNull(mapper);
        return this.setType((TypeClass)mapper.apply(this.getType()));
    }

    public TypeClass getType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.TYPE), "type not set");
        return this.type;
    }

    public Datatype.Builder setInterfaceType(boolean interfaceType) {
        this.interfaceType = interfaceType;
        this._unsetProperties.remove((Object)Property.INTERFACE_TYPE);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapInterfaceType(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.setInterfaceType((Boolean)mapper.apply(this.isInterfaceType()));
    }

    public boolean isInterfaceType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.INTERFACE_TYPE), "interfaceType not set");
        return this.interfaceType;
    }

    public Datatype.Builder setBuilder(Type builder) {
        this.builder = Objects.requireNonNull(builder);
        this._unsetProperties.remove((Object)Property.BUILDER);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapBuilder(UnaryOperator<Type> mapper) {
        Objects.requireNonNull(mapper);
        return this.setBuilder((Type)mapper.apply(this.getBuilder()));
    }

    public Type getBuilder() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.BUILDER), "builder not set");
        return this.builder;
    }

    public Datatype.Builder setExtensible(boolean extensible) {
        this.extensible = extensible;
        this._unsetProperties.remove((Object)Property.EXTENSIBLE);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapExtensible(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.setExtensible((Boolean)mapper.apply(this.isExtensible()));
    }

    public boolean isExtensible() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.EXTENSIBLE), "extensible not set");
        return this.extensible;
    }

    public Datatype.Builder setBuilderFactory(BuilderFactory builderFactory) {
        this.builderFactory = Objects.requireNonNull(builderFactory);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder setBuilderFactory(Optional<? extends BuilderFactory> builderFactory) {
        if (builderFactory.isPresent()) {
            return this.setBuilderFactory(builderFactory.get());
        }
        return this.clearBuilderFactory();
    }

    public Datatype.Builder setNullableBuilderFactory(BuilderFactory builderFactory) {
        if (builderFactory != null) {
            return this.setBuilderFactory(builderFactory);
        }
        return this.clearBuilderFactory();
    }

    public Datatype.Builder mapBuilderFactory(UnaryOperator<BuilderFactory> mapper) {
        return this.setBuilderFactory(this.getBuilderFactory().map(mapper));
    }

    public Datatype.Builder clearBuilderFactory() {
        this.builderFactory = null;
        return (Datatype.Builder)this;
    }

    public Optional<BuilderFactory> getBuilderFactory() {
        return Optional.ofNullable(this.builderFactory);
    }

    public Datatype.Builder setGeneratedBuilder(TypeClass generatedBuilder) {
        this.generatedBuilder = Objects.requireNonNull(generatedBuilder);
        this._unsetProperties.remove((Object)Property.GENERATED_BUILDER);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapGeneratedBuilder(UnaryOperator<TypeClass> mapper) {
        Objects.requireNonNull(mapper);
        return this.setGeneratedBuilder((TypeClass)mapper.apply(this.getGeneratedBuilder()));
    }

    public TypeClass getGeneratedBuilder() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.GENERATED_BUILDER), "generatedBuilder not set");
        return this.generatedBuilder;
    }

    public Datatype.Builder setValueType(TypeClass valueType) {
        this.valueType = Objects.requireNonNull(valueType);
        this._unsetProperties.remove((Object)Property.VALUE_TYPE);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapValueType(UnaryOperator<TypeClass> mapper) {
        Objects.requireNonNull(mapper);
        return this.setValueType((TypeClass)mapper.apply(this.getValueType()));
    }

    public TypeClass getValueType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.VALUE_TYPE), "valueType not set");
        return this.valueType;
    }

    public Datatype.Builder setPartialType(TypeClass partialType) {
        this.partialType = Objects.requireNonNull(partialType);
        this._unsetProperties.remove((Object)Property.PARTIAL_TYPE);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapPartialType(UnaryOperator<TypeClass> mapper) {
        Objects.requireNonNull(mapper);
        return this.setPartialType((TypeClass)mapper.apply(this.getPartialType()));
    }

    public TypeClass getPartialType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.PARTIAL_TYPE), "partialType not set");
        return this.partialType;
    }

    public Datatype.Builder addVisibleNestedTypes(QualifiedName element) {
        if (this.visibleNestedTypes instanceof ImmutableSet) {
            this.visibleNestedTypes = new LinkedHashSet<QualifiedName>(this.visibleNestedTypes);
        }
        this.visibleNestedTypes.add(Objects.requireNonNull(element));
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addVisibleNestedTypes(QualifiedName ... elements) {
        return this.addAllVisibleNestedTypes(Arrays.asList(elements));
    }

    public Datatype.Builder addAllVisibleNestedTypes(Spliterator<? extends QualifiedName> elements) {
        elements.forEachRemaining(this::addVisibleNestedTypes);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addAllVisibleNestedTypes(BaseStream<? extends QualifiedName, ?> elements) {
        return this.addAllVisibleNestedTypes(elements.spliterator());
    }

    public Datatype.Builder addAllVisibleNestedTypes(Iterable<? extends QualifiedName> elements) {
        elements.forEach(this::addVisibleNestedTypes);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder removeVisibleNestedTypes(QualifiedName element) {
        if (this.visibleNestedTypes instanceof ImmutableSet) {
            this.visibleNestedTypes = new LinkedHashSet<QualifiedName>(this.visibleNestedTypes);
        }
        this.visibleNestedTypes.remove(Objects.requireNonNull(element));
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mutateVisibleNestedTypes(Consumer<? super Set<QualifiedName>> mutator) {
        if (this.visibleNestedTypes instanceof ImmutableSet) {
            this.visibleNestedTypes = new LinkedHashSet<QualifiedName>(this.visibleNestedTypes);
        }
        mutator.accept(this.visibleNestedTypes);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder clearVisibleNestedTypes() {
        if (this.visibleNestedTypes instanceof ImmutableSet) {
            this.visibleNestedTypes = ImmutableSet.of();
        } else {
            this.visibleNestedTypes.clear();
        }
        return (Datatype.Builder)this;
    }

    public Set<QualifiedName> getVisibleNestedTypes() {
        if (this.visibleNestedTypes instanceof ImmutableSet) {
            this.visibleNestedTypes = new LinkedHashSet<QualifiedName>(this.visibleNestedTypes);
        }
        return Collections.unmodifiableSet(this.visibleNestedTypes);
    }

    public Datatype.Builder setPropertyEnum(TypeClass propertyEnum) {
        this.propertyEnum = Objects.requireNonNull(propertyEnum);
        this._unsetProperties.remove((Object)Property.PROPERTY_ENUM);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapPropertyEnum(UnaryOperator<TypeClass> mapper) {
        Objects.requireNonNull(mapper);
        return this.setPropertyEnum((TypeClass)mapper.apply(this.getPropertyEnum()));
    }

    public TypeClass getPropertyEnum() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.PROPERTY_ENUM), "propertyEnum not set");
        return this.propertyEnum;
    }

    public Datatype.Builder putStandardMethodUnderrides(Datatype.StandardMethod key, Datatype.UnderrideLevel value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.standardMethodUnderrides.put(key, value);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder putAllStandardMethodUnderrides(Map<? extends Datatype.StandardMethod, ? extends Datatype.UnderrideLevel> map) {
        for (Map.Entry<? extends Datatype.StandardMethod, ? extends Datatype.UnderrideLevel> entry : map.entrySet()) {
            this.putStandardMethodUnderrides(entry.getKey(), entry.getValue());
        }
        return (Datatype.Builder)this;
    }

    public Datatype.Builder removeStandardMethodUnderrides(Datatype.StandardMethod key) {
        Objects.requireNonNull(key);
        this.standardMethodUnderrides.remove((Object)key);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mutateStandardMethodUnderrides(Consumer<? super Map<Datatype.StandardMethod, Datatype.UnderrideLevel>> mutator) {
        mutator.accept(this.standardMethodUnderrides);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder clearStandardMethodUnderrides() {
        this.standardMethodUnderrides.clear();
        return (Datatype.Builder)this;
    }

    public Map<Datatype.StandardMethod, Datatype.UnderrideLevel> getStandardMethodUnderrides() {
        return Collections.unmodifiableMap(this.standardMethodUnderrides);
    }

    public Datatype.Builder setBuilderSerializable(boolean builderSerializable) {
        this.builderSerializable = builderSerializable;
        this._unsetProperties.remove((Object)Property.BUILDER_SERIALIZABLE);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapBuilderSerializable(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.setBuilderSerializable((Boolean)mapper.apply(this.isBuilderSerializable()));
    }

    public boolean isBuilderSerializable() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE), "builderSerializable not set");
        return this.builderSerializable;
    }

    public Datatype.Builder setHasToBuilderMethod(boolean hasToBuilderMethod) {
        this.hasToBuilderMethod = hasToBuilderMethod;
        this._unsetProperties.remove((Object)Property.HAS_TO_BUILDER_METHOD);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapHasToBuilderMethod(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.setHasToBuilderMethod((Boolean)mapper.apply(this.getHasToBuilderMethod()));
    }

    public boolean getHasToBuilderMethod() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.HAS_TO_BUILDER_METHOD), "hasToBuilderMethod not set");
        return this.hasToBuilderMethod;
    }

    public Datatype.Builder addGeneratedBuilderAnnotations(Excerpt element) {
        if (this.generatedBuilderAnnotations instanceof ImmutableList) {
            this.generatedBuilderAnnotations = new ArrayList<Excerpt>(this.generatedBuilderAnnotations);
        }
        this.generatedBuilderAnnotations.add(Objects.requireNonNull(element));
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addGeneratedBuilderAnnotations(Excerpt ... elements) {
        return this.addAllGeneratedBuilderAnnotations(Arrays.asList(elements));
    }

    public Datatype.Builder addAllGeneratedBuilderAnnotations(Spliterator<? extends Excerpt> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.generatedBuilderAnnotations instanceof ImmutableList) {
                this.generatedBuilderAnnotations = new ArrayList<Excerpt>(this.generatedBuilderAnnotations);
            }
            ((ArrayList)this.generatedBuilderAnnotations).ensureCapacity(this.generatedBuilderAnnotations.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addGeneratedBuilderAnnotations);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addAllGeneratedBuilderAnnotations(BaseStream<? extends Excerpt, ?> elements) {
        return this.addAllGeneratedBuilderAnnotations(elements.spliterator());
    }

    public Datatype.Builder addAllGeneratedBuilderAnnotations(Iterable<? extends Excerpt> elements) {
        return this.addAllGeneratedBuilderAnnotations(elements.spliterator());
    }

    public Datatype.Builder mutateGeneratedBuilderAnnotations(Consumer<? super List<Excerpt>> mutator) {
        if (this.generatedBuilderAnnotations instanceof ImmutableList) {
            this.generatedBuilderAnnotations = new ArrayList<Excerpt>(this.generatedBuilderAnnotations);
        }
        mutator.accept(this.generatedBuilderAnnotations);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder clearGeneratedBuilderAnnotations() {
        if (this.generatedBuilderAnnotations instanceof ImmutableList) {
            this.generatedBuilderAnnotations = ImmutableList.of();
        } else {
            this.generatedBuilderAnnotations.clear();
        }
        return (Datatype.Builder)this;
    }

    public List<Excerpt> getGeneratedBuilderAnnotations() {
        if (this.generatedBuilderAnnotations instanceof ImmutableList) {
            this.generatedBuilderAnnotations = new ArrayList<Excerpt>(this.generatedBuilderAnnotations);
        }
        return Collections.unmodifiableList(this.generatedBuilderAnnotations);
    }

    public Datatype.Builder addValueTypeAnnotations(Excerpt element) {
        if (this.valueTypeAnnotations instanceof ImmutableList) {
            this.valueTypeAnnotations = new ArrayList<Excerpt>(this.valueTypeAnnotations);
        }
        this.valueTypeAnnotations.add(Objects.requireNonNull(element));
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addValueTypeAnnotations(Excerpt ... elements) {
        return this.addAllValueTypeAnnotations(Arrays.asList(elements));
    }

    public Datatype.Builder addAllValueTypeAnnotations(Spliterator<? extends Excerpt> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.valueTypeAnnotations instanceof ImmutableList) {
                this.valueTypeAnnotations = new ArrayList<Excerpt>(this.valueTypeAnnotations);
            }
            ((ArrayList)this.valueTypeAnnotations).ensureCapacity(this.valueTypeAnnotations.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addValueTypeAnnotations);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addAllValueTypeAnnotations(BaseStream<? extends Excerpt, ?> elements) {
        return this.addAllValueTypeAnnotations(elements.spliterator());
    }

    public Datatype.Builder addAllValueTypeAnnotations(Iterable<? extends Excerpt> elements) {
        return this.addAllValueTypeAnnotations(elements.spliterator());
    }

    public Datatype.Builder mutateValueTypeAnnotations(Consumer<? super List<Excerpt>> mutator) {
        if (this.valueTypeAnnotations instanceof ImmutableList) {
            this.valueTypeAnnotations = new ArrayList<Excerpt>(this.valueTypeAnnotations);
        }
        mutator.accept(this.valueTypeAnnotations);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder clearValueTypeAnnotations() {
        if (this.valueTypeAnnotations instanceof ImmutableList) {
            this.valueTypeAnnotations = ImmutableList.of();
        } else {
            this.valueTypeAnnotations.clear();
        }
        return (Datatype.Builder)this;
    }

    public List<Excerpt> getValueTypeAnnotations() {
        if (this.valueTypeAnnotations instanceof ImmutableList) {
            this.valueTypeAnnotations = new ArrayList<Excerpt>(this.valueTypeAnnotations);
        }
        return Collections.unmodifiableList(this.valueTypeAnnotations);
    }

    public Datatype.Builder setValueTypeVisibility(Datatype.Visibility valueTypeVisibility) {
        this.valueTypeVisibility = Objects.requireNonNull(valueTypeVisibility);
        this._unsetProperties.remove((Object)Property.VALUE_TYPE_VISIBILITY);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mapValueTypeVisibility(UnaryOperator<Datatype.Visibility> mapper) {
        Objects.requireNonNull(mapper);
        return this.setValueTypeVisibility((Datatype.Visibility)mapper.apply(this.getValueTypeVisibility()));
    }

    public Datatype.Visibility getValueTypeVisibility() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY), "valueTypeVisibility not set");
        return this.valueTypeVisibility;
    }

    public Datatype.Builder addNestedClasses(Excerpt element) {
        if (this.nestedClasses instanceof ImmutableList) {
            this.nestedClasses = new ArrayList<Excerpt>(this.nestedClasses);
        }
        this.nestedClasses.add(Objects.requireNonNull(element));
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addNestedClasses(Excerpt ... elements) {
        return this.addAllNestedClasses(Arrays.asList(elements));
    }

    public Datatype.Builder addAllNestedClasses(Spliterator<? extends Excerpt> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.nestedClasses instanceof ImmutableList) {
                this.nestedClasses = new ArrayList<Excerpt>(this.nestedClasses);
            }
            ((ArrayList)this.nestedClasses).ensureCapacity(this.nestedClasses.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addNestedClasses);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder addAllNestedClasses(BaseStream<? extends Excerpt, ?> elements) {
        return this.addAllNestedClasses(elements.spliterator());
    }

    public Datatype.Builder addAllNestedClasses(Iterable<? extends Excerpt> elements) {
        return this.addAllNestedClasses(elements.spliterator());
    }

    public Datatype.Builder mutateNestedClasses(Consumer<? super List<Excerpt>> mutator) {
        if (this.nestedClasses instanceof ImmutableList) {
            this.nestedClasses = new ArrayList<Excerpt>(this.nestedClasses);
        }
        mutator.accept(this.nestedClasses);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder clearNestedClasses() {
        if (this.nestedClasses instanceof ImmutableList) {
            this.nestedClasses = ImmutableList.of();
        } else {
            this.nestedClasses.clear();
        }
        return (Datatype.Builder)this;
    }

    public List<Excerpt> getNestedClasses() {
        if (this.nestedClasses instanceof ImmutableList) {
            this.nestedClasses = new ArrayList<Excerpt>(this.nestedClasses);
        }
        return Collections.unmodifiableList(this.nestedClasses);
    }

    public Datatype.Builder mergeFrom(Datatype value) {
        Datatype.Builder _defaults = new Datatype.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals(value.getType(), ((Datatype_Builder)_defaults).getType())) {
            this.setType(value.getType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.INTERFACE_TYPE) || value.isInterfaceType() != ((Datatype_Builder)_defaults).isInterfaceType()) {
            this.setInterfaceType(value.isInterfaceType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.BUILDER) || !Objects.equals(value.getBuilder(), ((Datatype_Builder)_defaults).getBuilder())) {
            this.setBuilder(value.getBuilder());
        }
        if (_defaults._unsetProperties.contains((Object)Property.EXTENSIBLE) || value.isExtensible() != ((Datatype_Builder)_defaults).isExtensible()) {
            this.setExtensible(value.isExtensible());
        }
        value.getBuilderFactory().ifPresent(this::setBuilderFactory);
        if (_defaults._unsetProperties.contains((Object)Property.GENERATED_BUILDER) || !Objects.equals(value.getGeneratedBuilder(), ((Datatype_Builder)_defaults).getGeneratedBuilder())) {
            this.setGeneratedBuilder(value.getGeneratedBuilder());
        }
        if (_defaults._unsetProperties.contains((Object)Property.VALUE_TYPE) || !Objects.equals(value.getValueType(), ((Datatype_Builder)_defaults).getValueType())) {
            this.setValueType(value.getValueType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.PARTIAL_TYPE) || !Objects.equals(value.getPartialType(), ((Datatype_Builder)_defaults).getPartialType())) {
            this.setPartialType(value.getPartialType());
        }
        if (value instanceof Value && this.visibleNestedTypes == ImmutableSet.of()) {
            this.visibleNestedTypes = ImmutableSet.copyOf(value.getVisibleNestedTypes());
        } else {
            this.addAllVisibleNestedTypes(value.getVisibleNestedTypes());
        }
        if (_defaults._unsetProperties.contains((Object)Property.PROPERTY_ENUM) || !Objects.equals(value.getPropertyEnum(), ((Datatype_Builder)_defaults).getPropertyEnum())) {
            this.setPropertyEnum(value.getPropertyEnum());
        }
        this.putAllStandardMethodUnderrides(value.getStandardMethodUnderrides());
        if (_defaults._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE) || value.isBuilderSerializable() != ((Datatype_Builder)_defaults).isBuilderSerializable()) {
            this.setBuilderSerializable(value.isBuilderSerializable());
        }
        if (_defaults._unsetProperties.contains((Object)Property.HAS_TO_BUILDER_METHOD) || value.getHasToBuilderMethod() != ((Datatype_Builder)_defaults).getHasToBuilderMethod()) {
            this.setHasToBuilderMethod(value.getHasToBuilderMethod());
        }
        if (value instanceof Value && this.generatedBuilderAnnotations == ImmutableList.of()) {
            this.generatedBuilderAnnotations = ImmutableList.copyOf(value.getGeneratedBuilderAnnotations());
        } else {
            this.addAllGeneratedBuilderAnnotations(value.getGeneratedBuilderAnnotations());
        }
        if (value instanceof Value && this.valueTypeAnnotations == ImmutableList.of()) {
            this.valueTypeAnnotations = ImmutableList.copyOf(value.getValueTypeAnnotations());
        } else {
            this.addAllValueTypeAnnotations(value.getValueTypeAnnotations());
        }
        if (_defaults._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY) || !Objects.equals(value.getValueTypeVisibility(), ((Datatype_Builder)_defaults).getValueTypeVisibility())) {
            this.setValueTypeVisibility(value.getValueTypeVisibility());
        }
        if (value instanceof Value && this.nestedClasses == ImmutableList.of()) {
            this.nestedClasses = ImmutableList.copyOf(value.getNestedClasses());
        } else {
            this.addAllNestedClasses(value.getNestedClasses());
        }
        return (Datatype.Builder)this;
    }

    public Datatype.Builder mergeFrom(Datatype.Builder template) {
        Datatype.Builder base = template;
        Datatype.Builder _defaults = new Datatype.Builder();
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !_defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals(template.getType(), ((Datatype_Builder)_defaults).getType()))) {
            this.setType(template.getType());
        }
        if (!base._unsetProperties.contains((Object)Property.INTERFACE_TYPE) && (_defaults._unsetProperties.contains((Object)Property.INTERFACE_TYPE) || template.isInterfaceType() != ((Datatype_Builder)_defaults).isInterfaceType())) {
            this.setInterfaceType(template.isInterfaceType());
        }
        if (!(base._unsetProperties.contains((Object)Property.BUILDER) || !_defaults._unsetProperties.contains((Object)Property.BUILDER) && Objects.equals(template.getBuilder(), ((Datatype_Builder)_defaults).getBuilder()))) {
            this.setBuilder(template.getBuilder());
        }
        if (!base._unsetProperties.contains((Object)Property.EXTENSIBLE) && (_defaults._unsetProperties.contains((Object)Property.EXTENSIBLE) || template.isExtensible() != ((Datatype_Builder)_defaults).isExtensible())) {
            this.setExtensible(template.isExtensible());
        }
        template.getBuilderFactory().ifPresent(this::setBuilderFactory);
        if (!(base._unsetProperties.contains((Object)Property.GENERATED_BUILDER) || !_defaults._unsetProperties.contains((Object)Property.GENERATED_BUILDER) && Objects.equals(template.getGeneratedBuilder(), ((Datatype_Builder)_defaults).getGeneratedBuilder()))) {
            this.setGeneratedBuilder(template.getGeneratedBuilder());
        }
        if (!(base._unsetProperties.contains((Object)Property.VALUE_TYPE) || !_defaults._unsetProperties.contains((Object)Property.VALUE_TYPE) && Objects.equals(template.getValueType(), ((Datatype_Builder)_defaults).getValueType()))) {
            this.setValueType(template.getValueType());
        }
        if (!(base._unsetProperties.contains((Object)Property.PARTIAL_TYPE) || !_defaults._unsetProperties.contains((Object)Property.PARTIAL_TYPE) && Objects.equals(template.getPartialType(), ((Datatype_Builder)_defaults).getPartialType()))) {
            this.setPartialType(template.getPartialType());
        }
        this.addAllVisibleNestedTypes(base.visibleNestedTypes);
        if (!(base._unsetProperties.contains((Object)Property.PROPERTY_ENUM) || !_defaults._unsetProperties.contains((Object)Property.PROPERTY_ENUM) && Objects.equals(template.getPropertyEnum(), ((Datatype_Builder)_defaults).getPropertyEnum()))) {
            this.setPropertyEnum(template.getPropertyEnum());
        }
        this.putAllStandardMethodUnderrides(base.standardMethodUnderrides);
        if (!base._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE) && (_defaults._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE) || template.isBuilderSerializable() != ((Datatype_Builder)_defaults).isBuilderSerializable())) {
            this.setBuilderSerializable(template.isBuilderSerializable());
        }
        if (!base._unsetProperties.contains((Object)Property.HAS_TO_BUILDER_METHOD) && (_defaults._unsetProperties.contains((Object)Property.HAS_TO_BUILDER_METHOD) || template.getHasToBuilderMethod() != ((Datatype_Builder)_defaults).getHasToBuilderMethod())) {
            this.setHasToBuilderMethod(template.getHasToBuilderMethod());
        }
        this.addAllGeneratedBuilderAnnotations(base.generatedBuilderAnnotations);
        this.addAllValueTypeAnnotations(base.valueTypeAnnotations);
        if (!(base._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY) || !_defaults._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY) && Objects.equals(template.getValueTypeVisibility(), ((Datatype_Builder)_defaults).getValueTypeVisibility()))) {
            this.setValueTypeVisibility(template.getValueTypeVisibility());
        }
        this.addAllNestedClasses(base.nestedClasses);
        return (Datatype.Builder)this;
    }

    public Datatype.Builder clear() {
        Datatype.Builder _defaults = new Datatype.Builder();
        this.type = _defaults.type;
        this.interfaceType = _defaults.interfaceType;
        this.builder = _defaults.builder;
        this.extensible = _defaults.extensible;
        this.builderFactory = _defaults.builderFactory;
        this.generatedBuilder = _defaults.generatedBuilder;
        this.valueType = _defaults.valueType;
        this.partialType = _defaults.partialType;
        this.clearVisibleNestedTypes();
        this.propertyEnum = _defaults.propertyEnum;
        this.standardMethodUnderrides.clear();
        this.builderSerializable = _defaults.builderSerializable;
        this.hasToBuilderMethod = _defaults.hasToBuilderMethod;
        this.clearGeneratedBuilderAnnotations();
        this.clearValueTypeAnnotations();
        this.valueTypeVisibility = _defaults.valueTypeVisibility;
        this.clearNestedClasses();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Datatype.Builder)this;
    }

    public Datatype build() {
        Preconditions.checkState(this._unsetProperties.isEmpty(), "Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public Datatype buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Datatype {
        private final TypeClass type;
        private final boolean interfaceType;
        private final Type builder;
        private final boolean extensible;
        private final BuilderFactory builderFactory;
        private final TypeClass generatedBuilder;
        private final TypeClass valueType;
        private final TypeClass partialType;
        private final ImmutableSet<QualifiedName> visibleNestedTypes;
        private final TypeClass propertyEnum;
        private final ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel> standardMethodUnderrides;
        private final boolean builderSerializable;
        private final boolean hasToBuilderMethod;
        private final ImmutableList<Excerpt> generatedBuilderAnnotations;
        private final ImmutableList<Excerpt> valueTypeAnnotations;
        private final Datatype.Visibility valueTypeVisibility;
        private final ImmutableList<Excerpt> nestedClasses;
        private final EnumSet<Property> _unsetProperties;

        Partial(Datatype_Builder builder) {
            this.type = builder.type;
            this.interfaceType = builder.interfaceType;
            this.builder = builder.builder;
            this.extensible = builder.extensible;
            this.builderFactory = builder.builderFactory;
            this.generatedBuilder = builder.generatedBuilder;
            this.valueType = builder.valueType;
            this.partialType = builder.partialType;
            this.visibleNestedTypes = ImmutableSet.copyOf(builder.visibleNestedTypes);
            this.propertyEnum = builder.propertyEnum;
            this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
            this.builderSerializable = builder.builderSerializable;
            this.hasToBuilderMethod = builder.hasToBuilderMethod;
            this.generatedBuilderAnnotations = ImmutableList.copyOf(builder.generatedBuilderAnnotations);
            this.valueTypeAnnotations = ImmutableList.copyOf(builder.valueTypeAnnotations);
            this.valueTypeVisibility = builder.valueTypeVisibility;
            this.nestedClasses = ImmutableList.copyOf(builder.nestedClasses);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public TypeClass getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        public boolean isInterfaceType() {
            if (this._unsetProperties.contains((Object)Property.INTERFACE_TYPE)) {
                throw new UnsupportedOperationException("interfaceType not set");
            }
            return this.interfaceType;
        }

        @Override
        public Type getBuilder() {
            if (this._unsetProperties.contains((Object)Property.BUILDER)) {
                throw new UnsupportedOperationException("builder not set");
            }
            return this.builder;
        }

        @Override
        public boolean isExtensible() {
            if (this._unsetProperties.contains((Object)Property.EXTENSIBLE)) {
                throw new UnsupportedOperationException("extensible not set");
            }
            return this.extensible;
        }

        @Override
        public Optional<BuilderFactory> getBuilderFactory() {
            return Optional.ofNullable(this.builderFactory);
        }

        @Override
        public TypeClass getGeneratedBuilder() {
            if (this._unsetProperties.contains((Object)Property.GENERATED_BUILDER)) {
                throw new UnsupportedOperationException("generatedBuilder not set");
            }
            return this.generatedBuilder;
        }

        @Override
        public TypeClass getValueType() {
            if (this._unsetProperties.contains((Object)Property.VALUE_TYPE)) {
                throw new UnsupportedOperationException("valueType not set");
            }
            return this.valueType;
        }

        @Override
        public TypeClass getPartialType() {
            if (this._unsetProperties.contains((Object)Property.PARTIAL_TYPE)) {
                throw new UnsupportedOperationException("partialType not set");
            }
            return this.partialType;
        }

        @Override
        public ImmutableSet<QualifiedName> getVisibleNestedTypes() {
            return this.visibleNestedTypes;
        }

        @Override
        public TypeClass getPropertyEnum() {
            if (this._unsetProperties.contains((Object)Property.PROPERTY_ENUM)) {
                throw new UnsupportedOperationException("propertyEnum not set");
            }
            return this.propertyEnum;
        }

        @Override
        public ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel> getStandardMethodUnderrides() {
            return this.standardMethodUnderrides;
        }

        @Override
        public boolean isBuilderSerializable() {
            if (this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE)) {
                throw new UnsupportedOperationException("builderSerializable not set");
            }
            return this.builderSerializable;
        }

        @Override
        public boolean getHasToBuilderMethod() {
            if (this._unsetProperties.contains((Object)Property.HAS_TO_BUILDER_METHOD)) {
                throw new UnsupportedOperationException("hasToBuilderMethod not set");
            }
            return this.hasToBuilderMethod;
        }

        @Override
        public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
            return this.generatedBuilderAnnotations;
        }

        @Override
        public ImmutableList<Excerpt> getValueTypeAnnotations() {
            return this.valueTypeAnnotations;
        }

        @Override
        public Datatype.Visibility getValueTypeVisibility() {
            if (this._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY)) {
                throw new UnsupportedOperationException("valueTypeVisibility not set");
            }
            return this.valueTypeVisibility;
        }

        @Override
        public ImmutableList<Excerpt> getNestedClasses() {
            return this.nestedClasses;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.type, other.type) && this.interfaceType == other.interfaceType && Objects.equals(this.builder, other.builder) && this.extensible == other.extensible && Objects.equals((Object)this.builderFactory, (Object)other.builderFactory) && Objects.equals(this.generatedBuilder, other.generatedBuilder) && Objects.equals(this.valueType, other.valueType) && Objects.equals(this.partialType, other.partialType) && Objects.equals(this.visibleNestedTypes, other.visibleNestedTypes) && Objects.equals(this.propertyEnum, other.propertyEnum) && Objects.equals(this.standardMethodUnderrides, other.standardMethodUnderrides) && this.builderSerializable == other.builderSerializable && this.hasToBuilderMethod == other.hasToBuilderMethod && Objects.equals(this.generatedBuilderAnnotations, other.generatedBuilderAnnotations) && Objects.equals(this.valueTypeAnnotations, other.valueTypeAnnotations) && Objects.equals(this.valueTypeVisibility, other.valueTypeVisibility) && Objects.equals(this.nestedClasses, other.nestedClasses) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.interfaceType, this.builder, this.extensible, this.builderFactory, this.generatedBuilder, this.valueType, this.partialType, this.visibleNestedTypes, this.propertyEnum, this.standardMethodUnderrides, this.builderSerializable, this.hasToBuilderMethod, this.generatedBuilderAnnotations, this.valueTypeAnnotations, this.valueTypeVisibility, this.nestedClasses, this._unsetProperties});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial Datatype{");
            if (!this._unsetProperties.contains((Object)Property.TYPE)) {
                result.append("type=").append(this.type).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.INTERFACE_TYPE)) {
                result.append("interfaceType=").append(this.interfaceType).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.BUILDER)) {
                result.append("builder=").append(this.builder).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.EXTENSIBLE)) {
                result.append("extensible=").append(this.extensible).append(", ");
            }
            if (this.builderFactory != null) {
                result.append("builderFactory=").append((Object)this.builderFactory).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.GENERATED_BUILDER)) {
                result.append("generatedBuilder=").append(this.generatedBuilder).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.VALUE_TYPE)) {
                result.append("valueType=").append(this.valueType).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.PARTIAL_TYPE)) {
                result.append("partialType=").append(this.partialType).append(", ");
            }
            result.append("visibleNestedTypes=").append(this.visibleNestedTypes);
            if (!this._unsetProperties.contains((Object)Property.PROPERTY_ENUM)) {
                result.append(", propertyEnum=").append(this.propertyEnum);
            }
            result.append(", standardMethodUnderrides=").append(this.standardMethodUnderrides);
            if (!this._unsetProperties.contains((Object)Property.BUILDER_SERIALIZABLE)) {
                result.append(", builderSerializable=").append(this.builderSerializable);
            }
            if (!this._unsetProperties.contains((Object)Property.HAS_TO_BUILDER_METHOD)) {
                result.append(", hasToBuilderMethod=").append(this.hasToBuilderMethod);
            }
            result.append(", generatedBuilderAnnotations=").append(this.generatedBuilderAnnotations).append(", valueTypeAnnotations=").append(this.valueTypeAnnotations);
            if (!this._unsetProperties.contains((Object)Property.VALUE_TYPE_VISIBILITY)) {
                result.append(", valueTypeVisibility=").append(this.valueTypeVisibility);
            }
            return result.append(", nestedClasses=").append(this.nestedClasses).append("}").toString();
        }
    }

    private static final class Value
    extends Datatype {
        private final TypeClass type;
        private final boolean interfaceType;
        private final Type builder;
        private final boolean extensible;
        private final BuilderFactory builderFactory;
        private final TypeClass generatedBuilder;
        private final TypeClass valueType;
        private final TypeClass partialType;
        private final ImmutableSet<QualifiedName> visibleNestedTypes;
        private final TypeClass propertyEnum;
        private final ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel> standardMethodUnderrides;
        private final boolean builderSerializable;
        private final boolean hasToBuilderMethod;
        private final ImmutableList<Excerpt> generatedBuilderAnnotations;
        private final ImmutableList<Excerpt> valueTypeAnnotations;
        private final Datatype.Visibility valueTypeVisibility;
        private final ImmutableList<Excerpt> nestedClasses;

        private Value(Datatype_Builder builder) {
            this.type = builder.type;
            this.interfaceType = builder.interfaceType;
            this.builder = builder.builder;
            this.extensible = builder.extensible;
            this.builderFactory = builder.builderFactory;
            this.generatedBuilder = builder.generatedBuilder;
            this.valueType = builder.valueType;
            this.partialType = builder.partialType;
            this.visibleNestedTypes = ImmutableSet.copyOf(builder.visibleNestedTypes);
            this.propertyEnum = builder.propertyEnum;
            this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
            this.builderSerializable = builder.builderSerializable;
            this.hasToBuilderMethod = builder.hasToBuilderMethod;
            this.generatedBuilderAnnotations = ImmutableList.copyOf(builder.generatedBuilderAnnotations);
            this.valueTypeAnnotations = ImmutableList.copyOf(builder.valueTypeAnnotations);
            this.valueTypeVisibility = builder.valueTypeVisibility;
            this.nestedClasses = ImmutableList.copyOf(builder.nestedClasses);
        }

        @Override
        public TypeClass getType() {
            return this.type;
        }

        @Override
        public boolean isInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public Type getBuilder() {
            return this.builder;
        }

        @Override
        public boolean isExtensible() {
            return this.extensible;
        }

        @Override
        public Optional<BuilderFactory> getBuilderFactory() {
            return Optional.ofNullable(this.builderFactory);
        }

        @Override
        public TypeClass getGeneratedBuilder() {
            return this.generatedBuilder;
        }

        @Override
        public TypeClass getValueType() {
            return this.valueType;
        }

        @Override
        public TypeClass getPartialType() {
            return this.partialType;
        }

        @Override
        public ImmutableSet<QualifiedName> getVisibleNestedTypes() {
            return this.visibleNestedTypes;
        }

        @Override
        public TypeClass getPropertyEnum() {
            return this.propertyEnum;
        }

        @Override
        public ImmutableMap<Datatype.StandardMethod, Datatype.UnderrideLevel> getStandardMethodUnderrides() {
            return this.standardMethodUnderrides;
        }

        @Override
        public boolean isBuilderSerializable() {
            return this.builderSerializable;
        }

        @Override
        public boolean getHasToBuilderMethod() {
            return this.hasToBuilderMethod;
        }

        @Override
        public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
            return this.generatedBuilderAnnotations;
        }

        @Override
        public ImmutableList<Excerpt> getValueTypeAnnotations() {
            return this.valueTypeAnnotations;
        }

        @Override
        public Datatype.Visibility getValueTypeVisibility() {
            return this.valueTypeVisibility;
        }

        @Override
        public ImmutableList<Excerpt> getNestedClasses() {
            return this.nestedClasses;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.type, other.type) && this.interfaceType == other.interfaceType && Objects.equals(this.builder, other.builder) && this.extensible == other.extensible && Objects.equals((Object)this.builderFactory, (Object)other.builderFactory) && Objects.equals(this.generatedBuilder, other.generatedBuilder) && Objects.equals(this.valueType, other.valueType) && Objects.equals(this.partialType, other.partialType) && Objects.equals(this.visibleNestedTypes, other.visibleNestedTypes) && Objects.equals(this.propertyEnum, other.propertyEnum) && Objects.equals(this.standardMethodUnderrides, other.standardMethodUnderrides) && this.builderSerializable == other.builderSerializable && this.hasToBuilderMethod == other.hasToBuilderMethod && Objects.equals(this.generatedBuilderAnnotations, other.generatedBuilderAnnotations) && Objects.equals(this.valueTypeAnnotations, other.valueTypeAnnotations) && Objects.equals(this.valueTypeVisibility, other.valueTypeVisibility) && Objects.equals(this.nestedClasses, other.nestedClasses);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.interfaceType, this.builder, this.extensible, this.builderFactory, this.generatedBuilder, this.valueType, this.partialType, this.visibleNestedTypes, this.propertyEnum, this.standardMethodUnderrides, this.builderSerializable, this.hasToBuilderMethod, this.generatedBuilderAnnotations, this.valueTypeAnnotations, this.valueTypeVisibility, this.nestedClasses});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Datatype{type=").append(this.type).append(", interfaceType=").append(this.interfaceType).append(", builder=").append(this.builder).append(", extensible=").append(this.extensible);
            if (this.builderFactory != null) {
                result.append(", builderFactory=").append((Object)this.builderFactory);
            }
            return result.append(", generatedBuilder=").append(this.generatedBuilder).append(", valueType=").append(this.valueType).append(", partialType=").append(this.partialType).append(", visibleNestedTypes=").append(this.visibleNestedTypes).append(", propertyEnum=").append(this.propertyEnum).append(", standardMethodUnderrides=").append(this.standardMethodUnderrides).append(", builderSerializable=").append(this.builderSerializable).append(", hasToBuilderMethod=").append(this.hasToBuilderMethod).append(", generatedBuilderAnnotations=").append(this.generatedBuilderAnnotations).append(", valueTypeAnnotations=").append(this.valueTypeAnnotations).append(", valueTypeVisibility=").append(this.valueTypeVisibility).append(", nestedClasses=").append(this.nestedClasses).append("}").toString();
        }
    }

    private static enum Property {
        TYPE("type"),
        INTERFACE_TYPE("interfaceType"),
        BUILDER("builder"),
        EXTENSIBLE("extensible"),
        GENERATED_BUILDER("generatedBuilder"),
        VALUE_TYPE("valueType"),
        PARTIAL_TYPE("partialType"),
        PROPERTY_ENUM("propertyEnum"),
        BUILDER_SERIALIZABLE("builderSerializable"),
        HAS_TO_BUILDER_METHOD("hasToBuilderMethod"),
        VALUE_TYPE_VISIBILITY("valueTypeVisibility");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

