/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.TypeKind;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.GeneratedBuilder;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.FieldAccess;
import org.inferred.freebuilder.processor.util.FunctionalType;
import org.inferred.freebuilder.processor.util.ObjectsExcerpts;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Variable;

class DefaultProperty
extends PropertyCodeGenerator {
    private final boolean hasDefault;
    private final FunctionalType mapperType;
    private final TypeKind kind;

    DefaultProperty(Datatype datatype, Property property, boolean hasDefault, FunctionalType mapperType) {
        super(datatype, property);
        this.hasDefault = hasDefault;
        this.mapperType = mapperType;
        this.kind = property.getType().getKind();
    }

    @Override
    public PropertyCodeGenerator.Initially initialState() {
        return this.hasDefault ? PropertyCodeGenerator.Initially.HAS_DEFAULT : PropertyCodeGenerator.Initially.REQUIRED;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private %s %s;", this.property.getType(), this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetter(code);
        this.addMapper(code);
        this.addGetter(code);
    }

    private void addSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.kind.isPrimitive()) {
            code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
        }
        code.addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.property.getType(), this.property.getName());
        Block body = Block.methodBody(code, this.property.getName());
        if (this.kind.isPrimitive()) {
            body.addLine("  %s = %s;", this.property.getField(), this.property.getName());
        } else {
            body.addLine("  %s = %s.requireNonNull(%s);", this.property.getField(), Objects.class, this.property.getName());
        }
        if (!this.hasDefault) {
            body.addLine("  %s.remove(%s.%s);", GeneratedBuilder.UNSET_PROPERTIES, this.datatype.getPropertyEnum(), this.property.getAllCapsName());
        }
        if (this.datatype.getBuilder() == this.datatype.getGeneratedBuilder()) {
            body.addLine("  return this;", new Object[0]);
        } else {
            body.addLine("  return (%s) this;", this.datatype.getBuilder());
        }
        code.add(body).addLine("}", new Object[0]);
    }

    private void addMapper(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Replaces the value to be returned by %s", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]);
        if (this.mapperType.canReturnNull()) {
            code.addLine(" * or returns null", new Object[0]);
        }
        if (!this.hasDefault) {
            code.addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).add("public %s %s(%s mapper) {", this.datatype.getBuilder(), BuilderMethods.mapper(this.property), this.mapperType.getFunctionalInterface());
        if (!this.hasDefault) {
            code.addLine("  %s.requireNonNull(mapper);", Objects.class);
        }
        code.addLine("  return %s(mapper.%s(%s()));", BuilderMethods.setter(this.property), this.mapperType.getMethodName(), BuilderMethods.getter(this.property)).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName()));
        if (!this.hasDefault) {
            code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property));
        if (!this.hasDefault) {
            Excerpt propertyIsSet = Excerpts.add("!%s.contains(%s.%s)", GeneratedBuilder.UNSET_PROPERTIES, this.datatype.getPropertyEnum(), this.property.getAllCapsName());
            code.add(PreconditionExcerpts.checkState(propertyIsSet, this.property.getName() + " not set", new Object[0]));
        }
        code.addLine("  return %s;", this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        code.add("private final %s %s;\n", this.property.getType(), finalField);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s;", finalField, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(Block code, String value) {
        Excerpt defaults = Declarations.freshBuilder(code, this.datatype).orElse(null);
        if (defaults != null) {
            code.add("if (", new Object[0]);
            if (!this.hasDefault) {
                code.add("%s.contains(%s.%s) || ", GeneratedBuilder.UNSET_PROPERTIES.on(defaults), this.datatype.getPropertyEnum(), this.property.getAllCapsName());
            }
            code.add(ObjectsExcerpts.notEquals(Excerpts.add("%s.%s()", value, this.property.getGetterName()), Excerpts.add("%s.%s()", defaults, BuilderMethods.getter(this.property)), this.kind));
            code.add(") {%n", new Object[0]);
        }
        code.addLine("  %s(%s.%s());", BuilderMethods.setter(this.property), value, this.property.getGetterName());
        if (defaults != null) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addMergeFromBuilder(Block code, String builder) {
        Excerpt base = this.hasDefault ? null : Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        Excerpt defaults = Declarations.freshBuilder(code, this.datatype).orElse(null);
        if (defaults != null) {
            code.add("if (", new Object[0]);
            if (!this.hasDefault) {
                code.add("!%s.contains(%s.%s) && ", GeneratedBuilder.UNSET_PROPERTIES.on(base), this.datatype.getPropertyEnum(), this.property.getAllCapsName()).add("(%s.contains(%s.%s) ||", GeneratedBuilder.UNSET_PROPERTIES.on(defaults), this.datatype.getPropertyEnum(), this.property.getAllCapsName());
            }
            code.add(ObjectsExcerpts.notEquals(Excerpts.add("%s.%s()", builder, BuilderMethods.getter(this.property)), Excerpts.add("%s.%s()", defaults, BuilderMethods.getter(this.property)), this.kind));
            if (!this.hasDefault) {
                code.add(")", new Object[0]);
            }
            code.add(") {%n", new Object[0]);
        } else if (!this.hasDefault) {
            code.addLine("if (!%s.contains(%s.%s)) {", GeneratedBuilder.UNSET_PROPERTIES.on(base), this.datatype.getPropertyEnum(), this.property.getAllCapsName());
        }
        code.addLine("  %s(%s.%s());", BuilderMethods.setter(this.property), builder, BuilderMethods.getter(this.property));
        if (defaults != null || !this.hasDefault) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addSetBuilderFromPartial(Block code, Variable builder) {
        if (!this.hasDefault) {
            code.add("if (!%s.contains(%s.%s)) {", GeneratedBuilder.UNSET_PROPERTIES, this.datatype.getPropertyEnum(), this.property.getAllCapsName());
        }
        code.addLine("  %s.%s(%s);", builder, BuilderMethods.setter(this.property), this.property.getField());
        if (!this.hasDefault) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
    }

    @Override
    public void addClearField(Block code) {
        Optional<Excerpt> defaults = Declarations.freshBuilder(code, this.datatype);
        if (defaults.isPresent()) {
            code.addLine("%s = %s;", this.property.getField(), this.property.getField().on(defaults.get()));
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<DefaultProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            boolean hasDefault = config.getMethodsInvokedInBuilderConstructor().contains(BuilderMethods.setter(property));
            FunctionalType mapperType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mapper(property), FunctionalType.unboxedUnaryOperator(property.getType(), config.getTypes()), config.getElements(), config.getTypes());
            return Optional.of(new DefaultProperty(config.getDatatype(), property, hasDefault, mapperType));
        }
    }
}

