/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.FieldAccess;
import org.inferred.freebuilder.processor.util.FunctionalType;
import org.inferred.freebuilder.processor.util.ObjectsExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.TypeMirrorExcerpt;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

class NullableProperty
extends PropertyCodeGenerator {
    private final Set<TypeElement> nullables;
    private final FunctionalType mapperType;

    NullableProperty(Datatype datatype, Property property, Iterable<TypeElement> nullableAnnotations, FunctionalType mapperType) {
        super(datatype, property);
        this.nullables = ImmutableSet.copyOf(nullableAnnotations);
        this.mapperType = mapperType;
    }

    @Override
    public PropertyCodeGenerator.Initially initialState() {
        return PropertyCodeGenerator.Initially.OPTIONAL;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        this.addGetterAnnotations(code);
        code.add("private %s %s = null;\n", this.property.getType(), this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetter(code);
        this.addMapper(code);
        this.addGetter(code);
    }

    private void addSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.add("public %s %s(", this.datatype.getBuilder(), BuilderMethods.setter(this.property));
        this.addGetterAnnotations(code);
        code.add("%s %s) {\n", this.property.getType(), this.property.getName()).add(Block.methodBody(code, this.property.getName()).addLine("  %s = %s;", this.property.getField(), this.property.getName()).addLine("  return (%s) this;", this.datatype.getBuilder())).addLine("}", new Object[0]);
    }

    private void addMapper(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * If the value to be returned by %s is not", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * null, replaces it by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mapper) {", this.datatype.getBuilder(), BuilderMethods.mapper(this.property), this.mapperType.getFunctionalInterface()).addLine("  %s.requireNonNull(mapper);", Objects.class);
        Block body = Block.methodBody(code, "mapper");
        Excerpt propertyValue = body.declare(new TypeMirrorExcerpt(this.property.getType()), this.property.getName(), Excerpts.add("%s()", BuilderMethods.getter(this.property)));
        body.addLine("  if (%s != null) {", propertyValue).addLine("    %s(mapper.%s(%s));", BuilderMethods.setter(this.property), this.mapperType.getMethodName(), propertyValue).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder());
        code.add(body).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]);
        this.addGetterAnnotations(code);
        code.addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property)).addLine("  return %s;", this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        this.addGetterAnnotations(code);
        code.add("private final %s %s;\n", this.property.getType(), finalField);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s;", finalField, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(Block code, String value) {
        Excerpt defaults = Declarations.freshBuilder(code, this.datatype).orElse(null);
        if (defaults != null) {
            code.addLine("if (%s) {", ObjectsExcerpts.notEquals(Excerpts.add("%s.%s()", value, this.property.getGetterName()), Excerpts.add("%s.%s()", defaults, BuilderMethods.getter(this.property)), TypeKind.DECLARED));
        }
        code.addLine("  %s(%s.%s());", BuilderMethods.setter(this.property), value, this.property.getGetterName());
        if (defaults != null) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addMergeFromBuilder(Block code, String builder) {
        Excerpt defaults = Declarations.freshBuilder(code, this.datatype).orElse(null);
        if (defaults != null) {
            code.addLine("if (%s) {", ObjectsExcerpts.notEquals(Excerpts.add("%s.%s()", builder, BuilderMethods.getter(this.property)), Excerpts.add("%s.%s()", defaults, BuilderMethods.getter(this.property)), TypeKind.DECLARED));
        }
        code.addLine("  %s(%s.%s());", BuilderMethods.setter(this.property), builder, BuilderMethods.getter(this.property));
        if (defaults != null) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addGetterAnnotations(SourceBuilder code) {
        for (TypeElement nullableAnnotation : this.nullables) {
            code.add("@%s ", nullableAnnotation);
        }
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
    }

    @Override
    public void addClearField(Block code) {
        Optional<Excerpt> defaults = Declarations.freshBuilder(code, this.datatype);
        if (defaults.isPresent()) {
            code.addLine("%s = %s;", this.property.getField(), this.property.getField().on(defaults.get()));
        } else {
            code.addLine("%s = null;", this.property.getField());
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<NullableProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            boolean isPrimitive = property.getType().getKind().isPrimitive();
            Set<TypeElement> nullableAnnotations = Factory.nullablesIn(config.getAnnotations());
            if (isPrimitive || nullableAnnotations.isEmpty()) {
                return Optional.empty();
            }
            FunctionalType mapperType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mapper(property), FunctionalType.unaryOperator(property.getBoxedType().orElse(property.getType())), config.getElements(), config.getTypes());
            return Optional.of(new NullableProperty(config.getDatatype(), property, nullableAnnotations, mapperType));
        }

        private static Set<TypeElement> nullablesIn(Iterable<? extends AnnotationMirror> annotations) {
            ImmutableSet.Builder nullableAnnotations = ImmutableSet.builder();
            for (AnnotationMirror annotationMirror : annotations) {
                TypeElement type;
                if (!annotationMirror.getElementValues().isEmpty() || !(type = (TypeElement)annotationMirror.getAnnotationType().asElement()).getSimpleName().contentEquals("Nullable")) continue;
                nullableAnnotations.add(type);
            }
            return nullableAnnotations.build();
        }
    }
}

