/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.FieldAccess;
import org.inferred.freebuilder.processor.util.FunctionalType;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Variable;
import org.inferred.freebuilder.processor.util.feature.Jsr305;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Optional;

class OptionalProperty
extends PropertyCodeGenerator {
    private final OptionalType optional;
    private final TypeMirror elementType;
    private final java.util.Optional<TypeMirror> unboxedType;
    private final FunctionalType mapperType;

    @VisibleForTesting
    OptionalProperty(Datatype datatype, Property property, OptionalType optional, TypeMirror elementType, java.util.Optional<TypeMirror> unboxedType, FunctionalType mapperType) {
        super(datatype, property);
        this.optional = optional;
        this.elementType = elementType;
        this.unboxedType = unboxedType;
        this.mapperType = mapperType;
    }

    @Override
    public PropertyCodeGenerator.Initially initialState() {
        return PropertyCodeGenerator.Initially.OPTIONAL;
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        code.addLine("// Store a nullable object instead of an Optional. Escape analysis then", new Object[0]).addLine("// allows the JVM to optimize away the Optional objects created by our", new Object[0]).addLine("// getter method.", new Object[0]).addLine("private final %s %s;", this.elementType, finalField);
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("// Store a nullable object instead of an Optional. Escape analysis then", new Object[0]).addLine("// allows the JVM to optimize away the Optional objects created by and", new Object[0]).addLine("// passed to our API.", new Object[0]).addLine("private %s %s = null;", this.elementType, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetter(code);
        this.addOptionalSetter(code);
        this.addNullableSetter(code);
        this.addMapper(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.unboxedType.orElse(this.elementType), this.property.getName());
        Block body = Block.methodBody(code, this.property.getName());
        if (this.unboxedType.isPresent()) {
            body.addLine("  %s = %s;", this.property.getField(), this.property.getName());
        } else {
            body.addLine("  %s = %s.requireNonNull(%s);", this.property.getField(), Objects.class, this.property.getName());
        }
        body.addLine("  return (%s) this;", this.datatype.getBuilder());
        code.add(body).addLine("}", new Object[0]);
    }

    private void addOptionalSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s> %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.optional.cls, this.elementType, this.property.getName()).add(Block.methodBody(code, this.property.getName()).addLine("  if (%s.isPresent()) {", this.property.getName()).addLine("    return %s(%s.get());", BuilderMethods.setter(this.property), this.property.getName()).addLine("  } else {", new Object[0]).addLine("    return %s();", BuilderMethods.clearMethod(this.property)).addLine("  }", new Object[0])).addLine("}", new Object[0]);
    }

    private void addNullableSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s(%s %s %s) {", this.datatype.getBuilder(), BuilderMethods.nullableSetter(this.property), Jsr305.nullable(), this.elementType, this.property.getName()).add(Block.methodBody(code, this.property.getName()).addLine("  if (%s != null) {", this.property.getName()).addLine("    return %s(%s);", BuilderMethods.setter(this.property), this.property.getName()).addLine("  } else {", new Object[0]).addLine("    return %s();", BuilderMethods.clearMethod(this.property)).addLine("  }", new Object[0])).addLine("}", new Object[0]);
    }

    private void addMapper(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * If the value to be returned by %s is present,", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * replaces it by applying {@code mapper} to it and using the result.", new Object[0]);
        if (this.mapperType.canReturnNull()) {
            code.addLine(" *", new Object[0]).addLine(" * <p>If the result is null, clears the value.", new Object[0]);
        }
        code.addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mapper) {", this.datatype.getBuilder(), BuilderMethods.mapper(this.property), this.mapperType.getFunctionalInterface());
        this.optional.applyMapper(code, this.datatype, this.mapperType, this.property);
        code.addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * to {@link %1$s#%2$s() Optional.%2$s()}.", this.optional.cls, this.optional.empty).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s = null;", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property)).addLine("  return %s.%s(%s);\n", this.optional.cls, this.optional.ofNullable, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s;", finalField, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(Block code, String value) {
        String propertyValue = value + "." + this.property.getGetterName() + "()";
        this.optional.invokeIfPresent(code, propertyValue, BuilderMethods.setter(this.property));
    }

    @Override
    public void addMergeFromBuilder(Block code, String builder) {
        String propertyValue = builder + "." + BuilderMethods.getter(this.property) + "()";
        this.optional.invokeIfPresent(code, propertyValue, BuilderMethods.setter(this.property));
    }

    @Override
    public void addSetBuilderFromPartial(Block code, Variable builder) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.nullableSetter(this.property), this.property.getField());
    }

    @Override
    public void addReadValueFragment(SourceBuilder code, Excerpt finalField) {
        code.add("%s.%s(%s)", this.optional.cls, this.optional.ofNullable, finalField);
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
    }

    @Override
    public void addClearField(Block code) {
        java.util.Optional<Excerpt> defaults = Declarations.freshBuilder(code, this.datatype);
        if (defaults.isPresent()) {
            code.addLine("%s = %s;", this.property.getField(), this.property.getField().on(defaults.get()));
        } else {
            code.addLine("%s = null;", this.property.getField());
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public java.util.Optional<OptionalProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            DeclaredType type = ModelUtils.maybeDeclared(property.getType()).orElse(null);
            if (type == null) {
                return java.util.Optional.empty();
            }
            OptionalType optionalType = Factory.maybeOptional(type).orElse(null);
            if (optionalType == null) {
                return java.util.Optional.empty();
            }
            TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
            java.util.Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
            FunctionalType mapperType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mapper(property), FunctionalType.unaryOperator(elementType), config.getElements(), config.getTypes());
            return java.util.Optional.of(new OptionalProperty(config.getDatatype(), property, optionalType, elementType, unboxedType, mapperType));
        }

        private static java.util.Optional<OptionalType> maybeOptional(DeclaredType type) {
            for (OptionalType optionalType : OptionalType.values()) {
                if (!Util.erasesToAnyOf(type, optionalType.cls)) continue;
                return java.util.Optional.of(optionalType);
            }
            return java.util.Optional.empty();
        }
    }

    @VisibleForTesting
    static enum OptionalType {
        GUAVA(QualifiedName.of(Optional.class), "absent", "fromNullable"){

            @Override
            protected void applyMapper(SourceBuilder code, Datatype datatype, FunctionalType mapperType, Property property) {
                if (mapperType.canReturnNull()) {
                    code.addLine("%s.requireNonNull(mapper);", Objects.class).addLine("  %s old%s = %s();", property.getType(), property.getCapitalizedName(), BuilderMethods.getter(property)).addLine("  if (old%s.isPresent()) {", property.getCapitalizedName()).addLine("     %s(mapper.%s(old%s.get()));", BuilderMethods.nullableSetter(property), mapperType.getMethodName(), property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", datatype.getBuilder());
                } else {
                    code.addLine("  return %s(%s().transform(mapper::%s));", BuilderMethods.setter(property), BuilderMethods.getter(property), mapperType.getMethodName());
                }
            }

            @Override
            protected void invokeIfPresent(SourceBuilder code, String value, String method) {
                code.addLine("if (%s.isPresent()) {", value).addLine("  %s(%s.get());", method, value).addLine("}", new Object[0]);
            }
        }
        ,
        JAVA8(QualifiedName.of(java.util.Optional.class), "empty", "ofNullable"){

            @Override
            protected void applyMapper(SourceBuilder code, Datatype datatype, FunctionalType mapperType, Property property) {
                code.add("  return %s(%s().map(mapper", BuilderMethods.setter(property), BuilderMethods.getter(property));
                if (!mapperType.getFunctionalInterface().getQualifiedName().equals(QualifiedName.of(UnaryOperator.class))) {
                    code.add("::%s", mapperType.getMethodName());
                }
                code.add("));%n", new Object[0]);
            }

            @Override
            protected void invokeIfPresent(SourceBuilder code, String value, String method) {
                code.addLine("%s.ifPresent(this::%s);", value, method);
            }
        };

        private final QualifiedName cls;
        private final String empty;
        private final String ofNullable;

        private OptionalType(QualifiedName cls, String empty, String ofNullable) {
            this.cls = cls;
            this.empty = empty;
            this.ofNullable = ofNullable;
        }

        protected abstract void applyMapper(SourceBuilder var1, Datatype var2, FunctionalType var3, Property var4);

        protected abstract void invokeIfPresent(SourceBuilder var1, String var2, String var3);
    }
}

