/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.FreeBuilder;
import org.inferred.freebuilder.processor.Analyser;
import org.inferred.freebuilder.processor.GeneratedType;
import org.inferred.freebuilder.processor.MethodIntrospector;
import org.inferred.freebuilder.processor.util.CompilationUnitBuilder;
import org.inferred.freebuilder.processor.util.FilerUtils;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.RoundEnvironments;
import org.inferred.freebuilder.processor.util.feature.EnvironmentFeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.shaded.com.google.auto.service.AutoService;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.MoreObjects;
import org.inferred.freebuilder.shaded.com.google.common.base.Objects;
import org.inferred.freebuilder.shaded.com.google.common.base.Throwables;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.MapMaker;

@AutoService(value=javax.annotation.processing.Processor.class)
public class Processor
extends AbstractProcessor {
    private static final ConcurrentMap<ProcessingEnvironment, Processor> registeredProcessors = new MapMaker().weakKeys().weakValues().concurrencyLevel(1).initialCapacity(1).makeMap();
    private Analyser analyser;
    private final FeatureSet features;
    private transient FeatureSet environmentFeatures;

    public Processor() {
        this.features = null;
    }

    @VisibleForTesting
    public Processor(FeatureSet features) {
        this.features = features;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of(FreeBuilder.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (registeredProcessors.putIfAbsent(processingEnv, this) != null) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "FreeBuilder processor registered twice; disabling duplicate instance");
            return;
        }
        this.analyser = new Analyser(processingEnv.getElementUtils(), processingEnv.getMessager(), MethodIntrospector.instance(processingEnv), processingEnv.getTypeUtils());
        if (this.features == null) {
            this.environmentFeatures = new EnvironmentFeatureSet(processingEnv);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.analyser == null) {
            return false;
        }
        for (TypeElement type : ElementFilter.typesIn(RoundEnvironments.annotatedElementsIn(roundEnv, FreeBuilder.class))) {
            try {
                GeneratedType builder = this.analyser.analyse(type);
                CompilationUnitBuilder code = new CompilationUnitBuilder(this.processingEnv, builder.getName(), builder.getVisibleNestedTypes(), MoreObjects.firstNonNull(this.features, this.environmentFeatures));
                code.add(builder);
                FilerUtils.writeCompilationUnit(this.processingEnv.getFiler(), builder.getName(), type, code.toString());
            }
            catch (Analyser.CannotGenerateCodeException builder) {
            }
            catch (FilerException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Error producing Builder: " + e.getMessage(), type, ModelUtils.findAnnotationMirror((Element)type, "org.inferred.freebuilder.FreeBuilder").get());
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "I/O error: " + Throwables.getStackTraceAsString(e), type, ModelUtils.findAnnotationMirror((Element)type, "org.inferred.freebuilder.FreeBuilder").get());
            }
            catch (RuntimeException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error: " + Throwables.getStackTraceAsString(e), type, ModelUtils.findAnnotationMirror((Element)type, "org.inferred.freebuilder.FreeBuilder").get());
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)obj;
        return Objects.equal(this.features, other.features);
    }

    public int hashCode() {
        return Objects.hashCode(Processor.class, this.features);
    }
}

