/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.BaseStream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedSet;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.FunctionalType;
import org.inferred.freebuilder.processor.util.LazyName;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

class SetProperty
extends PropertyCodeGenerator {
    private final TypeMirror elementType;
    private final Optional<TypeMirror> unboxedType;
    private final FunctionalType mutatorType;
    private final boolean needsSafeVarargs;
    private final boolean overridesAddMethod;
    private final boolean overridesVarargsAddMethod;

    SetProperty(Datatype datatype, Property property, TypeMirror elementType, Optional<TypeMirror> unboxedType, FunctionalType mutatorType, boolean needsSafeVarargs, boolean overridesAddMethod, boolean overridesVarargsAddMethod) {
        super(datatype, property);
        this.elementType = elementType;
        this.unboxedType = unboxedType;
        this.mutatorType = mutatorType;
        this.needsSafeVarargs = needsSafeVarargs;
        this.overridesAddMethod = overridesAddMethod;
        this.overridesVarargsAddMethod = overridesVarargsAddMethod;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("private %s<%s> %s = %s.of();", Set.class, this.elementType, this.property.getField(), ImmutableSet.class);
        } else {
            code.addLine("private final %1$s<%2$s> %3$s = new %1$s<>();", LinkedHashSet.class, this.elementType, this.property.getField());
        }
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addAdd(code);
        this.addVarargsAdd(code);
        this.addSpliteratorAddAll(code);
        this.addStreamAddAll(code);
        this.addIterableAddAll(code);
        this.addRemove(code);
        this.addMutator(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the set already contains {@code element}, then {@code %s}", BuilderMethods.addMethod(this.property)).addLine(" * has no effect (only the previously added element is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType));
        Block body = Block.methodBody(code, "element");
        if (body.feature(GuavaLibrary.GUAVA).isAvailable()) {
            body.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableSet.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), LinkedHashSet.class).addLine("  }", new Object[0]);
        }
        if (this.unboxedType.isPresent()) {
            body.addLine("  %s.add(element);", this.property.getField());
        } else {
            body.addLine("  %s.add(%s.requireNonNull(element));", this.property.getField(), Objects.class);
        }
        body.addLine("  return (%s) this;", this.datatype.getBuilder());
        code.add(body).addLine("}", new Object[0]);
    }

    private void addVarargsAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate elements", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
        }
        code.addLine(" */", new Object[0]);
        if (this.needsSafeVarargs) {
            if (!this.overridesVarargsAddMethod) {
                code.addLine("@%s", SafeVarargs.class).addLine("@%s({\"varargs\"})", SuppressWarnings.class);
            } else {
                code.addLine("@%s({\"unchecked\", \"varargs\"})", SuppressWarnings.class);
            }
        }
        code.add("public ", new Object[0]);
        if (this.needsSafeVarargs && !this.overridesVarargsAddMethod) {
            code.add("final ", new Object[0]);
        }
        code.add("%s %s(%s... elements) {\n", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType));
        Optional<Class<?>> arrayUtils = code.feature(GuavaLibrary.GUAVA).arrayUtils(this.unboxedType.orElse(this.elementType));
        if (arrayUtils.isPresent()) {
            code.addLine("  return %s(%s.asList(elements));", BuilderMethods.addAllMethod(this.property), arrayUtils.get());
        } else {
            code.addLine("  for (%s element : elements) {", this.elementType).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder());
        }
        code.addLine("}", new Object[0]);
    }

    private void addSpliteratorAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Spliterator.class, this.elementType).addLine("  elements.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addStreamAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s, ?> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), BaseStream.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addIterableAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  elements.forEach(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addJavadocForAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate elements", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
    }

    private void addRemove(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes {@code element} from the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Does nothing if {@code element} is not a member of the set.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedType.orElse(this.elementType));
        Block body = Block.methodBody(code, "element");
        if (body.feature(GuavaLibrary.GUAVA).isAvailable()) {
            body.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableSet.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), LinkedHashSet.class).addLine("  }", new Object[0]);
        }
        if (this.unboxedType.isPresent()) {
            body.addLine("  %s.remove(element);", this.property.getField());
        } else {
            body.addLine("  %s.remove(%s.requireNonNull(element));", this.property.getField(), Objects.class);
        }
        body.addLine("  return (%s) this;", this.datatype.getBuilder());
        code.add(body).addLine("}", new Object[0]);
    }

    private void addMutator(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the set in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        Block body = Block.methodBody(code, "mutator");
        if (body.feature(GuavaLibrary.GUAVA).isAvailable()) {
            body.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableSet.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), LinkedHashSet.class).addLine("  }", new Object[0]);
        }
        if (this.overridesAddMethod) {
            body.addLine("  mutator.%s(new %s<%s>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedSet.TYPE, this.elementType, this.property.getField(), BuilderMethods.addMethod(this.property));
        } else {
            body.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.addMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        body.addLine("  return (%s) this;", this.datatype.getBuilder());
        code.add(body).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("if (%s instanceof %s) {", this.property.getField(), ImmutableSet.class).addLine("  %s = %s.of();", this.property.getField(), ImmutableSet.class).addLine("} else {", new Object[0]);
        }
        code.addLine("%s.clear();", this.property.getField());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("}", new Object[0]);
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the set that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", Set.class, this.elementType, BuilderMethods.getter(this.property));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableSet.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), LinkedHashSet.class).addLine("  }", new Object[0]);
        }
        code.addLine("  return %s.unmodifiableSet(%s);", Collections.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        Excerpt immutableSetMethod = code.feature(GuavaLibrary.GUAVA).isAvailable() ? Excerpts.add("%s.copyOf", ImmutableSet.class) : ImmutableSetMethod.REFERENCE;
        code.addLine("%s = %s(%s);", finalField, immutableSetMethod, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(Block code, String value) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("if (%s instanceof %s && %s == %s.<%s>of()) {", value, this.datatype.getValueType().getQualifiedName(), this.property.getField(), ImmutableSet.class, this.elementType).addLine("  %s = %s.copyOf(%s.%s());", this.property.getField(), ImmutableSet.class, value, this.property.getGetterName()).addLine("} else {", new Object[0]);
        }
        code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addMergeFromBuilder(Block code, String builder) {
        Excerpt base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.addAllMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(Block code) {
        code.addLine("%s();", BuilderMethods.clearMethod(this.property));
    }

    private static class ImmutableSetMethod
    extends Excerpt {
        static final LazyName REFERENCE = new LazyName("immutableSet", new ImmutableSetMethod());

        private ImmutableSetMethod() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static <E> %1$s<E> %2$s(%1$s<E> elements) {", Set.class, REFERENCE).addLine("  switch (elements.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptySet();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    return %s.singleton(elements.iterator().next());", Collections.class).addLine("  default:", new Object[0]).addLine("    return %s.unmodifiableSet(new %s<>(elements));", Collections.class, LinkedHashSet.class).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<SetProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType type = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (type == null || !Util.erasesToAnyOf(type, Set.class, ImmutableSet.class)) {
                return Optional.empty();
            }
            TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
            Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
            boolean needsSafeVarargs = ModelUtils.needsSafeVarargs(unboxedType.orElse(elementType));
            boolean overridesAddMethod = Factory.hasAddMethodOverride(config, unboxedType.orElse(elementType));
            boolean overridesVarargsAddMethod = Factory.hasVarargsAddMethodOverride(config, unboxedType.orElse(elementType));
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(config.getProperty()), FunctionalType.consumer(Factory.wildcardSuperSet(elementType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new SetProperty(config.getDatatype(), config.getProperty(), elementType, unboxedType, mutatorType, needsSafeVarargs, overridesAddMethod, overridesVarargsAddMethod));
        }

        private static boolean hasAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), elementType);
        }

        private static boolean hasVarargsAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), config.getTypes().getArrayType(elementType));
        }

        private static TypeMirror wildcardSuperSet(TypeMirror elementType, Elements elements, Types types) {
            TypeElement setType = elements.getTypeElement(Set.class.getName());
            return types.getWildcardType(null, types.getDeclaredType(setType, elementType));
        }
    }
}

