/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.GeneratedBuilder;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Block;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Variable;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;

class ToStringGenerator {
    public static void addToString(SourceBuilder code, Datatype datatype, Map<Property, PropertyCodeGenerator> generatorsByProperty, boolean forPartial) {
        String typename = (forPartial ? "partial " : "") + datatype.getType().getSimpleName();
        Predicate<PropertyCodeGenerator> isOptional = generator -> {
            PropertyCodeGenerator.Initially initially = generator.initialState();
            return initially == PropertyCodeGenerator.Initially.OPTIONAL || initially == PropertyCodeGenerator.Initially.REQUIRED && forPartial;
        };
        boolean anyOptional = generatorsByProperty.values().stream().anyMatch(isOptional);
        boolean allOptional = generatorsByProperty.values().stream().allMatch(isOptional) && !generatorsByProperty.isEmpty();
        code.addLine("", new Object[0]).addLine("@%s", Override.class).addLine("public %s toString() {", String.class);
        Block body = Block.methodBody(code, new String[0]);
        if (allOptional) {
            ToStringGenerator.bodyWithBuilderAndSeparator(body, datatype, generatorsByProperty, typename);
        } else if (anyOptional) {
            ToStringGenerator.bodyWithBuilder(body, datatype, generatorsByProperty, typename, isOptional);
        } else {
            ToStringGenerator.bodyWithConcatenation(body, generatorsByProperty.keySet(), typename);
        }
        code.add(body).addLine("}", new Object[0]);
    }

    private static void bodyWithConcatenation(Block code, Collection<Property> properties, String typename) {
        code.add("  return \"%s{", typename);
        String prefix = "";
        for (Property property : properties) {
            code.add("%s%s=\" + %s + \"", prefix, property.getName(), property.getField());
            prefix = ", ";
        }
        code.add("}\";%n", new Object[0]);
    }

    private static void bodyWithBuilder(Block code, Datatype datatype, Map<Property, PropertyCodeGenerator> generatorsByProperty, String typename, Predicate<PropertyCodeGenerator> isOptional) {
        Variable result = new Variable("result");
        code.add("  %1$s %2$s = new %1$s(\"%3$s{", StringBuilder.class, result, typename);
        boolean midStringLiteral = true;
        boolean midAppends = true;
        boolean prependCommas = false;
        PropertyCodeGenerator lastOptionalGenerator = generatorsByProperty.values().stream().filter(isOptional).reduce((first, second) -> second).get();
        for (Property property : generatorsByProperty.keySet()) {
            PropertyCodeGenerator generator = generatorsByProperty.get(property);
            if (isOptional.test(generator)) {
                if (midStringLiteral) {
                    code.add("\")", new Object[0]);
                }
                if (midAppends) {
                    code.add(";%n  ", new Object[0]);
                }
                code.add("if (", new Object[0]);
                if (generator.initialState() == PropertyCodeGenerator.Initially.OPTIONAL) {
                    code.add("%s != null", property.getField());
                } else {
                    code.add("!%s.contains(%s.%s)", GeneratedBuilder.UNSET_PROPERTIES, datatype.getPropertyEnum(), property.getAllCapsName());
                }
                code.add(") {%n    %s.append(\"", result);
                if (prependCommas) {
                    code.add(", ", new Object[0]);
                }
                code.add("%s=\").append(%s)", property.getName(), property.getField());
                if (!prependCommas) {
                    code.add(".append(\", \")", new Object[0]);
                }
                code.add(";%n  }%n  ", new Object[0]);
                if (generator.equals(lastOptionalGenerator)) {
                    code.add("return %s.append(\"", result);
                    midStringLiteral = true;
                    midAppends = true;
                    continue;
                }
                midStringLiteral = false;
                midAppends = false;
                continue;
            }
            if (!midAppends) {
                code.add("%s", result);
            }
            if (!midStringLiteral) {
                code.add(".append(\"", new Object[0]);
            }
            if (prependCommas) {
                code.add(", ", new Object[0]);
            }
            code.add("%s=\").append(%s)", property.getName(), property.getField());
            midStringLiteral = false;
            midAppends = true;
            prependCommas = true;
        }
        Preconditions.checkState(prependCommas, "Unexpected state at end of toString method");
        Preconditions.checkState(midAppends, "Unexpected state at end of toString method");
        if (!midStringLiteral) {
            code.add(".append(\"", new Object[0]);
        }
        code.add("}\").toString();%n", result);
    }

    private static void bodyWithBuilderAndSeparator(Block code, Datatype datatype, Map<Property, PropertyCodeGenerator> generatorsByProperty, String typename) {
        Variable result = new Variable("result");
        Variable separator = new Variable("separator");
        code.addLine("  %1$s %2$s = new %1$s(\"%3$s{\");", StringBuilder.class, result, typename);
        if (generatorsByProperty.size() > 1) {
            code.addLine("  %s %s = \"\";", String.class, separator);
        }
        Property first = generatorsByProperty.keySet().iterator().next();
        Property last = Iterables.getLast(generatorsByProperty.keySet());
        for (Property property : generatorsByProperty.keySet()) {
            PropertyCodeGenerator generator = generatorsByProperty.get(property);
            switch (generator.initialState()) {
                case HAS_DEFAULT: {
                    throw new RuntimeException("Internal error: unexpected default field");
                }
                case OPTIONAL: {
                    code.addLine("  if (%s != null) {", property.getField());
                    break;
                }
                case REQUIRED: {
                    code.addLine("  if (!%s.contains(%s.%s)) {", GeneratedBuilder.UNSET_PROPERTIES, datatype.getPropertyEnum(), property.getAllCapsName());
                }
            }
            code.add("    ", new Object[0]).add(result);
            if (property != first) {
                code.add(".append(%s)", separator);
            }
            code.add(".append(\"%s=\").append(%s)", property.getName(), property.getField());
            if (property != last) {
                code.add(";%n    %s = \", \"", separator);
            }
            code.add(";%n  }%n", new Object[0]);
        }
        code.addLine("  return %s.append(\"}\").toString();", result);
    }

    private ToStringGenerator() {
    }
}

