/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.io.IOException;
import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import org.inferred.freebuilder.processor.util.AnnotationSource;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.IsInvalidTypeVisitor;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.TypeMirrorShortener;
import org.inferred.freebuilder.processor.util.TypeShortener;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public abstract class AbstractSourceBuilder<B extends AbstractSourceBuilder<B>>
implements SourceBuilder,
Appendable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern TEMPLATE_PARAM = Pattern.compile("%([%ns]|([1-9]\\d*)\\$s)");
    protected final FeatureSet features;
    protected final Scope scope;
    protected final TypeMirrorShortener typeMirrorShortener;
    private static final ElementVisitor<Void, AbstractSourceBuilder<?>> ADD_ELEMENT = new SimpleElementVisitor6<Void, AbstractSourceBuilder<?>>(){

        @Override
        public Void visitPackage(PackageElement pkg, AbstractSourceBuilder<?> p) {
            p.append(pkg.getQualifiedName());
            return null;
        }

        @Override
        public Void visitType(TypeElement type, AbstractSourceBuilder<?> p) {
            ((AbstractSourceBuilder)p).add(QualifiedName.of(type));
            return null;
        }

        @Override
        protected Void defaultAction(Element e, AbstractSourceBuilder<?> p) {
            p.append(e.toString());
            return null;
        }
    };

    protected AbstractSourceBuilder(FeatureSet features, Scope scope) {
        this.features = features;
        this.scope = scope;
        this.typeMirrorShortener = new TypeMirrorShortener(this);
    }

    protected abstract TypeShortener getShortener();

    protected abstract B getThis();

    @Override
    public abstract Appendable append(char var1);

    static boolean isLegalType(TypeMirror mirror) {
        return (Boolean)new IsInvalidTypeVisitor().visit(mirror) == false;
    }

    public B add(Excerpt excerpt) {
        excerpt.addTo(this);
        return this.getThis();
    }

    public B add(String template, Object ... params) {
        int offset = 0;
        int nextParam = 0;
        Matcher matcher = TEMPLATE_PARAM.matcher(template);
        while (matcher.find()) {
            this.append(template.subSequence(offset, matcher.start()));
            if (matcher.group(1).contentEquals("%")) {
                this.append("%");
            } else if (matcher.group(1).contentEquals("n")) {
                this.append(LINE_SEPARATOR);
            } else if (matcher.group(1).contentEquals("s")) {
                if (nextParam >= params.length) {
                    throw new MissingFormatArgumentException(matcher.group(0));
                }
                this.add(params[nextParam++]);
            } else {
                int index = Integer.parseInt(matcher.group(2)) - 1;
                if (index >= params.length) {
                    throw new MissingFormatArgumentException(matcher.group(0));
                }
                this.add(params[index]);
            }
            offset = matcher.end();
        }
        this.append(template.subSequence(offset, template.length()));
        return this.getThis();
    }

    public B addLine(String fmt, Object ... args) {
        this.add(fmt, args);
        this.append(LINE_SEPARATOR);
        return this.getThis();
    }

    @Override
    public SourceStringBuilder subBuilder() {
        return new SourceStringBuilder(this.getShortener(), this.features, this.scope);
    }

    @Override
    public SourceStringBuilder subScope(Scope newScope) {
        return new SourceStringBuilder(this.getShortener(), this.features, newScope);
    }

    @Override
    public <T extends Feature<T>> T feature(FeatureType<T> feature) {
        return this.features.get(feature);
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public Appendable append(CharSequence csq) {
        csq.chars().forEach(c -> this.append((char)c));
        return this.getThis();
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    private void add(Object arg) {
        try {
            if (arg instanceof Excerpt) {
                ((Excerpt)arg).addTo(this);
            } else if (arg instanceof Package) {
                this.append(((Package)arg).getName());
            } else if (arg instanceof Element) {
                ADD_ELEMENT.visit((Element)arg, this);
            } else if (arg instanceof Class) {
                this.getShortener().appendShortened(this, QualifiedName.of((Class)arg));
            } else if (arg instanceof TypeMirror) {
                TypeMirror mirror = (TypeMirror)arg;
                Preconditions.checkArgument(AbstractSourceBuilder.isLegalType(mirror), "Cannot write unknown type %s", mirror);
                this.typeMirrorShortener.appendShortened(this.getShortener(), mirror);
            } else if (arg instanceof QualifiedName) {
                this.getShortener().appendShortened(this, (QualifiedName)arg);
            } else if (arg instanceof AnnotationMirror) {
                AnnotationSource.addSource(this, (AnnotationMirror)arg);
            } else if (arg instanceof CharSequence) {
                this.append((CharSequence)arg);
            } else {
                this.append(arg.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

