/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Map;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.FieldAccess;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.VariableName;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.Maps;

public class Block
extends Excerpt
implements SourceBuilder {
    private final Map<String, String> variableNames = Maps.newLinkedHashMap();
    private final Map<String, Excerpt> declarations = Maps.newLinkedHashMap();
    private final SourceStringBuilder declarationsBlock;
    private final SourceStringBuilder body;

    public static Block methodBody(SourceBuilder parent, String ... paramNames) {
        Scope.MethodScope methodScope = new Scope.MethodScope(parent.scope());
        for (String paramName : paramNames) {
            methodScope.add(new VariableName(paramName));
        }
        return new Block(parent, methodScope);
    }

    private Block(SourceBuilder parent, Scope newScope) {
        this.declarationsBlock = parent.subScope(newScope);
        this.body = parent.subScope(newScope);
    }

    public Excerpt declare(Excerpt typeAndPreamble, String preferredName, Excerpt value) {
        String name;
        if (this.variableNames.containsKey(preferredName)) {
            name = this.variableNames.get(preferredName);
            Excerpt declaration = Excerpts.add("%s %s = %s;%n", typeAndPreamble, name, value);
            Excerpt existingDeclaration = this.declarations.get(name);
            Preconditions.checkState(declaration.equals(existingDeclaration), "Incompatible declaration for '%s': %s vs %s", name, declaration, existingDeclaration);
        } else {
            name = this.pickName(preferredName);
            this.variableNames.put(preferredName, name);
            this.body.scope().add(new VariableName(name));
            Excerpt declaration = Excerpts.add("%s %s = %s;%n", typeAndPreamble, name, value);
            this.declarations.put(name, declaration);
            this.declarationsBlock.add(declaration);
        }
        return Excerpts.add("%s", name);
    }

    public Block innerBlock() {
        Scope.MethodScope innerScope = new Scope.MethodScope(this.scope());
        return new Block(this, innerScope);
    }

    private String pickName(String preferredName) {
        if (!this.nameCollides(preferredName)) {
            return preferredName;
        }
        if (!this.nameCollides("_" + preferredName)) {
            return "_" + preferredName;
        }
        int suffix = 2;
        while (this.nameCollides("_" + preferredName + suffix)) {
            ++suffix;
        }
        return "_" + preferredName + suffix;
    }

    private boolean nameCollides(String name) {
        return this.body.scope().contains(new VariableName(name)) || this.body.scope().contains(new FieldAccess(name));
    }

    @Override
    public Block add(String fmt, Object ... args) {
        this.body.add(fmt, args);
        return this;
    }

    @Override
    public Block addLine(String fmt, Object ... args) {
        this.body.addLine(fmt, args);
        return this;
    }

    @Override
    public Block add(Excerpt excerpt) {
        this.body.add(excerpt);
        return this;
    }

    @Override
    public SourceStringBuilder subBuilder() {
        return this.body.subBuilder();
    }

    @Override
    public SourceStringBuilder subScope(Scope newScope) {
        return this.body.subScope(newScope);
    }

    @Override
    public <T extends Feature<T>> T feature(FeatureType<T> featureType) {
        return this.body.feature(featureType);
    }

    @Override
    public Scope scope() {
        return this.body.scope();
    }

    @Override
    public void addTo(SourceBuilder source) {
        source.add("%s%s", this.declarationsBlock, this.body);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("declarations", this.declarations);
        fields.add("body", this.body.toString());
    }
}

