/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import org.inferred.freebuilder.processor.util.AbstractSourceBuilder;
import org.inferred.freebuilder.processor.util.ImportManager;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.ScopeAwareTypeShortener;
import org.inferred.freebuilder.processor.util.ScopeHandler;
import org.inferred.freebuilder.processor.util.SourceParser;
import org.inferred.freebuilder.processor.util.TypeShortener;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.Formatter;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.FormatterException;

public class CompilationUnitBuilder
extends AbstractSourceBuilder<CompilationUnitBuilder>
implements SourceParser.EventHandler {
    private final ImportManager importManager;
    private final QualifiedName classToWrite;
    private final ScopeHandler scopeHandler;
    private final SourceParser parser;
    private final List<ScopeAwareTypeShortener> typeShorteners = new ArrayList<ScopeAwareTypeShortener>();
    private final StringBuilder source = new StringBuilder();

    public CompilationUnitBuilder(ProcessingEnvironment env, QualifiedName classToWrite, Collection<QualifiedName> implicitImports, FeatureSet features) {
        super(features, new Scope.FileScope());
        this.classToWrite = classToWrite;
        this.scopeHandler = new ScopeHandler(env.getElementUtils());
        this.scopeHandler.predeclareGeneratedType(classToWrite);
        for (QualifiedName implicitImport : implicitImports) {
            this.scopeHandler.predeclareGeneratedType(implicitImport);
        }
        this.importManager = new ImportManager();
        this.parser = new SourceParser(this);
        this.typeShorteners.add(new ScopeAwareTypeShortener(this.importManager, this.scopeHandler, classToWrite.getPackage()));
    }

    @Override
    public void onTypeBlockStart(String keyword, String simpleName, Set<String> supertypes) {
        ScopeAwareTypeShortener typeShortener = Iterables.getLast(this.typeShorteners).inScope(simpleName, supertypes);
        this.typeShorteners.add(typeShortener);
    }

    @Override
    public void onOtherBlockStart() {
        this.typeShorteners.add(Iterables.getLast(this.typeShorteners));
    }

    @Override
    public void onBlockEnd() {
        this.typeShorteners.remove(this.typeShorteners.size() - 1);
        Preconditions.checkState(!this.typeShorteners.isEmpty(), "Unexpected '}'");
    }

    @Override
    protected CompilationUnitBuilder getThis() {
        return this;
    }

    @Override
    public CompilationUnitBuilder append(char c) {
        this.source.append(c);
        this.parser.parse(c);
        return this;
    }

    @Override
    protected TypeShortener getShortener() {
        return Iterables.getLast(this.typeShorteners);
    }

    public String toString() {
        StringBuilder unit = new StringBuilder();
        unit.append("// Autogenerated code. Do not modify.\n").append("package ").append(this.classToWrite.getPackage()).append(";\n").append("\n");
        if (!this.importManager.getClassImports().isEmpty()) {
            for (String classImport : this.importManager.getClassImports()) {
                unit.append("import ").append(classImport).append(";\n");
            }
            unit.append("\n");
        }
        unit.append(CompilationUnitBuilder.formatSource(this.source.toString()));
        return unit.toString();
    }

    @VisibleForTesting
    public static String formatSource(String source) {
        try {
            return new Formatter().formatSource(source);
        }
        catch (RuntimeException | FormatterException e) {
            StringBuilder message = new StringBuilder().append("Formatter failed:\n").append(e.getMessage()).append("\nGenerated source:");
            int lineNo = 0;
            for (String line : source.split("\n")) {
                message.append("\n").append(++lineNo).append(": ").append(line);
            }
            throw new RuntimeException(message.toString());
        }
    }
}

