/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Arrays;
import java.util.List;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.JavaxPackage;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

public class Excerpts {
    private static final Excerpt EMPTY = new EmptyExcerpt();

    public static Excerpt add(String fmt, Object ... args) {
        return new AddingExcerpt(fmt, args);
    }

    public static Excerpt empty() {
        return EMPTY;
    }

    public static Excerpt generated(Class<?> generator) {
        return new GeneratedAnnotationExcerpt(generator);
    }

    public static Object join(String separator, Iterable<?> excerpts) {
        return new JoiningExcerpt(separator, excerpts);
    }

    private Excerpts() {
    }

    private static final class JoiningExcerpt
    extends Excerpt {
        private final String separator;
        private final List<?> excerpts;

        private JoiningExcerpt(String separator, Iterable<?> excerpts) {
            this.separator = separator;
            this.excerpts = ImmutableList.copyOf(excerpts);
        }

        @Override
        public void addTo(SourceBuilder source) {
            String itemPrefix = "";
            for (Object object : this.excerpts) {
                source.add("%s%s", itemPrefix, object);
                itemPrefix = this.separator;
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("separator", this.separator);
            fields.add("excerpts", this.excerpts);
        }
    }

    private static final class GeneratedAnnotationExcerpt
    extends Excerpt {
        private final Class<?> generator;

        GeneratedAnnotationExcerpt(Class<?> generator) {
            this.generator = generator;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.feature(JavaxPackage.JAVAX).generated().ifPresent(generated -> code.addLine("@%s(\"%s\")", generated, this.generator.getName()));
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("generator", this.generator);
        }
    }

    private static final class EmptyExcerpt
    extends Excerpt {
        private EmptyExcerpt() {
        }

        @Override
        public void addTo(SourceBuilder source) {
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static final class AddingExcerpt
    extends Excerpt {
        private final String fmt;
        private final Object[] args;

        private AddingExcerpt(String fmt, Object[] args) {
            this.args = args;
            this.fmt = fmt;
        }

        @Override
        public void addTo(SourceBuilder source) {
            source.add(this.fmt, this.args);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder().append("Excerpts.add(\"").append(this.fmt.replaceAll("[\\\"]", "\\\u0001")).append('\"');
            for (Object arg : this.args) {
                result.append(", ").append(arg);
            }
            result.append(")");
            return result.toString();
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("fmt", this.fmt);
            fields.add("args", Arrays.asList(this.args));
        }
    }
}

