/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.VariableName;

public class FieldAccess
extends Excerpt
implements Scope.Element<FieldAccess> {
    private final String fieldName;

    public FieldAccess(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public Scope.Level level() {
        return Scope.Level.METHOD;
    }

    @Override
    public void addTo(SourceBuilder source) {
        if (source.scope().contains(new VariableName(this.fieldName))) {
            source.add("this.", new Object[0]);
        } else {
            source.scope().add(this);
        }
        source.add(this.fieldName, new Object[0]);
    }

    public Excerpt on(Object obj) {
        return new ExplicitFieldAccess(obj, this.fieldName);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("fieldName", this.fieldName);
    }

    private static class ExplicitFieldAccess
    extends Excerpt {
        private final Object obj;
        private final String fieldName;

        ExplicitFieldAccess(Object obj, String fieldName) {
            this.obj = obj;
            this.fieldName = fieldName;
        }

        @Override
        public void addTo(SourceBuilder source) {
            source.add("%s", this.obj).add(".", new Object[0]).add(this.fieldName, new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            throw new UnsupportedOperationException();
        }
    }
}

