/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSortedSet;

class ImportManager {
    private final Map<String, QualifiedName> imports = new LinkedHashMap<String, QualifiedName>();

    ImportManager() {
    }

    public Set<String> getClassImports() {
        ImmutableSortedSet.Builder result = ImmutableSortedSet.naturalOrder();
        for (QualifiedName type : this.imports.values()) {
            result.add(type.toString());
        }
        return result.build();
    }

    public boolean add(QualifiedName type) {
        QualifiedName existingType = this.imports.get(type.getSimpleName());
        if (existingType == null) {
            this.imports.put(type.getSimpleName(), type);
            return true;
        }
        return type.equals(existingType);
    }

    public Optional<QualifiedName> lookup(String shortenedType) {
        String[] simpleNames = shortenedType.split("\\.");
        QualifiedName result = this.imports.get(simpleNames[0]);
        if (result == null) {
            return Optional.empty();
        }
        for (int i = 1; i < simpleNames.length; ++i) {
            result = result.nestedType(simpleNames[i]);
        }
        return Optional.of(result);
    }
}

