/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Set;
import java.util.TreeMap;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.ValueType;

public class LazyName
extends Excerpt
implements Scope.Element<Declaration> {
    private final String preferredName;
    private final Excerpt definition;

    public static void addLazyDefinitions(SourceBuilder code) {
        TreeMap<Declaration, SourceBuilder> definitions = new TreeMap<Declaration, SourceBuilder>();
        Set<Declaration> declarations = code.scope().keysOfType(Declaration.class);
        while (!definitions.keySet().containsAll(declarations)) {
            for (Declaration declaration : declarations) {
                if (definitions.containsKey(declaration)) continue;
                LazyName lazyName = code.scope().get(declaration);
                definitions.put(declaration, code.subBuilder().add(lazyName.definition));
            }
            declarations = code.scope().keysOfType(Declaration.class);
        }
        for (SourceStringBuilder definition : definitions.values()) {
            code.add("%s", definition);
        }
    }

    public LazyName(String preferredName, Excerpt definition) {
        this.preferredName = preferredName;
        this.definition = definition;
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("preferredName", this.preferredName);
        fields.add("definition", this.definition);
    }

    @Override
    public Scope.Level level() {
        return Scope.Level.FILE;
    }

    @Override
    public void addTo(SourceBuilder code) {
        Declaration declaration = LazyName.declare(this, code.scope());
        code.add(declaration.name, new Object[0]);
    }

    protected static Declaration declare(LazyName lazyName, Scope scope) {
        Declaration name = scope.get(lazyName);
        if (name != null) {
            return name;
        }
        int attempt = 1;
        name = new Declaration(lazyName.preferredName);
        while (true) {
            LazyName existingExcerpt;
            if ((existingExcerpt = scope.putIfAbsent(name, lazyName)) == null) {
                scope.putIfAbsent(lazyName, name);
                return name;
            }
            name = new Declaration(lazyName.preferredName + ++attempt);
        }
    }

    static class Declaration
    extends ValueType
    implements Comparable<Declaration>,
    Scope.Element<LazyName> {
        private final String name;

        Declaration(String name) {
            this.name = name;
        }

        @Override
        public Scope.Level level() {
            return Scope.Level.FILE;
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("name", this.name);
        }

        @Override
        public int compareTo(Declaration other) {
            return this.name.compareTo(other.name);
        }
    }
}

