/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.LinkedHashMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Maps;

public class MethodFinder {
    public static <E extends Exception> ImmutableSet<ExecutableElement> methodsOn(TypeElement type, Elements elements, ErrorTypeHandling<E> errorTypeHandling) throws E {
        TypeElement objectType = elements.getTypeElement(Object.class.getCanonicalName());
        ImmutableMap objectMethods = Maps.uniqueIndex(ElementFilter.methodsIn(objectType.getEnclosedElements()), Signature::new);
        LinkedHashMultimap<Signature, ExecutableElement> methods = LinkedHashMultimap.create();
        for (TypeElement supertype : MethodFinder.getSupertypes(type, errorTypeHandling)) {
            for (ExecutableElement method : ElementFilter.methodsIn(supertype.getEnclosedElements())) {
                Signature signature = new Signature(method);
                if (method.getEnclosingElement().equals(objectType) || objectMethods.containsKey(signature) && method.getEnclosingElement().getKind() == ElementKind.INTERFACE && method.getModifiers().contains((Object)Modifier.ABSTRACT) && elements.overrides(method, (ExecutableElement)objectMethods.get(signature), type)) continue;
                Iterator iterator = methods.get(signature).iterator();
                while (iterator.hasNext()) {
                    ExecutableElement otherMethod = (ExecutableElement)iterator.next();
                    if (!elements.overrides(method, otherMethod, type) && !method.getParameters().equals(otherMethod.getParameters())) continue;
                    iterator.remove();
                }
                methods.put(signature, method);
            }
        }
        return ImmutableSet.copyOf(methods.values());
    }

    private static <E extends Exception> ImmutableSet<TypeElement> getSupertypes(TypeElement type, ErrorTypeHandling<E> errorTypeHandling) throws E {
        LinkedHashSet<TypeElement> supertypes = new LinkedHashSet<TypeElement>();
        MethodFinder.addSupertypesToSet(type, supertypes, errorTypeHandling);
        return ImmutableSet.copyOf(supertypes);
    }

    private static <E extends Exception> void addSupertypesToSet(TypeElement type, Set<TypeElement> mutableSet, ErrorTypeHandling<E> errorTypeHandling) throws E {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            TypeElement typeElement = MethodFinder.maybeTypeElement(typeMirror, errorTypeHandling).orElse(null);
            if (typeElement == null) continue;
            MethodFinder.addSupertypesToSet(typeElement, mutableSet, errorTypeHandling);
        }
        TypeElement superclassElement = MethodFinder.maybeTypeElement(type.getSuperclass(), errorTypeHandling).orElse(null);
        if (superclassElement != null) {
            MethodFinder.addSupertypesToSet(superclassElement, mutableSet, errorTypeHandling);
        }
        mutableSet.add(type);
    }

    private static <E extends Exception> Optional<TypeElement> maybeTypeElement(TypeMirror mirror, ErrorTypeHandling<E> errorTypeHandling) throws E {
        if (mirror.getKind() == TypeKind.ERROR) {
            errorTypeHandling.handleErrorType((ErrorType)mirror);
        }
        return ModelUtils.maybeAsTypeElement(mirror);
    }

    private MethodFinder() {
    }

    private static class Signature {
        final Name name;
        final int params;

        Signature(ExecutableElement method) {
            this.name = method.getSimpleName();
            this.params = method.getParameters().size();
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.params;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)obj;
            return this.name.equals(other.name) && this.params == other.params;
        }
    }

    @FunctionalInterface
    public static interface ErrorTypeHandling<E extends Exception> {
        public void handleErrorType(ErrorType var1) throws E;
    }
}

