/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Objects;
import javax.lang.model.type.TypeKind;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public class ObjectsExcerpts {
    public static Excerpt equals(Object a, Object b, TypeKind kind) {
        return new EqualsExcerpt(true, a, b, kind);
    }

    public static Excerpt notEquals(Object a, Object b, TypeKind kind) {
        return new EqualsExcerpt(false, a, b, kind);
    }

    private ObjectsExcerpts() {
    }

    private static class EqualsExcerpt
    extends Excerpt {
        private final boolean areEqual;
        private final Object a;
        private final Object b;
        private final TypeKind kind;

        EqualsExcerpt(boolean areEqual, Object a, Object b, TypeKind kind) {
            this.areEqual = areEqual;
            this.a = a;
            this.b = b;
            this.kind = kind;
        }

        @Override
        public void addTo(SourceBuilder code) {
            switch (this.kind) {
                case FLOAT: {
                    code.add("%1$s.floatToIntBits(%2$s) %3$s %1$s.floatToIntBits(%4$s)", Float.class, this.a, this.areEqual ? "==" : "!=", this.b);
                    return;
                }
                case DOUBLE: {
                    code.add("%1$s.doubleToLongBits(%2$s) %3$s %1$s.doubleToLongBits(%4$s)", Double.class, this.a, this.areEqual ? "==" : "!=", this.b);
                    return;
                }
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case CHAR: {
                    code.add("%s %s %s", this.a, this.areEqual ? "==" : "!=", this.b);
                    return;
                }
            }
            Preconditions.checkState(!this.kind.isPrimitive(), "Unexpected primitive type " + (Object)((Object)this.kind));
            code.add("%s%s.equals(%s, %s)", this.areEqual ? "" : "!", Objects.class, this.a, this.b);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("areEqual", this.areEqual);
            fields.add("a", this.a);
            fields.add("b", this.b);
            fields.add("kind", (Object)this.kind);
        }
    }
}

