/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.inferred.freebuilder.shaded.com.google.common.collect.FluentIterable;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public abstract class Scope {
    private final Map<Element<?>, Object> elements = new LinkedHashMap();
    private final Scope parent;
    private final Level level;

    private Scope(Scope parent, Level level) {
        this.parent = parent;
        this.level = level;
    }

    public boolean contains(Element<?> element) {
        return this.get(element) != null;
    }

    public <T> T get(Element<T> element) {
        Object value = this.elements.get(element);
        if (value != null) {
            return (T)value;
        }
        if (this.parent != null) {
            return this.parent.get(element);
        }
        return null;
    }

    public <T> Set<T> keysOfType(Class<T> elementType) {
        ImmutableSet.Builder keys = ImmutableSet.builder();
        if (this.parent != null) {
            keys.addAll(this.parent.keysOfType(elementType));
        }
        keys.addAll(FluentIterable.from(this.elements.keySet()).filter(elementType).toSet());
        return keys.build();
    }

    public <T extends Element<T>> void add(T element) {
        this.putIfAbsent(element, element);
    }

    public <T> T putIfAbsent(Element<T> element, T value) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(value);
        if (this.level == element.level()) {
            Object existingValue = this.elements.get(element);
            if (existingValue == null) {
                this.elements.put(element, value);
            }
            return (T)existingValue;
        }
        if (this.parent != null) {
            return this.parent.putIfAbsent(element, value);
        }
        return null;
    }

    static class MethodScope
    extends Scope {
        MethodScope(Scope parent) {
            super(parent, Level.METHOD);
        }
    }

    static class FileScope
    extends Scope {
        FileScope() {
            super(null, Level.FILE);
        }
    }

    static interface Element<T> {
        public Level level();
    }

    static enum Level {
        FILE,
        METHOD;

    }
}

