/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.inferred.freebuilder.processor.util.ImportManager;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.ScopeHandler;
import org.inferred.freebuilder.processor.util.TypeShortener;

class ScopeAwareTypeShortener
implements TypeShortener {
    private final ImportManager importManager;
    private final String pkg;
    private final QualifiedName scope;
    private final ScopeHandler handler;

    ScopeAwareTypeShortener(ImportManager importManager, ScopeHandler handler, String pkg) {
        this.importManager = importManager;
        this.pkg = pkg;
        this.scope = null;
        this.handler = handler;
    }

    ScopeAwareTypeShortener(ImportManager importManager, QualifiedName scope, ScopeHandler handler) {
        this.importManager = importManager;
        this.pkg = scope.getPackage();
        this.scope = scope;
        this.handler = handler;
    }

    @Override
    public void appendShortened(Appendable a, QualifiedName type) throws IOException {
        switch (this.visibilityInScope(type)) {
            case IN_SCOPE: {
                break;
            }
            case IMPORTABLE: {
                if (!type.isTopLevel()) {
                    this.appendShortened(a, type.getEnclosingType());
                    a.append('.');
                    break;
                }
                if (this.importManager.add(type)) break;
                a.append(type.getPackage()).append(".");
                break;
            }
            case HIDDEN: {
                if (type.isTopLevel()) {
                    a.append(type.getPackage());
                } else {
                    this.appendShortened(a, type.getEnclosingType());
                }
                a.append('.');
            }
        }
        a.append(type.getSimpleName());
    }

    public Optional<QualifiedName> lookup(String shortenedType) {
        String[] simpleNames = shortenedType.split("\\.");
        QualifiedName result = this.scope != null ? (QualifiedName)this.handler.typeInScope(this.scope, simpleNames[0]).orElse(null) : (QualifiedName)this.handler.typeInScope(this.pkg, simpleNames[0]).orElse(null);
        if (result != null) {
            for (int i = 1; i < simpleNames.length; ++i) {
                result = result.nestedType(simpleNames[i]);
            }
            return Optional.of(result);
        }
        result = this.importManager.lookup(shortenedType).orElse(null);
        if (result != null) {
            return Optional.of(result);
        }
        return this.handler.lookup(shortenedType);
    }

    public ScopeAwareTypeShortener inScope(String simpleName, Set<String> supertypes) {
        QualifiedName newScope = this.scope == null ? QualifiedName.of(this.pkg, simpleName, new String[0]) : this.scope.nestedType(simpleName);
        HashSet<QualifiedName> qualifiedSupertypes = new HashSet<QualifiedName>();
        for (String supertype : supertypes) {
            QualifiedName qualifiedSupertype = this.lookup(supertype).orElse(null);
            if (qualifiedSupertype == null) continue;
            qualifiedSupertypes.add(qualifiedSupertype);
        }
        this.handler.declareGeneratedType(ScopeHandler.Visibility.UNKNOWN, newScope, qualifiedSupertypes);
        return new ScopeAwareTypeShortener(this.importManager, newScope, this.handler);
    }

    private ScopeHandler.ScopeState visibilityInScope(QualifiedName type) {
        if (this.scope != null) {
            return this.handler.visibilityIn(this.scope, type);
        }
        return this.handler.visibilityIn(this.pkg, type);
    }
}

