/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.shaded.com.google.common.collect.HashMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.SetMultimap;

class ScopeHandler {
    private static final String UNIVERSALLY_VISIBLE_PACKAGE = "java.lang";
    private final Elements elements;
    private final Map<QualifiedName, Visibility> typeVisibility = new HashMap<QualifiedName, Visibility>();
    private final Map<QualifiedName, SetMultimap<String, QualifiedName>> visibleTypes = new HashMap<QualifiedName, SetMultimap<String, QualifiedName>>();
    private final Map<String, QualifiedName> generatedTypes = new HashMap<String, QualifiedName>();
    private static final TypeVisitor<Collection<QualifiedName>, ScopeHandler> TYPES_IN_SCOPE = new SimpleTypeVisitor6<Collection<QualifiedName>, ScopeHandler>(){

        @Override
        public Collection<QualifiedName> visitDeclared(DeclaredType type, ScopeHandler scopeHandler) {
            QualifiedName typename = QualifiedName.of(ModelUtils.asElement(type));
            SetMultimap visibleInScope = (SetMultimap)scopeHandler.visibleTypes.get(typename);
            if (visibleInScope != null) {
                return visibleInScope.values();
            }
            return scopeHandler.cacheTypesInScope(typename, ModelUtils.asElement(type)).values();
        }

        @Override
        protected Collection<QualifiedName> defaultAction(TypeMirror e, ScopeHandler p) {
            return ImmutableSet.of();
        }
    };

    ScopeHandler(Elements elements) {
        this.elements = elements;
    }

    ScopeState visibilityIn(String pkg, QualifiedName type) {
        if (this.isTopLevelType(pkg, type.getSimpleName())) {
            if (type.isTopLevel() && type.getPackage().equals(pkg)) {
                return ScopeState.IN_SCOPE;
            }
            return ScopeState.HIDDEN;
        }
        if (!pkg.equals(UNIVERSALLY_VISIBLE_PACKAGE)) {
            return this.visibilityIn(UNIVERSALLY_VISIBLE_PACKAGE, type);
        }
        return ScopeState.IMPORTABLE;
    }

    ScopeState visibilityIn(QualifiedName scope, QualifiedName type) {
        Set<QualifiedName> possibleConflicts = this.typesInScope(scope).get(type.getSimpleName());
        if (possibleConflicts.equals(ImmutableSet.of(type))) {
            return ScopeState.IN_SCOPE;
        }
        if (!possibleConflicts.isEmpty()) {
            return ScopeState.HIDDEN;
        }
        if (!scope.isTopLevel()) {
            return this.visibilityIn(scope.enclosingType(), type);
        }
        return this.visibilityIn(scope.getPackage(), type);
    }

    Optional<QualifiedName> typeInScope(String pkg, String simpleName) {
        if (this.isTopLevelType(pkg, simpleName)) {
            return Optional.of(QualifiedName.of(pkg, simpleName, new String[0]));
        }
        if (!pkg.equals(UNIVERSALLY_VISIBLE_PACKAGE)) {
            return this.typeInScope(UNIVERSALLY_VISIBLE_PACKAGE, simpleName);
        }
        return Optional.empty();
    }

    Optional<QualifiedName> typeInScope(QualifiedName scope, String simpleName) {
        Set<QualifiedName> possibleTypes = this.typesInScope(scope).get(simpleName);
        switch (possibleTypes.size()) {
            case 0: {
                if (scope.isTopLevel()) {
                    return this.typeInScope(scope.getPackage(), simpleName);
                }
                return this.typeInScope(scope.getEnclosingType(), simpleName);
            }
            case 1: {
                return Optional.of(Iterables.getOnlyElement(possibleTypes));
            }
        }
        return Optional.empty();
    }

    void predeclareGeneratedType(QualifiedName generatedType) {
        this.declareGeneratedType(Visibility.UNKNOWN, generatedType, ImmutableSet.of());
    }

    void declareGeneratedType(Visibility visibility, QualifiedName generatedType, Set<QualifiedName> supertypes) {
        this.generatedTypes.put(generatedType.toString(), generatedType);
        this.typeVisibility.put(generatedType, visibility);
        if (!generatedType.isTopLevel()) {
            ScopeHandler.get(this.visibleTypes, generatedType.enclosingType()).put(generatedType.getSimpleName(), generatedType);
        }
        SetMultimap<String, QualifiedName> visibleInScope = ScopeHandler.get(this.visibleTypes, generatedType);
        for (QualifiedName supertype : supertypes) {
            for (QualifiedName type : this.typesInScope(supertype).values()) {
                if (!this.maybeVisibleInScope(generatedType, type)) continue;
                visibleInScope.put(type.getSimpleName(), type);
            }
        }
    }

    Optional<QualifiedName> lookup(String typename) {
        if (this.generatedTypes.containsKey(typename)) {
            return Optional.of(this.generatedTypes.get(typename));
        }
        TypeElement scopeElement = this.elements.getTypeElement(typename);
        if (scopeElement != null) {
            return Optional.of(QualifiedName.of(scopeElement));
        }
        return Optional.empty();
    }

    private boolean isTopLevelType(String pkg, String simpleName) {
        String name = pkg + "." + simpleName;
        return this.generatedTypes.containsKey(name) || this.elements.getTypeElement(name) != null;
    }

    private static <K1, K2, V> SetMultimap<K2, V> get(Map<K1, SetMultimap<K2, V>> map, K1 key) {
        SetMultimap<K2, V> result = map.get(key);
        if (result == null) {
            result = HashMultimap.create();
            map.put(key, result);
        }
        return result;
    }

    private SetMultimap<String, QualifiedName> typesInScope(QualifiedName scope) {
        SetMultimap<String, QualifiedName> result = this.visibleTypes.get(scope);
        if (result != null) {
            return result;
        }
        TypeElement scopeElement = this.elements.getTypeElement(scope.toString());
        return this.cacheTypesInScope(scope, scopeElement);
    }

    private SetMultimap<String, QualifiedName> cacheTypesInScope(QualifiedName scope, TypeElement element) {
        HashMultimap<String, QualifiedName> visibleInScope = HashMultimap.create();
        if (element != null) {
            for (QualifiedName qualifiedName : TYPES_IN_SCOPE.visit(element.getSuperclass(), this)) {
                if (!this.maybeVisibleInScope(scope, qualifiedName)) continue;
                visibleInScope.put(qualifiedName.getSimpleName(), qualifiedName);
            }
            for (TypeMirror typeMirror : element.getInterfaces()) {
                for (QualifiedName type : TYPES_IN_SCOPE.visit(typeMirror, this)) {
                    if (!this.maybeVisibleInScope(scope, type)) continue;
                    visibleInScope.put(type.getSimpleName(), type);
                }
            }
            for (TypeElement typeElement : ElementFilter.typesIn(element.getEnclosedElements())) {
                visibleInScope.put(typeElement.getSimpleName().toString(), QualifiedName.of(typeElement));
            }
        }
        this.visibleTypes.put(scope, visibleInScope);
        return visibleInScope;
    }

    private boolean maybeVisibleInScope(QualifiedName scope, QualifiedName type) {
        switch (this.visibilityOf(type)) {
            case PUBLIC: 
            case PROTECTED: {
                return true;
            }
            case PACKAGE: {
                return scope.getPackage().equals(type.getPackage());
            }
            case PRIVATE: {
                return type.enclosingType().equals(scope);
            }
            case UNKNOWN: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown visibility " + (Object)((Object)this.visibilityOf(type)));
    }

    private Visibility visibilityOf(QualifiedName type) {
        Visibility visibility = this.typeVisibility.get(type);
        if (visibility == null) {
            TypeElement element = this.elements.getTypeElement(type.toString());
            Set<Modifier> modifiers = element.getModifiers();
            visibility = modifiers.contains((Object)Modifier.PUBLIC) ? Visibility.PUBLIC : (modifiers.contains((Object)Modifier.PROTECTED) ? Visibility.PROTECTED : (modifiers.contains((Object)Modifier.PRIVATE) ? Visibility.PRIVATE : Visibility.PACKAGE));
            this.typeVisibility.put(type, visibility);
        }
        return visibility;
    }

    static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE,
        UNKNOWN;

    }

    static enum ScopeState {
        IN_SCOPE,
        HIDDEN,
        IMPORTABLE;

    }
}

