/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

class SourceParser {
    private static final Pattern TYPE = Pattern.compile("\\b(class|interface|enum|@interface)\\s+([^\\s<>]+)");
    private static final Pattern IDENTIFIER = Pattern.compile("[^\\s.,]+(\\s*\\.\\s*[^\\s.,]+)*");
    private final EventHandler eventHandler;
    private final StringBuilder statement;
    private State state;

    SourceParser(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
        this.statement = new StringBuilder();
        this.state = State.CODE;
    }

    public void parse(char c) {
        block0 : switch (this.state) {
            case CODE: 
            case SLASH: {
                this.statement.append(c);
                switch (c) {
                    case '{': {
                        this.statement.deleteCharAt(this.statement.length() - 1);
                        this.onBlockStart(this.statement.toString().trim());
                        this.statement.setLength(0);
                        break;
                    }
                    case '}': {
                        this.eventHandler.onBlockEnd();
                        this.statement.setLength(0);
                        break;
                    }
                    case ';': {
                        this.statement.setLength(0);
                        break;
                    }
                    case '\"': {
                        this.state = State.STRING_LITERAL;
                        break;
                    }
                    case '/': {
                        if (this.state == State.CODE) {
                            this.state = State.SLASH;
                            break;
                        }
                        this.state = State.LINE_COMMENT;
                        this.statement.delete(this.statement.length() - 2, this.statement.length());
                        break;
                    }
                    case '*': {
                        if (this.state == State.CODE) {
                            this.state = State.CODE;
                            break;
                        }
                        this.state = State.BLOCK_COMMENT;
                        this.statement.delete(this.statement.length() - 2, this.statement.length());
                    }
                }
                break;
            }
            case STRING_LITERAL: {
                switch (c) {
                    case '\\': {
                        this.state = State.STRING_LITERAL_ESCAPE;
                        break;
                    }
                    case '\"': {
                        this.statement.append(c);
                        this.state = State.CODE;
                    }
                }
                break;
            }
            case STRING_LITERAL_ESCAPE: {
                this.statement.append(c);
                this.state = State.STRING_LITERAL;
                break;
            }
            case CHAR_LITERAL: {
                switch (c) {
                    case '\\': {
                        this.state = State.CHAR_LITERAL_ESCAPE;
                        break;
                    }
                    case '\'': {
                        this.statement.append(c);
                        this.state = State.CODE;
                    }
                }
                break;
            }
            case CHAR_LITERAL_ESCAPE: {
                this.state = State.CHAR_LITERAL;
                break;
            }
            case LINE_COMMENT: {
                if (c != '\n') break;
                this.state = State.CODE;
                break;
            }
            case BLOCK_COMMENT: 
            case BLOCK_COMMENT_STAR: {
                switch (c) {
                    case '*': {
                        this.state = State.BLOCK_COMMENT_STAR;
                        break block0;
                    }
                    case '/': {
                        if (this.state != State.BLOCK_COMMENT_STAR) break block0;
                        this.state = State.CODE;
                        break block0;
                    }
                }
                this.state = State.BLOCK_COMMENT;
            }
        }
    }

    private void onBlockStart(CharSequence chars) {
        Matcher typeMatcher = TYPE.matcher(chars);
        if (typeMatcher.find()) {
            Set<String> supertypes = SourceParser.supertypes(chars.subSequence(typeMatcher.end(), chars.length()));
            this.eventHandler.onTypeBlockStart(typeMatcher.group(1), typeMatcher.group(2), supertypes);
            return;
        }
        this.eventHandler.onOtherBlockStart();
    }

    private static Set<String> supertypes(CharSequence chars) {
        HashSet<String> types = new HashSet<String>();
        Matcher rawTypeMatcher = IDENTIFIER.matcher(SourceParser.withoutTypeParams(chars));
        while (rawTypeMatcher.find()) {
            String[] identifierParts = rawTypeMatcher.group().split("\\.");
            StringBuilder identifier = new StringBuilder();
            String separator = "";
            for (String part : identifierParts) {
                Preconditions.checkState(SourceVersion.isIdentifier(part.trim()), "Invalid identifier %s", rawTypeMatcher.group());
                identifier.append(separator).append(part.trim());
                separator = ".";
            }
            types.add(identifier.toString());
        }
        types.remove("extends");
        types.remove("implements");
        return types;
    }

    private static CharSequence withoutTypeParams(CharSequence chars) {
        StringBuilder result = new StringBuilder();
        int depth = 0;
        block4: for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '<': {
                    ++depth;
                    continue block4;
                }
                case '>': {
                    Preconditions.checkState(--depth >= 0, "Unexpected > in '%s'", chars);
                    continue block4;
                }
                default: {
                    if (depth != 0) continue block4;
                    result.append(c);
                }
            }
        }
        return result;
    }

    private static enum State {
        CODE,
        SLASH,
        STRING_LITERAL,
        STRING_LITERAL_ESCAPE,
        CHAR_LITERAL,
        CHAR_LITERAL_ESCAPE,
        LINE_COMMENT,
        BLOCK_COMMENT,
        BLOCK_COMMENT_STAR;

    }

    static interface EventHandler {
        public void onTypeBlockStart(String var1, String var2, Set<String> var3);

        public void onOtherBlockStart();

        public void onBlockEnd();
    }
}

