/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.SourceStringBuilder;
import org.inferred.freebuilder.processor.util.TypeClass;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.StaticFeatureSet;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

public abstract class Type
extends Excerpt {
    public static Type from(DeclaredType declaredType) {
        if (declaredType.getTypeArguments().isEmpty()) {
            return new TypeClass(QualifiedName.of(ModelUtils.asElement(declaredType)), ImmutableList.of());
        }
        return new TypeImpl(QualifiedName.of(ModelUtils.asElement(declaredType)), declaredType.getTypeArguments());
    }

    public static Type from(Class<?> cls) {
        return new TypeImpl(QualifiedName.of(cls), Arrays.asList(cls.getTypeParameters()));
    }

    public abstract QualifiedName getQualifiedName();

    protected abstract List<?> getTypeParameters();

    public String getSimpleName() {
        return this.getQualifiedName().getSimpleName();
    }

    public boolean isParameterized() {
        return !this.getTypeParameters().isEmpty();
    }

    public Excerpt constructor() {
        return Excerpts.add("new %s%s", this.getQualifiedName(), this.diamondOperator());
    }

    public Excerpt javadocLink() {
        return Excerpts.add("{@link %s}", this.getQualifiedName());
    }

    public Excerpt javadocNoArgMethodLink(String memberName) {
        return Excerpts.add("{@link %s#%s()}", this.getQualifiedName(), memberName);
    }

    public Excerpt typeParameters() {
        if (this.getTypeParameters().isEmpty()) {
            return Excerpts.empty();
        }
        return Excerpts.add("<%s>", Excerpts.join(", ", this.getTypeParameters()));
    }

    public Excerpt diamondOperator() {
        return this.isParameterized() ? Excerpts.add("<>", new Object[0]) : Excerpts.empty();
    }

    public Type withWildcards() {
        if (this.getTypeParameters().isEmpty()) {
            return this;
        }
        return new TypeImpl(this.getQualifiedName(), Collections.nCopies(this.getTypeParameters().size(), "?"));
    }

    @Override
    public void addTo(SourceBuilder source) {
        source.add("%s%s", this.getQualifiedName(), this.typeParameters());
    }

    static class TypeImpl
    extends Type {
        private final QualifiedName qualifiedName;
        private final List<?> typeParameters;

        TypeImpl(QualifiedName qualifiedName, List<?> typeParameters) {
            this.qualifiedName = Preconditions.checkNotNull(qualifiedName);
            this.typeParameters = ImmutableList.copyOf(typeParameters);
        }

        @Override
        public QualifiedName getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        protected List<?> getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("qualifiedName", this.qualifiedName);
            fields.add("typeParameters", this.typeParameters);
        }

        @Override
        public String toString() {
            return ((SourceStringBuilder)SourceStringBuilder.compilable(new StaticFeatureSet(new Feature[0])).add(this)).toString();
        }
    }
}

