/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.io.IOException;
import org.inferred.freebuilder.processor.util.QualifiedName;

interface TypeShortener {
    public void appendShortened(Appendable var1, QualifiedName var2) throws IOException;

    public static class AlwaysShorten
    implements TypeShortener {
        @Override
        public void appendShortened(Appendable a, QualifiedName type) throws IOException {
            String separator = "";
            for (String simpleName : type.getSimpleNames()) {
                a.append(separator).append(simpleName);
                separator = ".";
            }
        }
    }

    public static class NeverShorten
    implements TypeShortener {
        @Override
        public void appendShortened(Appendable a, QualifiedName type) throws IOException {
            a.append(type.getPackage());
            String separator = type.getPackage().isEmpty() ? "" : ".";
            for (String simpleName : type.getSimpleNames()) {
                a.append(separator).append(simpleName);
                separator = ".";
            }
        }
    }
}

