/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.FieldAccess;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.VariableName;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public class Variable
extends Excerpt
implements Scope.Element<VariableName> {
    private final String preferredName;

    public Variable(String preferredName) {
        this.preferredName = preferredName;
    }

    @Override
    public Scope.Level level() {
        return Scope.Level.METHOD;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addTo(SourceBuilder code) {
        VariableName name = code.scope().get(this);
        if (name == null) {
            name = new VariableName(this.pickName(code));
            code.scope().putIfAbsent(name, name);
            code.scope().putIfAbsent(this, name);
            Preconditions.checkState(code.scope().get(this) != null, "Variable used outside of method body");
        }
        code.add("%s", name.name());
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("preferredName", this.preferredName);
    }

    private String pickName(SourceBuilder code) {
        if (!Variable.nameCollides(code, this.preferredName)) {
            return this.preferredName;
        }
        if (!Variable.nameCollides(code, "_" + this.preferredName)) {
            return "_" + this.preferredName;
        }
        int suffix = 2;
        while (Variable.nameCollides(code, "_" + this.preferredName + suffix)) {
            ++suffix;
        }
        return "_" + this.preferredName + suffix;
    }

    private static boolean nameCollides(SourceBuilder code, String name) {
        return code.scope().contains(new VariableName(name)) || code.scope().contains(new FieldAccess(name));
    }
}

