/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.debug.InternalDebugControl;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.ArgTokenizer;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.ConsoleIOContext;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.EditPad;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.ExternalEditor;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.Feedback;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.FileScannerIOContext;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.IOContext;
import org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.ReloadIOContext;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.DeclarationSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Diag;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.EvalException;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.ExpressionSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.ImportSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.JShell;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.MethodSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.PersistentSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Snippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.SnippetEvent;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.SourceCodeAnalysis;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.TypeDeclSnippet;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.UnresolvedReferenceException;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.VarSnippet;

public class JShellTool {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final Pattern LINEBREAK = Pattern.compile("\\R");
    private static final Pattern HISTORY_ALL_START_FILENAME = Pattern.compile("((?<cmd>(all|history|start))(\\z|\\p{javaWhitespace}+))?(?<filename>.*)");
    private static final String RECORD_SEPARATOR = "\u241e";
    final InputStream cmdin;
    final PrintStream cmdout;
    final PrintStream cmderr;
    final PrintStream console;
    final InputStream userin;
    final PrintStream userout;
    final PrintStream usererr;
    final Feedback feedback = new Feedback();
    private IOContext input = null;
    private boolean regenerateOnDeath = true;
    private boolean live = false;
    SourceCodeAnalysis analysis;
    JShell state = null;
    JShell.Subscription shutdownSubscription = null;
    private boolean debug = false;
    private boolean displayPrompt = true;
    public boolean testPrompt = false;
    private String cmdlineClasspath = null;
    private String cmdlineStartup = null;
    private String[] editor = null;
    private List<String> replayableHistory;
    private List<String> replayableHistoryPrevious;
    static final Preferences PREFS = Preferences.userRoot().node("tool/JShell");
    static final String STARTUP_KEY = "STARTUP";
    static final String REPLAY_RESTORE_KEY = "REPLAY_RESTORE";
    static final String DEFAULT_STARTUP = "\nimport java.util.*;\nimport java.io.*;\nimport java.math.*;\nimport java.net.*;\nimport java.util.concurrent.*;\nimport java.util.prefs.*;\nimport java.util.regex.*;\nvoid printf(String format, Object... args) { System.out.printf(format, args); }\n";
    NameSpace mainNamespace;
    NameSpace startNamespace;
    NameSpace errorNamespace;
    NameSpace currentNameSpace;
    Map<Snippet, SnippetInfo> mapSnippet;
    private static final CompletionProvider EMPTY_COMPLETION_PROVIDER = new FixedCompletionProvider(new String[0]);
    private static final CompletionProvider KEYWORD_COMPLETION_PROVIDER = new FixedCompletionProvider("all ", "start ", "history ");
    private static final CompletionProvider RELOAD_OPTIONS_COMPLETION_PROVIDER = new FixedCompletionProvider("restore", "quiet");
    private static final CompletionProvider FILE_COMPLETION_PROVIDER = JShellTool.fileCompletions(p -> true);
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private static final String[] setSub = new String[]{"format", "field", "feedback", "newmode", "prompt", "editor", "start"};
    private static final String versionRBName = "org.inferred.freebuilder.shaded.org.openjdk.tools.internal.jshell.tool.resources.version";
    private static ResourceBundle versionRB;

    public JShellTool(InputStream cmdin, PrintStream cmdout, PrintStream cmderr, PrintStream console, InputStream userin, PrintStream userout, PrintStream usererr) {
        this.registerCommand(new Command("/list", "[all|start|<name or id>]", "list the source you have typed", "Show the source of snippets, prefaced with the snippet id.\n\n/list\n  -- List the currently active snippets of code that you typed or read with /open\n/list start\n  -- List the automatically evaluated start-up snippets\n/list all\n  -- List all snippets including failed, overwritten, dropped, and start-up\n/list <name>\n  -- List snippets with the specified name (preference for active snippets)\n/list <id>\n  -- List the snippet with the specified snippet id\n", arg -> this.cmdList((String)arg), this.editKeywordCompletion()));
        this.registerCommand(new Command("/edit", "<name or id>", "edit a source entry referenced by name or id", "Edit a snippet or snippets of source in an external editor.\nThe editor to use is set with /set editor.\nIf no editor has been set, a simple editor will be launched.\n\n/edit <name>\n  -- Edit the snippet or snippets with the specified name (preference for active snippets)\n/edit <id>\n  -- Edit the snippet with the specified snippet id\n/edit\n  -- Edit the currently active snippets of code that you typed or read with /open\n", arg -> this.cmdEdit((String)arg), this.editCompletion()));
        this.registerCommand(new Command("/drop", "<name or id>", "delete a source entry referenced by name or id", "Drop a snippet -- making it inactive.\n\n/drop <name>\n  -- Drop the snippet with the specified name\n/drop <id>\n  -- Drop the snippet with the specified snippet id\n", arg -> this.cmdDrop((String)arg), this.editCompletion(), CommandKind.REPLAY));
        this.registerCommand(new Command("/save", "[all|history|start] <file>", "Save snippet source to a file.", "Save the specified snippets and/or commands to the specified file.\n\n/save <file>\n  -- Save the source of current active snippets to the file\n/save all <file>\n  -- Save the source of all snippets to the file\n     Includes source including overwritten, failed, and start-up code\n/save history <file>\n  -- Save the sequential history of all commands and snippets entered since jshell was launched\n/save start <file>\n  -- Save the default start-up definitions to the file\n", arg -> this.cmdSave((String)arg), JShellTool.saveCompletion()));
        this.registerCommand(new Command("/open", "<file>", "open a file as source input", "Open a file and read its contents as snippets and commands.\n\n/open <file>\n  -- Read the specified file as jshell input.\n", arg -> this.cmdOpen((String)arg), FILE_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/vars", null, "list the declared variables and their values", "List the type, name, and value of the current active jshell variables.\n", arg -> this.cmdVars(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/methods", null, "list the declared methods and their signatures", "List the name, parameter types, and return type of the current active jshell methods.\n", arg -> this.cmdMethods(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/classes", null, "list the declared classes", "List the current active jshell classes, interfaces, and enums.\n", arg -> this.cmdClasses(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/imports", null, "list the imported items", "List the current active jshell imports.\n", arg -> this.cmdImports(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/exit", null, "exit jshell", "Leave the jshell tool.  No work is saved.\nSave any work before using this command\n", arg -> this.cmdExit(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/reset", null, "reset jshell", "Reset the jshell tool code and execution state:\n   * All entered code is lost.\n   * Start-up code is re-executed.\n   * The execution state is restarted.\n   * The classpath is cleared.\nTool settings are maintained, as set with: /set ...\nSave any work before using this command\n", arg -> this.cmdReset(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/reload", "[restore] [quiet]", "reset and replay relevant history -- current or previous (restore)", "Reset the jshell tool code and execution state then replay each\njshell valid command and valid snippet in the order they were entered.\n\n/reload\n  -- Reset and replay the valid history since jshell was entered, or\n     a /reset, or /reload command was executed -- whichever is most\n     recent.\n/reload restore\n  -- Reset and replay the valid history between the previous and most\n     recent time that jshell was entered, or a /reset, or /reload\n     command was executed. This can thus be used to restore a previous\n     jshell tool sesson.\n/reload [restore] quiet\n  -- With the 'quiet' argument the replay is not shown.  Errors will display.\n", arg -> this.cmdReload((String)arg), JShellTool.reloadCompletion()));
        this.registerCommand(new Command("/classpath", "<path>", "add a path to the classpath", "Append a additional path to the classpath.\n", arg -> this.cmdClasspath((String)arg), JShellTool.classPathCompletion(), CommandKind.REPLAY));
        this.registerCommand(new Command("/history", null, "history of what you have typed", "Display the history of snippet and command input since this jshell was launched.\n", arg -> this.cmdHistory(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/debug", null, "toggle debugging of the jshell", "Display debugging information for the jshelll implementation.\n0: Debugging off\nr: Debugging on\ng: General debugging on\nf: File manager debugging on\nc': Completion analysis debugging on\nd': Dependency debugging on\ne': Event debugging on\n", arg -> this.cmdDebug((String)arg), EMPTY_COMPLETION_PROVIDER, CommandKind.HIDDEN));
        this.registerCommand(new Command("/help", "[<command>|<subject>]", "get information about jshell", "Display information about jshell.\n/help\n  -- List the jshell commands and help subjects.\n/help <command>\n  -- Display information about the specified comand. The slash must be included.\n     Only the first few letters of the command are needed -- if more than one\n     each will be displayed.  Example:  /help /li\n/help <subject>\n  -- Display information about the specified help subject. Example: /help intro\n", arg -> this.cmdHelp((String)arg), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/set", "editor|start|feedback|newmode|prompt|format|field ...", "set jshell configuration information", "Set jshell configuration information, including:\nthe external editor to use, the start-up definitions to use, a new feedback mode,\nthe command prompt, the feedback mode to use, or the format of output.\n\n/set editor <command> <optional-arg>...\n  -- Specify the command to launch for the /edit command.\n     The <command> is an operating system dependent string.\n\n/set start <file>\n  -- The contents of the specified <file> become the default start-up snippets and commands.\n\n/set feedback <mode>\n  -- Set the feedback mode describing displayed feedback for entered snippets and commands.\n\n/set newmode <new-mode> [command|quiet [<old-mode>]]\n  -- Create a user-defined feedback mode, optionally copying from an existing mode.\n\n/set prompt <mode> \"<prompt>\" \"<continuation-prompt>\"\n  -- Set the displayed prompts for a given feedback mode.\n\n/set format <mode> \"<format>\" <selector>...\n  -- Configure a feedback mode by setting the format to use in a specified set of cases.\n\n/set field name|type|result|when|action|resolve|pre|post|errorpre|errorpost \"<format>\"  <format-case>...\n  -- Set the format of a field within the <format-string> of a \"/set format\" command\n\nTo get more information about one of these forms, use /help with the form specified.\nFor example:   /help /set format\n", arg -> this.cmdSet((String)arg), new FixedCompletionProvider("format", "field", "feedback", "prompt", "newmode", "start", "editor")));
        this.registerCommand(new Command("/?", "", "get information about jshell", "Display information about jshell (abbreviation for /help).\n/?\n  -- Display list of commands and help subjects.\n/? <command>\n  -- Display information about the specified comand. The slash must be included.\n     Only the first few letters of the command are needed -- if more than one\n     match, each will be displayed.  Example:  /? /li\n/? <subject>\n  -- Display information about the specified help subject. Example: /? intro\n", arg -> this.cmdHelp((String)arg), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/!", "", "re-run last snippet", "Reevaluate the most recently entered snippet.\n", arg -> this.cmdUseHistoryEntry(-1), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/<id>", "re-run snippet by id", "", CommandKind.HELP_ONLY));
        this.registerCommand(new Command("/-<n>", "re-run n-th previous snippet", "", CommandKind.HELP_ONLY));
        this.registerCommand(new Command("intro", "An introduction to the jshell tool", "The jshell tool allows you to execute Java code, getting immediate results.\nYou can enter a Java definition (variable, method, class, etc), like:  int x = 8\nor a Java expression, like:  x + x\nor a Java statement or import.\nThese little chunks of Java code are called 'snippets'.\n\nThere are also jshell commands that allow you to understand and\ncontrol what you are doing, like:  /list\n\nFor a list of commands: /help", CommandKind.HELP_SUBJECT));
        this.registerCommand(new Command("shortcuts", "Describe shortcuts", "Supported shortcuts include:\n\n<tab>            -- After entering the first few letters of a Java identifier,\n                    a jshell command, or, in some cases, a jshell command argument,\n                    press the <tab> key to complete the input.\n                    If there is more than one completion, show possible completions.\nShift-<tab>      -- After the name and open parenthesis of a method or constructor invocation,\n                    hold the <shift> key and press the <tab> to see a synopsis of all\n                    matching methods/constructors.\n<fix-shortcut> v -- After a complete expression, press \"<fix-shortcut> v\" to introduce a new variable\n                    whose type is based on the type of the expression.\n                    The \"<fix-shortcut>\" is either Alt-F1 or Alt-Enter, depending on the platform.\n<fix-shortcut> i -- After an unresolvable identifier, press \"<fix-shortcut> i\" and jshell will propose\n                    possible fully qualified names based on the content of the specified classpath.\n                    The \"<fix-shortcut>\" is either Alt-F1 or Alt-Enter, depending on the platform.\n", CommandKind.HELP_SUBJECT));
        this.cmdin = cmdin;
        this.cmdout = cmdout;
        this.cmderr = cmderr;
        this.console = console;
        this.userin = userin;
        this.userout = userout;
        this.usererr = usererr;
        this.initializeFeedbackModes();
    }

    final void initializeFeedbackModes() {
        this.cmdSet("newmode normal command");
        this.cmdSet("prompt normal '\n-> ' '>> '");
        this.cmdSet("field normal pre '|  '");
        this.cmdSet("field normal post '%n'");
        this.cmdSet("field normal errorpre '|  '");
        this.cmdSet("field normal errorpost '%n'");
        this.cmdSet("field normal action 'Added' added-primary");
        this.cmdSet("field normal action 'Modified' modified-primary");
        this.cmdSet("field normal action 'Replaced' replaced-primary");
        this.cmdSet("field normal action 'Overwrote' overwrote-primary");
        this.cmdSet("field normal action 'Dropped' dropped-primary");
        this.cmdSet("field normal action 'Rejected' rejected-primary");
        this.cmdSet("field normal action '  Update added' added-update");
        this.cmdSet("field normal action '  Update modified' modified-update");
        this.cmdSet("field normal action '  Update replaced' replaced-update");
        this.cmdSet("field normal action '  Update overwrote' overwrote-update");
        this.cmdSet("field normal action '  Update dropped' dropped-update");
        this.cmdSet("field normal action '  Update rejected' rejected-update");
        this.cmdSet("field normal resolve '' ok-*");
        this.cmdSet("field normal resolve ', however, it cannot be invoked until%s is declared' defined-primary");
        this.cmdSet("field normal resolve ', however, it cannot be referenced until%s is declared' notdefined-primary");
        this.cmdSet("field normal resolve ' which cannot be invoked until%s is declared' defined-update");
        this.cmdSet("field normal resolve ' which cannot be referenced until%s is declared' notdefined-update");
        this.cmdSet("field normal name '%s'");
        this.cmdSet("field normal type '%s'");
        this.cmdSet("field normal result '%s'");
        this.cmdSet("format normal '' *-*-*");
        this.cmdSet("format normal '{pre}{action} class {name}{resolve}{post}' class");
        this.cmdSet("format normal '{pre}{action} interface {name}{resolve}{post}' interface");
        this.cmdSet("format normal '{pre}{action} enum {name}{resolve}{post}' enum");
        this.cmdSet("format normal '{pre}{action} annotation interface {name}{resolve}{post}' annotation");
        this.cmdSet("format normal '{pre}{action} method {name}({type}){resolve}{post}' method");
        this.cmdSet("format normal '{pre}{action} variable {name} of type {type}{resolve}{post}' vardecl");
        this.cmdSet("format normal '{pre}{action} variable {name} of type {type} with initial value {result}{resolve}{post}' varinit");
        this.cmdSet("format normal '{pre}{action} variable {name}{resolve}{post}' vardeclrecoverable");
        this.cmdSet("format normal '{pre}{action} variable {name}, reset to null{post}' varreset-*-update");
        this.cmdSet("format normal '{pre}Expression value is: {result}{post}{pre}  assigned to temporary variable {name} of type {type}{post}' expression");
        this.cmdSet("format normal '{pre}Variable {name} of type {type} has value {result}{post}' varvalue");
        this.cmdSet("format normal '{pre}Variable {name} has been assigned the value {result}{post}' assignment");
        this.cmdSet("feedback normal");
        this.cmdSet("newmode off quiet");
        this.cmdSet("prompt off '-> ' '>> '");
        this.cmdSet("field off pre '|  '");
        this.cmdSet("field off post '%n'");
        this.cmdSet("field off errorpre '|  '");
        this.cmdSet("field off errorpost '%n'");
        this.cmdSet("format off '' *-*-*");
    }

    boolean interactive() {
        return this.input != null && this.input.interactiveOutput();
    }

    void debug(String format, Object ... args) {
        if (this.debug) {
            this.cmderr.printf(format + "\n", args);
        }
    }

    void rawout(String format, Object ... args) {
        this.cmdout.printf(format, args);
    }

    void hard(String format, Object ... args) {
        this.rawout(this.feedback.getPre() + format + this.feedback.getPost(), args);
    }

    void error(String format, Object ... args) {
        this.rawout(this.feedback.getErrorPre() + format + this.feedback.getErrorPost(), args);
    }

    void fluff(String format, Object ... args) {
        if (this.feedback.shouldDisplayCommandFluff() && this.interactive()) {
            this.hard(format, args);
        }
    }

    void fluffRaw(String format, Object ... args) {
        if (this.feedback.shouldDisplayCommandFluff() && this.interactive()) {
            this.rawout(format, args);
        }
    }

    <T> void hardPairs(Stream<T> stream, Function<T, String> a, Function<T, String> b) {
        Map a2b = stream.collect(Collectors.toMap(a, b, (m1, m2) -> m1, () -> new LinkedHashMap()));
        int aLen = 0;
        for (String av : a2b.keySet()) {
            aLen = Math.max(aLen, av.length());
        }
        String format = "   %-" + aLen + "s -- %s";
        String indentedNewLine = LINE_SEP + this.feedback.getPre() + String.format("   %-" + (aLen + 4) + "s", "");
        for (Map.Entry e : a2b.entrySet()) {
            this.hard(format, e.getKey(), ((String)e.getValue()).replaceAll("\n", indentedNewLine));
        }
    }

    void custom(Feedback.FormatCase fcase, boolean update, Feedback.FormatAction fa, Feedback.FormatResolve fr, String name, String type, String unresolved, String result) {
        String format = this.feedback.getFormat(fcase, update ? Feedback.FormatWhen.UPDATE : Feedback.FormatWhen.PRIMARY, fa, fr, name != null, type != null, result != null);
        this.fluffRaw(format, unresolved, name, type, result);
    }

    static String trimEnd(String s) {
        int last;
        int i;
        for (i = last = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i != last) {
            return s.substring(0, i + 1);
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        new JShellTool(System.in, System.out, System.err, System.out, new ByteArrayInputStream(new byte[0]), System.out, System.err).start(args);
    }

    public void start(String[] args) throws Exception {
        List<String> loadList = this.processCommandArgs(args);
        if (loadList == null) {
            return;
        }
        try (ConsoleIOContext in = new ConsoleIOContext(this, this.cmdin, this.console);){
            this.start(in, loadList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(IOContext in, List<String> loadList) {
        this.resetState();
        String prevReplay = PREFS.get(REPLAY_RESTORE_KEY, null);
        if (prevReplay != null) {
            this.replayableHistoryPrevious = Arrays.asList(prevReplay.split(RECORD_SEPARATOR));
        }
        for (String loadFile : loadList) {
            this.cmdOpen(loadFile);
        }
        if (this.regenerateOnDeath) {
            this.hard("Welcome to JShell -- Version %s", JShellTool.version());
            this.hard("Type /help for help", new Object[0]);
        }
        try {
            while (this.regenerateOnDeath) {
                if (!this.live) {
                    this.resetState();
                }
                this.run(in);
            }
        }
        finally {
            this.closeState();
        }
    }

    private List<String> processCommandArgs(String[] args) {
        ArrayList<String> loadList = new ArrayList<String>();
        Iterator<String> ai = Arrays.asList(args).iterator();
        while (ai.hasNext()) {
            String arg = ai.next();
            if (arg.startsWith("-")) {
                switch (arg) {
                    case "-classpath": 
                    case "-cp": {
                        if (this.cmdlineClasspath != null) {
                            this.cmderr.printf("Conflicting -classpath option.\n", new Object[0]);
                            return null;
                        }
                        if (ai.hasNext()) {
                            this.cmdlineClasspath = ai.next();
                            break;
                        }
                        this.cmderr.printf("Argument to -classpath missing.\n", new Object[0]);
                        return null;
                    }
                    case "-help": {
                        this.printUsage();
                        return null;
                    }
                    case "-version": {
                        this.cmdout.printf("jshell %s\n", JShellTool.version());
                        return null;
                    }
                    case "-fullversion": {
                        this.cmdout.printf("jshell %s\n", JShellTool.fullVersion());
                        return null;
                    }
                    case "-startup": {
                        if (this.cmdlineStartup != null) {
                            this.cmderr.printf("Conflicting -startup or -nostartup option.\n", new Object[0]);
                            return null;
                        }
                        if (ai.hasNext()) {
                            String filename = ai.next();
                            try {
                                byte[] encoded = Files.readAllBytes(Paths.get(filename, new String[0]));
                                this.cmdlineStartup = new String(encoded);
                            }
                            catch (AccessDeniedException e) {
                                this.hard("File '%s' for start-up is not accessible.", filename);
                            }
                            catch (NoSuchFileException e) {
                                this.hard("File '%s' for start-up is not found.", filename);
                            }
                            catch (Exception e) {
                                this.hard("Exception while reading start-up file: %s", e);
                            }
                            break;
                        }
                        this.cmderr.printf("Argument to -startup missing.\n", new Object[0]);
                        return null;
                    }
                    case "-nostartup": {
                        if (this.cmdlineStartup != null && !this.cmdlineStartup.isEmpty()) {
                            this.cmderr.printf("Conflicting -startup option.\n", new Object[0]);
                            return null;
                        }
                        this.cmdlineStartup = "";
                        break;
                    }
                    default: {
                        this.cmderr.printf("Unknown option: %s\n", arg);
                        this.printUsage();
                        return null;
                    }
                }
                continue;
            }
            loadList.add(arg);
        }
        return loadList;
    }

    private void printUsage() {
        this.rawout("Usage:   jshell <options> <load files>\n", new Object[0]);
        this.rawout("where possible options include:\n", new Object[0]);
        this.rawout("  -classpath <path>          Specify where to find user class files\n", new Object[0]);
        this.rawout("  -cp <path>                 Specify where to find user class files\n", new Object[0]);
        this.rawout("  -startup <file>            One run replacement for the start-up definitions\n", new Object[0]);
        this.rawout("  -nostartup                 Do not run the start-up definitions\n", new Object[0]);
        this.rawout("  -help                      Print a synopsis of standard options\n", new Object[0]);
        this.rawout("  -version                   Version information\n", new Object[0]);
    }

    private void resetState() {
        String start;
        this.closeState();
        this.mainNamespace = new NameSpace("main", "");
        this.startNamespace = new NameSpace("start", "s");
        this.errorNamespace = new NameSpace("error", "e");
        this.mapSnippet = new LinkedHashMap<Snippet, SnippetInfo>();
        this.currentNameSpace = this.startNamespace;
        this.replayableHistoryPrevious = this.replayableHistory;
        this.replayableHistory = new ArrayList<String>();
        this.state = JShell.builder().in(this.userin).out(this.userout).err(this.usererr).tempVariableNameGenerator(() -> "$" + this.currentNameSpace.tidNext()).idGenerator((sn, i) -> this.currentNameSpace == this.startNamespace || this.state.status((Snippet)sn).isActive ? this.currentNameSpace.tid((Snippet)sn) : this.errorNamespace.tid((Snippet)sn)).build();
        this.analysis = this.state.sourceCodeAnalysis();
        this.shutdownSubscription = this.state.onShutdown(deadState -> {
            if (deadState == this.state) {
                this.hard("State engine terminated.", new Object[0]);
                this.hard("Restore definitions with: /reload restore", new Object[0]);
                this.live = false;
            }
        });
        this.live = true;
        if (this.cmdlineClasspath != null) {
            this.state.addToClasspath(this.cmdlineClasspath);
        }
        if (this.cmdlineStartup == null) {
            start = PREFS.get(STARTUP_KEY, "<nada>");
            if (start.equals("<nada>")) {
                start = DEFAULT_STARTUP;
                PREFS.put(STARTUP_KEY, DEFAULT_STARTUP);
            }
        } else {
            start = this.cmdlineStartup;
        }
        try (FileScannerIOContext suin = new FileScannerIOContext(new StringReader(start));){
            this.run(suin);
        }
        catch (Exception ex) {
            this.hard("Unexpected exception reading start-up: %s\n", ex);
        }
        this.currentNameSpace = this.mainNamespace;
    }

    private void closeState() {
        this.live = false;
        JShell oldState = this.state;
        if (oldState != null) {
            oldState.unsubscribe(this.shutdownSubscription);
            oldState.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(IOContext in) {
        IOContext oldInput = this.input;
        this.input = in;
        try {
            String incomplete = "";
            while (this.live) {
                String raw;
                String prompt = this.displayPrompt ? (this.testPrompt ? (incomplete.isEmpty() ? "\u0005" : "\u0006") : (incomplete.isEmpty() ? this.feedback.getPrompt(this.currentNameSpace.tidNext()) : this.feedback.getContinuationPrompt(this.currentNameSpace.tidNext()))) : "";
                try {
                    raw = in.readLine(prompt, incomplete);
                }
                catch (IOContext.InputInterruptedException ex) {
                    incomplete = "";
                    continue;
                }
                if (raw == null) {
                    if (in.interactiveOutput()) {
                        this.regenerateOnDeath = false;
                    }
                    break;
                }
                String trimmed = JShellTool.trimEnd(raw);
                if (trimmed.isEmpty()) continue;
                String line = incomplete + trimmed;
                if (incomplete.isEmpty() && line.startsWith("/") && !line.startsWith("//") && !line.startsWith("/*")) {
                    this.processCommand(line.trim());
                    continue;
                }
                incomplete = this.processSourceCatchingReset(line);
            }
        }
        catch (IOException ex) {
            this.hard("Unexpected exception: %s\n", ex);
        }
        finally {
            this.input = oldInput;
        }
    }

    private void addToReplayHistory(String s) {
        if (this.currentNameSpace == this.mainNamespace) {
            this.replayableHistory.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processSourceCatchingReset(String src) {
        try {
            this.input.beforeUserCode();
            String string = this.processSource(src);
            return string;
        }
        catch (IllegalStateException ex) {
            this.hard("Resetting...", new Object[0]);
            this.live = false;
            String string = "";
            return string;
        }
        finally {
            this.input.afterUserCode();
        }
    }

    private void processCommand(String cmd) {
        Command[] candidates;
        if (cmd.startsWith("/-")) {
            try {
                this.cmdUseHistoryEntry(Integer.parseInt(cmd.substring(1)));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String arg = "";
        int idx = cmd.indexOf(32);
        if (idx > 0) {
            arg = cmd.substring(idx + 1).trim();
            cmd = cmd.substring(0, idx);
        }
        if ((candidates = this.findCommand(cmd, c -> c.kind.isRealCommand)).length == 0) {
            if (!this.rerunHistoryEntryById(cmd.substring(1))) {
                this.error("No such command or snippet id: %s", cmd);
                this.fluff("Type /help for help.", new Object[0]);
            }
        } else if (candidates.length == 1) {
            Command command = candidates[0];
            if (command.run.apply(arg).booleanValue() && command.kind == CommandKind.REPLAY) {
                this.addToReplayHistory((command.command + " " + arg).trim());
            }
        } else {
            this.error("Command: %s is ambiguous: %s", cmd, Arrays.stream(candidates).map(c -> c.command).collect(Collectors.joining(", ")));
            this.fluff("Type /help for help.", new Object[0]);
        }
    }

    private Command[] findCommand(String cmd, Predicate<Command> filter) {
        Command exact = this.commands.get(cmd);
        if (exact != null) {
            return new Command[]{exact};
        }
        return (Command[])this.commands.values().stream().filter(filter).filter(command -> command.command.startsWith(cmd)).toArray(Command[]::new);
    }

    private static Path toPathResolvingUserHome(String pathString) {
        if (pathString.replace(File.separatorChar, '/').startsWith("~/")) {
            return Paths.get(System.getProperty("user.home"), pathString.substring(2));
        }
        return Paths.get(pathString, new String[0]);
    }

    private void registerCommand(Command cmd) {
        this.commands.put(cmd.command, cmd);
    }

    private static CompletionProvider fileCompletions(Predicate<Path> accept) {
        return (code, cursor, anchor) -> {
            int lastSlash = code.lastIndexOf(47);
            String path = code.substring(0, lastSlash + 1);
            String prefix = lastSlash != -1 ? code.substring(lastSlash + 1) : code;
            Path current = JShellTool.toPathResolvingUserHome(path);
            ArrayList result = new ArrayList();
            try (Stream<Path> dir = Files.list(current);){
                dir.filter(f -> accept.test((Path)f) && f.getFileName().toString().startsWith(prefix)).map(f -> new SourceCodeAnalysis.Suggestion(f.getFileName() + (Files.isDirectory(f, new LinkOption[0]) ? "/" : ""), false)).forEach(result::add);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (path.isEmpty()) {
                StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).filter(root -> accept.test((Path)root) && root.toString().startsWith(prefix)).map(root -> new SourceCodeAnalysis.Suggestion(root.toString(), false)).forEach(result::add);
            }
            anchor[0] = path.length();
            return result;
        };
    }

    private static CompletionProvider classPathCompletion() {
        return JShellTool.fileCompletions(p -> Files.isDirectory(p, new LinkOption[0]) || p.getFileName().toString().endsWith(".zip") || p.getFileName().toString().endsWith(".jar"));
    }

    private CompletionProvider editCompletion() {
        return (prefix, cursor, anchor) -> {
            anchor[0] = 0;
            return this.state.snippets().stream().flatMap(k -> k instanceof DeclarationSnippet ? Stream.of(String.valueOf(k.id()), ((DeclarationSnippet)k).name()) : Stream.of(String.valueOf(k.id()))).filter(k -> k.startsWith(prefix)).map(k -> new SourceCodeAnalysis.Suggestion((String)k, false)).collect(Collectors.toList());
        };
    }

    private CompletionProvider editKeywordCompletion() {
        return (code, cursor, anchor) -> {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            result.addAll(KEYWORD_COMPLETION_PROVIDER.completionSuggestions(code, cursor, anchor));
            result.addAll(this.editCompletion().completionSuggestions(code, cursor, anchor));
            return result;
        };
    }

    private static CompletionProvider saveCompletion() {
        return (code, cursor, anchor) -> {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            int space = code.indexOf(32);
            if (space == -1) {
                result.addAll(KEYWORD_COMPLETION_PROVIDER.completionSuggestions(code, cursor, anchor));
            }
            result.addAll(FILE_COMPLETION_PROVIDER.completionSuggestions(code.substring(space + 1), cursor - space - 1, anchor));
            anchor[0] = anchor[0] + (space + 1);
            return result;
        };
    }

    private static CompletionProvider reloadCompletion() {
        return (code, cursor, anchor) -> {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            int pastSpace = code.indexOf(32) + 1;
            result.addAll(RELOAD_OPTIONS_COMPLETION_PROVIDER.completionSuggestions(code.substring(pastSpace), cursor - pastSpace, anchor));
            anchor[0] = anchor[0] + pastSpace;
            return result;
        };
    }

    public List<SourceCodeAnalysis.Suggestion> commandCompletionSuggestions(String code, int cursor, int[] anchor) {
        Stream<SourceCodeAnalysis.Suggestion> result;
        String prefix = code.substring(0, cursor);
        int space = prefix.indexOf(32);
        if (space == -1) {
            result = this.commands.values().stream().distinct().filter(cmd -> cmd.kind.shouldSuggestCompletions).map(cmd -> cmd.command).filter(key -> key.startsWith(prefix)).map(key -> new SourceCodeAnalysis.Suggestion(key + " ", false));
            anchor[0] = 0;
        } else {
            String arg = prefix.substring(space + 1);
            String cmd2 = prefix.substring(0, space);
            Command[] candidates = this.findCommand(cmd2, c -> true);
            if (candidates.length == 1) {
                result = candidates[0].completions.completionSuggestions(arg, cursor - space, anchor).stream();
                anchor[0] = anchor[0] + (space + 1);
            } else {
                result = Stream.empty();
            }
        }
        return result.sorted((s1, s2) -> s1.continuation.compareTo(s2.continuation)).collect(Collectors.toList());
    }

    public String commandDocumentation(String code, int cursor) {
        String cmd;
        Command command;
        int space = (code = code.substring(0, cursor)).indexOf(32);
        if (space != -1 && (command = this.commands.get(cmd = code.substring(0, space))) != null) {
            return command.description;
        }
        return null;
    }

    final boolean cmdSet(String arg) {
        ArgTokenizer at = new ArgTokenizer(arg.trim());
        String which = this.setSubCommand(at);
        if (which == null) {
            return false;
        }
        switch (which) {
            case "format": {
                return this.feedback.setFormat(this, at);
            }
            case "field": {
                return this.feedback.setField(this, at);
            }
            case "feedback": {
                return this.feedback.setFeedback(this, at);
            }
            case "newmode": {
                return this.feedback.setNewMode(this, at);
            }
            case "prompt": {
                return this.feedback.setPrompt(this, at);
            }
            case "editor": {
                String n;
                String prog = at.next();
                if (prog == null) {
                    this.hard("The '/set editor' command requires a path argument", new Object[0]);
                    return false;
                }
                ArrayList<String> ed = new ArrayList<String>();
                ed.add(prog);
                while ((n = at.next()) != null) {
                    ed.add(n);
                }
                this.editor = ed.toArray(new String[ed.size()]);
                this.fluff("Editor set to: %s", arg);
                return true;
            }
            case "start": {
                String filename = at.next();
                if (filename == null) {
                    this.hard("The '/set start' command requires a filename argument.", new Object[0]);
                } else {
                    try {
                        byte[] encoded = Files.readAllBytes(JShellTool.toPathResolvingUserHome(filename));
                        String init = new String(encoded);
                        PREFS.put(STARTUP_KEY, init);
                    }
                    catch (AccessDeniedException e) {
                        this.hard("File '%s' for /set start is not accessible.", filename);
                        return false;
                    }
                    catch (NoSuchFileException e) {
                        this.hard("File '%s' for /set start is not found.", filename);
                        return false;
                    }
                    catch (Exception e) {
                        this.hard("Exception while reading start set file: %s", e);
                        return false;
                    }
                }
                return true;
            }
        }
        this.hard("Error: Invalid /set argument: %s", which);
        return false;
    }

    boolean printSetHelp(ArgTokenizer at) {
        String which = this.setSubCommand(at);
        if (which == null) {
            return false;
        }
        switch (which) {
            case "format": {
                this.feedback.printFormatHelp(this);
                return true;
            }
            case "field": {
                this.feedback.printFieldHelp(this);
                return true;
            }
            case "feedback": {
                this.feedback.printFeedbackHelp(this);
                return true;
            }
            case "newmode": {
                this.feedback.printNewModeHelp(this);
                return true;
            }
            case "prompt": {
                this.feedback.printPromptHelp(this);
                return true;
            }
            case "editor": {
                this.hard("Specify the command to launch for the /edit command.", new Object[0]);
                this.hard("", new Object[0]);
                this.hard("/set editor <command> <optional-arg>...", new Object[0]);
                this.hard("", new Object[0]);
                this.hard("The <command> is an operating system dependent string.", new Object[0]);
                this.hard("The <command> may include space-separated arguments (such as flags) -- <optional-arg>....", new Object[0]);
                this.hard("When /edit is used, the temporary file to edit will be appended as the last argument.", new Object[0]);
                return true;
            }
            case "start": {
                this.hard("Set the start-up configuration -- a sequence of snippets and commands read at start-up.", new Object[0]);
                this.hard("", new Object[0]);
                this.hard("/set start <file>", new Object[0]);
                this.hard("", new Object[0]);
                this.hard("The contents of the specified <file> become the default start-up snippets and commands --", new Object[0]);
                this.hard("which are run when the jshell tool is started or reset.", new Object[0]);
                return true;
            }
        }
        this.hard("Error: Invalid /set argument: %s", which);
        return false;
    }

    String setSubCommand(ArgTokenizer at) {
        String[] matches = at.next(setSub);
        if (matches == null) {
            this.error("The /set command requires arguments. See: /help /set", new Object[0]);
            return null;
        }
        if (matches.length == 0) {
            this.error("Not a valid argument to /set: %s", at.val());
            this.fluff("/set is followed by one of: %s", Arrays.stream(setSub).collect(Collectors.joining(", ")));
            return null;
        }
        if (matches.length > 1) {
            this.error("Ambiguous argument to /set: %s", at.val());
            this.fluff("Use one of: %s", Arrays.stream(matches).collect(Collectors.joining(", ")));
            return null;
        }
        return matches[0];
    }

    boolean cmdClasspath(String arg) {
        if (arg.isEmpty()) {
            this.hard("/classpath requires a path argument", new Object[0]);
            return false;
        }
        this.state.addToClasspath(JShellTool.toPathResolvingUserHome(arg).toString());
        this.fluff("Path %s added to classpath", arg);
        return true;
    }

    boolean cmdDebug(String arg) {
        if (arg.isEmpty()) {
            this.debug = !this.debug;
            InternalDebugControl.setDebugFlags(this.state, this.debug ? 1 : 0);
            this.fluff("Debugging %s", this.debug ? "on" : "off");
        } else {
            int flags = 0;
            block9: for (char ch : arg.toCharArray()) {
                switch (ch) {
                    case '0': {
                        flags = 0;
                        this.debug = false;
                        this.fluff("Debugging off", new Object[0]);
                        continue block9;
                    }
                    case 'r': {
                        this.debug = true;
                        this.fluff("REPL tool debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'g': {
                        flags |= 1;
                        this.fluff("General debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'f': {
                        flags |= 2;
                        this.fluff("File manager debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'c': {
                        flags |= 4;
                        this.fluff("Completion analysis debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'd': {
                        flags |= 8;
                        this.fluff("Dependency debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'e': {
                        flags |= 0x10;
                        this.fluff("Event debugging on", new Object[0]);
                        continue block9;
                    }
                    default: {
                        this.hard("Unknown debugging option: %c", Character.valueOf(ch));
                        this.fluff("Use: 0 r g f c d", new Object[0]);
                        return false;
                    }
                }
            }
            InternalDebugControl.setDebugFlags(this.state, flags);
        }
        return true;
    }

    private boolean cmdExit() {
        this.regenerateOnDeath = false;
        this.live = false;
        if (!this.replayableHistory.isEmpty()) {
            PREFS.put(REPLAY_RESTORE_KEY, (String)this.replayableHistory.stream().reduce((a, b) -> a + RECORD_SEPARATOR + b).get());
        }
        this.fluff("Goodbye\n", new Object[0]);
        return true;
    }

    boolean cmdHelp(String arg) {
        ArgTokenizer at = new ArgTokenizer(arg);
        String subject = at.next();
        if (subject != null) {
            Command[] matches = (Command[])this.commands.values().stream().filter(c -> c.command.startsWith(subject)).toArray(Command[]::new);
            at.mark();
            String sub = at.next();
            if (sub != null && matches.length == 1 && matches[0].command.equals("/set")) {
                at.rewind();
                return this.printSetHelp(at);
            }
            if (matches.length > 0) {
                for (Command c2 : matches) {
                    this.hard("", new Object[0]);
                    this.hard("%s", c2.command);
                    this.hard("", new Object[0]);
                    this.hard("%s", c2.help.replaceAll("\n", LINE_SEP + this.feedback.getPre()));
                }
                return true;
            }
            this.error("No commands or subjects start with the provided argument: %s\n\n", arg);
        }
        this.hard("Type a Java language expression, statement, or declaration.", new Object[0]);
        this.hard("Or type one of the following commands:", new Object[0]);
        this.hard("", new Object[0]);
        this.hardPairs(this.commands.values().stream().filter(cmd -> cmd.kind.showInHelp), cmd -> cmd.params != null ? cmd.command + " " + cmd.params : cmd.command, cmd -> cmd.description);
        this.hard("", new Object[0]);
        this.hard("For more information type '/help' followed by the name of command or a subject.", new Object[0]);
        this.hard("For example '/help /list' or '/help intro'.  Subjects:", new Object[0]);
        this.hard("", new Object[0]);
        this.hardPairs(this.commands.values().stream().filter(cmd -> cmd.kind == CommandKind.HELP_SUBJECT), cmd -> cmd.command, cmd -> cmd.description);
        return true;
    }

    private boolean cmdHistory() {
        this.cmdout.println();
        for (String s : this.input.currentSessionHistory()) {
            this.cmdout.printf("%s\n", s);
        }
        return true;
    }

    private static Stream<Snippet> nonEmptyStream(Supplier<Stream<Snippet>> supplier, SnippetPredicate ... filters) {
        for (SnippetPredicate filt : filters) {
            Iterator iterator = supplier.get().filter(filt).iterator();
            if (!iterator.hasNext()) continue;
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        return null;
    }

    private boolean inStartUp(Snippet sn) {
        return this.mapSnippet.get((Object)sn).space == this.startNamespace;
    }

    private boolean isActive(Snippet sn) {
        return this.state.status((Snippet)sn).isActive;
    }

    private boolean mainActive(Snippet sn) {
        return !this.inStartUp(sn) && this.isActive(sn);
    }

    private boolean matchingDeclaration(Snippet sn, String name) {
        return sn instanceof DeclarationSnippet && ((DeclarationSnippet)sn).name().equals(name);
    }

    private Stream<Snippet> argToSnippets(String arg, boolean allowAll) {
        List<Snippet> snippets = this.state.snippets();
        if (allowAll && arg.equals("all")) {
            return snippets.stream();
        }
        if (allowAll && arg.equals("start")) {
            return snippets.stream().filter(this::inStartUp);
        }
        if (arg.isEmpty()) {
            return snippets.stream().filter(this::mainActive);
        }
        Stream<Snippet> result = JShellTool.nonEmptyStream(() -> snippets.stream(), sn -> this.isActive((Snippet)sn) && this.matchingDeclaration((Snippet)sn, arg), sn -> this.matchingDeclaration((Snippet)sn, arg), sn -> sn.id().equals(arg));
        return result;
    }

    private boolean cmdDrop(String arg) {
        if (arg.isEmpty()) {
            this.hard("In the /drop argument, please specify an import, variable, method, or class to drop.", new Object[0]);
            this.hard("Specify by id or name. Use /list to see ids. Use /reset to reset all state.", new Object[0]);
            return false;
        }
        Stream<Snippet> stream = this.argToSnippets(arg, false);
        if (stream == null) {
            this.hard("No definition or id named %s found.  See /classes, /methods, /vars, or /list", arg);
            return false;
        }
        List snippets = stream.filter(sn -> this.state.status((Snippet)sn).isActive && sn instanceof PersistentSnippet).collect(Collectors.toList());
        if (snippets.isEmpty()) {
            this.hard("The argument did not specify an active import, variable, method, or class to drop.", new Object[0]);
            return false;
        }
        if (snippets.size() > 1) {
            this.hard("The argument references more than one import, variable, method, or class.", new Object[0]);
            this.hard("Try again with one of the ids below:", new Object[0]);
            for (Snippet sn2 : snippets) {
                this.cmdout.printf("%4s : %s\n", sn2.id(), sn2.source().replace("\n", "\n       "));
            }
            return false;
        }
        PersistentSnippet psn = (PersistentSnippet)snippets.get(0);
        this.state.drop(psn).forEach(this::handleEvent);
        return true;
    }

    private boolean cmdEdit(String arg) {
        Stream<Snippet> stream = this.argToSnippets(arg, true);
        if (stream == null) {
            this.hard("No definition or id named %s found.  See /classes, /methods, /vars, or /list", arg);
            return false;
        }
        LinkedHashSet<String> srcSet = new LinkedHashSet<String>();
        stream.forEachOrdered(sn -> {
            String src = sn.source();
            switch (sn.subKind()) {
                case VAR_VALUE_SUBKIND: {
                    break;
                }
                case TEMP_VAR_EXPRESSION_SUBKIND: 
                case OTHER_EXPRESSION_SUBKIND: 
                case ASSIGNMENT_SUBKIND: {
                    if (!src.endsWith(";")) {
                        src = src + ";";
                    }
                    srcSet.add(src);
                    break;
                }
                default: {
                    srcSet.add(src);
                }
            }
        });
        StringBuilder sb = new StringBuilder();
        for (String s2 : srcSet) {
            sb.append(s2);
            sb.append('\n');
        }
        String src = sb.toString();
        SaveHandler saveHandler = new SaveHandler(src, srcSet);
        Consumer<String> errorHandler = s -> this.hard("Edit Error: %s", s);
        if (this.editor == null) {
            EditPad.edit(errorHandler, src, saveHandler);
        } else {
            ExternalEditor.edit(this.editor, errorHandler, src, saveHandler, this.input);
        }
        return true;
    }

    private boolean cmdList(String arg) {
        if (arg.equals("history")) {
            return this.cmdHistory();
        }
        Stream<Snippet> stream = this.argToSnippets(arg, true);
        if (stream == null) {
            if (this.argToSnippets("", false).iterator().hasNext()) {
                this.hard("No definition or id named %s found.  Try /list without arguments.", arg);
            } else {
                this.hard("No definition or id named %s found.  There are no active definitions.", arg);
            }
            return false;
        }
        boolean[] hasOutput = new boolean[1];
        stream.forEachOrdered(sn -> {
            if (!hasOutput[0]) {
                this.cmdout.println();
                hasOutput[0] = true;
            }
            this.cmdout.printf("%4s : %s\n", sn.id(), sn.source().replace("\n", "\n       "));
        });
        return true;
    }

    private boolean cmdOpen(String filename) {
        if (filename.isEmpty()) {
            this.hard("The /open command requires a filename argument.", new Object[0]);
            return false;
        }
        try {
            this.run(new FileScannerIOContext(JShellTool.toPathResolvingUserHome(filename).toString()));
        }
        catch (FileNotFoundException e) {
            this.hard("File '%s' is not found: %s", filename, e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.hard("Exception while reading file: %s", e);
            return false;
        }
        return true;
    }

    private boolean cmdReset() {
        this.live = false;
        this.fluff("Resetting state.", new Object[0]);
        return true;
    }

    private boolean cmdReload(String arg) {
        List<String> history = this.replayableHistory;
        boolean echo = true;
        if (arg.length() > 0) {
            if ("restore".startsWith(arg)) {
                if (this.replayableHistoryPrevious == null) {
                    this.hard("No previous history to restore\n", arg);
                    return false;
                }
                history = this.replayableHistoryPrevious;
            } else if ("quiet".startsWith(arg)) {
                echo = false;
            } else {
                this.hard("Invalid argument to reload command: %s\nUse 'restore', 'quiet', or no argument\n", arg);
                return false;
            }
        }
        this.fluff("Restarting and restoring %s.", history == this.replayableHistoryPrevious ? "from previous state" : "state");
        this.resetState();
        this.run(new ReloadIOContext(history, echo ? this.cmdout : null));
        return true;
    }

    private boolean cmdSave(String arg_filename) {
        String filename;
        Matcher mat = HISTORY_ALL_START_FILENAME.matcher(arg_filename);
        if (!mat.find()) {
            this.hard("Malformed argument to the /save command: %s", arg_filename);
            return false;
        }
        boolean useHistory = false;
        String saveAll = "";
        boolean saveStart = false;
        String cmd = mat.group("cmd");
        if (cmd != null) {
            switch (cmd) {
                case "all": {
                    saveAll = "all";
                    break;
                }
                case "history": {
                    useHistory = true;
                    break;
                }
                case "start": {
                    saveStart = true;
                }
            }
        }
        if ((filename = mat.group("filename")) == null || filename.isEmpty()) {
            this.hard("The /save command requires a filename argument.", new Object[0]);
            return false;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(JShellTool.toPathResolvingUserHome(filename), Charset.defaultCharset(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            if (useHistory) {
                for (String s : this.input.currentSessionHistory()) {
                    writer.write(s);
                    writer.write("\n");
                }
            } else if (saveStart) {
                writer.append(DEFAULT_STARTUP);
            } else {
                Stream<Snippet> stream = this.argToSnippets(saveAll, true);
                if (stream != null) {
                    for (Snippet sn : stream.collect(Collectors.toList())) {
                        writer.write(sn.source());
                        writer.write("\n");
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            this.hard("File '%s' for save is not accessible: %s", filename, e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.hard("Exception while saving: %s", e);
            return false;
        }
        return true;
    }

    private boolean cmdVars() {
        for (VarSnippet vk : this.state.variables()) {
            String val = this.state.status(vk) == Snippet.Status.VALID ? this.state.varValue(vk) : "(not-active)";
            this.hard("  %s %s = %s", vk.typeName(), vk.name(), val);
        }
        return true;
    }

    private boolean cmdMethods() {
        for (MethodSnippet mk : this.state.methods()) {
            this.hard("  %s %s", mk.name(), mk.signature());
        }
        return true;
    }

    private boolean cmdClasses() {
        for (TypeDeclSnippet ck : this.state.types()) {
            String kind;
            switch (ck.subKind()) {
                case INTERFACE_SUBKIND: {
                    kind = "interface";
                    break;
                }
                case CLASS_SUBKIND: {
                    kind = "class";
                    break;
                }
                case ENUM_SUBKIND: {
                    kind = "enum";
                    break;
                }
                case ANNOTATION_TYPE_SUBKIND: {
                    kind = "@interface";
                    break;
                }
                default: {
                    assert (false) : "Wrong kind" + (Object)((Object)ck.subKind());
                    kind = "class";
                }
            }
            this.hard("  %s %s", kind, ck.name());
        }
        return true;
    }

    private boolean cmdImports() {
        this.state.imports().forEach(ik -> this.hard("  import %s%s", ik.isStatic() ? "static " : "", ik.fullname()));
        return true;
    }

    private boolean cmdUseHistoryEntry(int index) {
        List<Snippet> keys = this.state.snippets();
        index = index < 0 ? (index += keys.size()) : --index;
        if (index < 0 || index >= keys.size()) {
            this.hard("Cannot find snippet %d", index + 1);
            return false;
        }
        this.rerunSnippet(keys.get(index));
        return true;
    }

    private boolean rerunHistoryEntryById(String id) {
        Optional<Snippet> snippet = this.state.snippets().stream().filter(s -> s.id().equals(id)).findFirst();
        return snippet.map(s -> {
            this.rerunSnippet((Snippet)s);
            return true;
        }).orElse(false);
    }

    private void rerunSnippet(Snippet snippet) {
        String source = snippet.source();
        this.cmdout.printf("%s\n", source);
        this.input.replaceLastHistoryEntry(source);
        this.processSourceCatchingReset(source);
    }

    List<Diag> errorsOnly(List<Diag> diagnostics) {
        return diagnostics.stream().filter(d -> d.isError()).collect(Collectors.toList());
    }

    void printDiagnostics(String source, List<Diag> diagnostics, boolean embed) {
        String padding = embed ? "    " : "";
        for (Diag diag : diagnostics) {
            if (!embed) {
                if (diag.isError()) {
                    this.hard("Error:", new Object[0]);
                } else {
                    this.hard("Warning:", new Object[0]);
                }
            }
            for (String line : diag.getMessage(null).split("\\r?\\n")) {
                if (line.trim().startsWith("location:")) continue;
                this.hard("%s%s", padding, line);
            }
            int pstart = (int)diag.getStartPosition();
            int pend = (int)diag.getEndPosition();
            Matcher m = LINEBREAK.matcher(source);
            int pstartl = 0;
            int pendl = -2;
            while (m.find(pstartl) && (pendl = m.start()) < pstart) {
                pstartl = m.end();
            }
            if (pendl < pstart) {
                pendl = source.length();
            }
            this.fluff("%s%s", padding, source.substring(pstartl, pendl));
            StringBuilder sb = new StringBuilder();
            int start = pstart - pstartl;
            for (int i = 0; i < start; ++i) {
                sb.append(' ');
            }
            sb.append('^');
            boolean multiline = pend > pendl;
            int end = (multiline ? pendl : pend) - pstartl - 1;
            if (end > start) {
                for (int i = start + 1; i < end; ++i) {
                    sb.append('-');
                }
                if (multiline) {
                    sb.append("-...");
                } else {
                    sb.append('^');
                }
            }
            this.fluff("%s%s", padding, sb.toString());
            this.debug("printDiagnostics start-pos = %d ==> %d -- wrap = %s", diag.getStartPosition(), start, this);
            this.debug("Code: %s", diag.getCode());
            this.debug("Pos: %d (%d - %d)", diag.getPosition(), diag.getStartPosition(), diag.getEndPosition());
        }
    }

    private String processSource(String srcInput) throws IllegalStateException {
        while (true) {
            SourceCodeAnalysis.CompletionInfo an = this.analysis.analyzeCompletion(srcInput);
            if (!an.completeness.isComplete) {
                return an.remaining;
            }
            boolean failed = this.processCompleteSource(an.source);
            if (failed || an.remaining.isEmpty()) {
                return "";
            }
            srcInput = an.remaining;
        }
    }

    private boolean processCompleteSource(String source) throws IllegalStateException {
        this.debug("Compiling: %s", source);
        boolean failed = false;
        boolean isActive = false;
        List<SnippetEvent> events = this.state.eval(source);
        for (SnippetEvent e : events) {
            failed |= this.handleEvent(e);
            isActive |= e.causeSnippet() == null && e.status().isActive && e.snippet().subKind() != Snippet.SubKind.VAR_VALUE_SUBKIND;
        }
        if (isActive && this.live) {
            this.addToReplayHistory(source);
        }
        return failed;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleEvent(SnippetEvent ste) {
        Snippet sn = ste.snippet();
        if (sn == null) {
            this.debug("Event with null key: %s", ste);
            return false;
        }
        List<Diag> diagnostics = this.state.diagnostics(sn);
        String source = sn.source();
        if (ste.causeSnippet() == null) {
            this.printDiagnostics(source, diagnostics, false);
            if (!ste.status().isActive) {
                if (ste.status() != Snippet.Status.REJECTED) return false;
                if (!diagnostics.isEmpty()) return true;
                this.hard("Failed.", new Object[0]);
                return true;
            }
            if (ste.exception() == null) {
                this.displayDeclarationAndValue(ste, false, ste.value());
                return false;
            }
            if (ste.exception() instanceof EvalException) {
                this.printEvalException((EvalException)ste.exception());
                return true;
            }
            if (ste.exception() instanceof UnresolvedReferenceException) {
                this.printUnresolved((UnresolvedReferenceException)ste.exception());
                return false;
            }
            this.hard("Unexpected execution exception: %s", ste.exception());
            return true;
        }
        if (ste.status() == Snippet.Status.REJECTED) {
            this.hard("Caused failure of dependent %s --", ((DeclarationSnippet)sn).name());
            this.printDiagnostics(source, diagnostics, true);
            return false;
        }
        if (!(sn instanceof DeclarationSnippet)) return false;
        this.displayDeclarationAndValue(ste, true, ste.value());
        List<Diag> other = this.errorsOnly(diagnostics);
        if (other.size() <= 0) return false;
        this.printDiagnostics(source, other, true);
        return false;
    }

    private void displayDeclarationAndValue(SnippetEvent ste, boolean update, String value) {
        String unresolved;
        Feedback.FormatResolve resolution;
        Feedback.FormatAction action;
        Snippet key = ste.snippet();
        Snippet.Status status = ste.status();
        switch (status) {
            case VALID: 
            case RECOVERABLE_DEFINED: 
            case RECOVERABLE_NOT_DEFINED: {
                if (ste.previousStatus().isActive) {
                    action = ste.isSignatureChange() ? Feedback.FormatAction.REPLACED : Feedback.FormatAction.MODIFIED;
                    break;
                }
                action = Feedback.FormatAction.ADDED;
                break;
            }
            case OVERWRITTEN: {
                action = Feedback.FormatAction.OVERWROTE;
                break;
            }
            case DROPPED: {
                action = Feedback.FormatAction.DROPPED;
                break;
            }
            case REJECTED: {
                action = Feedback.FormatAction.REJECTED;
                break;
            }
            default: {
                this.error("Unexpected status: " + ste.previousStatus().toString() + "=>" + status.toString(), new Object[0]);
                return;
            }
        }
        if (key instanceof DeclarationSnippet && (status == Snippet.Status.RECOVERABLE_DEFINED || status == Snippet.Status.RECOVERABLE_NOT_DEFINED)) {
            resolution = status == Snippet.Status.RECOVERABLE_NOT_DEFINED ? Feedback.FormatResolve.NOTDEFINED : Feedback.FormatResolve.DEFINED;
            unresolved = this.unresolved((DeclarationSnippet)key);
        } else {
            resolution = Feedback.FormatResolve.OK;
            unresolved = "";
        }
        switch (key.subKind()) {
            case CLASS_SUBKIND: {
                this.custom(Feedback.FormatCase.CLASS, update, action, resolution, ((TypeDeclSnippet)key).name(), null, unresolved, null);
                break;
            }
            case INTERFACE_SUBKIND: {
                this.custom(Feedback.FormatCase.INTERFACE, update, action, resolution, ((TypeDeclSnippet)key).name(), null, unresolved, null);
                break;
            }
            case ENUM_SUBKIND: {
                this.custom(Feedback.FormatCase.ENUM, update, action, resolution, ((TypeDeclSnippet)key).name(), null, unresolved, null);
                break;
            }
            case ANNOTATION_TYPE_SUBKIND: {
                this.custom(Feedback.FormatCase.ANNOTATION, update, action, resolution, ((TypeDeclSnippet)key).name(), null, unresolved, null);
                break;
            }
            case METHOD_SUBKIND: {
                this.custom(Feedback.FormatCase.METHOD, update, action, resolution, ((MethodSnippet)key).name(), ((MethodSnippet)key).parameterTypes(), unresolved, null);
                break;
            }
            case VAR_DECLARATION_SUBKIND: 
            case VAR_DECLARATION_WITH_INITIALIZER_SUBKIND: {
                VarSnippet vk = (VarSnippet)key;
                if (status == Snippet.Status.RECOVERABLE_NOT_DEFINED) {
                    this.custom(Feedback.FormatCase.VARDECLRECOVERABLE, update, action, resolution, vk.name(), null, unresolved, null);
                    break;
                }
                if (update && ste.isSignatureChange()) {
                    this.custom(Feedback.FormatCase.VARRESET, update, action, resolution, vk.name(), null, unresolved, value);
                    break;
                }
                if (key.subKind() == Snippet.SubKind.VAR_DECLARATION_WITH_INITIALIZER_SUBKIND) {
                    this.custom(Feedback.FormatCase.VARINIT, update, action, resolution, vk.name(), vk.typeName(), unresolved, value);
                    break;
                }
                this.custom(Feedback.FormatCase.VARDECL, update, action, resolution, vk.name(), vk.typeName(), unresolved, value);
                break;
            }
            case TEMP_VAR_EXPRESSION_SUBKIND: {
                VarSnippet vk = (VarSnippet)key;
                this.custom(Feedback.FormatCase.EXPRESSION, update, action, resolution, vk.name(), vk.typeName(), null, value);
                break;
            }
            case OTHER_EXPRESSION_SUBKIND: {
                this.error("Unexpected expression form -- value is: %s", value);
                break;
            }
            case VAR_VALUE_SUBKIND: {
                ExpressionSnippet ek = (ExpressionSnippet)key;
                this.custom(Feedback.FormatCase.VARVALUE, update, action, resolution, ek.name(), ek.typeName(), null, value);
                break;
            }
            case ASSIGNMENT_SUBKIND: {
                ExpressionSnippet ek = (ExpressionSnippet)key;
                this.custom(Feedback.FormatCase.ASSIGNMENT, update, action, resolution, ek.name(), ek.typeName(), null, value);
                break;
            }
            case SINGLE_TYPE_IMPORT_SUBKIND: 
            case TYPE_IMPORT_ON_DEMAND_SUBKIND: 
            case SINGLE_STATIC_IMPORT_SUBKIND: 
            case STATIC_IMPORT_ON_DEMAND_SUBKIND: {
                this.custom(Feedback.FormatCase.IMPORT, update, action, resolution, ((ImportSnippet)key).name(), null, null, null);
                break;
            }
            case STATEMENT_SUBKIND: {
                this.custom(Feedback.FormatCase.STATEMENT, update, action, resolution, null, null, null, null);
            }
        }
    }

    void printStackTrace(StackTraceElement[] stes) {
        for (StackTraceElement ste : stes) {
            StringBuilder sb = new StringBuilder();
            String cn = ste.getClassName();
            if (!cn.isEmpty()) {
                int dot = cn.lastIndexOf(46);
                if (dot > 0) {
                    sb.append(cn.substring(dot + 1));
                } else {
                    sb.append(cn);
                }
                sb.append(".");
            }
            if (!ste.getMethodName().isEmpty()) {
                sb.append(ste.getMethodName());
                sb.append(" ");
            }
            String fileName = ste.getFileName();
            int lineNumber = ste.getLineNumber();
            String loc = ste.isNativeMethod() ? "Native Method" : (fileName == null ? "Unknown Source" : (lineNumber >= 0 ? fileName + ":" + lineNumber : fileName));
            this.hard("      at %s(%s)", sb, loc);
        }
    }

    void printUnresolved(UnresolvedReferenceException ex) {
        DeclarationSnippet corralled = ex.getSnippet();
        List<Diag> otherErrors = this.errorsOnly(this.state.diagnostics(corralled));
        StringBuilder sb = new StringBuilder();
        if (otherErrors.size() > 0) {
            if (this.state.unresolvedDependencies(corralled).size() > 0) {
                sb.append(" and");
            }
            if (otherErrors.size() == 1) {
                sb.append(" this error is addressed --");
            } else {
                sb.append(" these errors are addressed --");
            }
        } else {
            sb.append(".");
        }
        String format = corralled.kind() == Snippet.Kind.METHOD ? "Attempted to call %s which cannot be invoked until%s" : "Attempted to use %s which cannot be accessed until%s";
        this.hard(format, corralled.name(), this.unresolved(corralled), sb.toString());
        if (otherErrors.size() > 0) {
            this.printDiagnostics(corralled.source(), otherErrors, true);
        }
    }

    void printEvalException(EvalException ex) {
        if (ex.getMessage() == null) {
            this.hard("%s thrown", ex.getExceptionClassName());
        } else {
            this.hard("%s thrown: %s", ex.getExceptionClassName(), ex.getMessage());
        }
        this.printStackTrace(ex.getStackTrace());
    }

    String unresolved(DeclarationSnippet key) {
        List<String> unr = this.state.unresolvedDependencies(key);
        StringBuilder sb = new StringBuilder();
        int fromLast = unr.size();
        if (fromLast > 0) {
            sb.append(" ");
        }
        for (String u : unr) {
            sb.append(u);
            if (--fromLast == 0) continue;
            if (fromLast == 1) {
                sb.append(", and ");
                continue;
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    static String version() {
        return JShellTool.version("release");
    }

    static String fullVersion() {
        return JShellTool.version("full");
    }

    private static String version(String key) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return "(version info not available)";
            }
        }
        try {
            return versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return "(version info not available)";
        }
    }

    static class SnippetInfo {
        final Snippet snippet;
        final NameSpace space;
        final String tid;

        SnippetInfo(Snippet snippet, NameSpace space, String tid) {
            this.snippet = snippet;
            this.space = space;
            this.tid = tid;
        }
    }

    class NameSpace {
        final String spaceName;
        final String prefix;
        private int nextNum;

        NameSpace(String spaceName, String prefix) {
            this.spaceName = spaceName;
            this.prefix = prefix;
            this.nextNum = 1;
        }

        String tid(Snippet sn) {
            String tid = this.prefix + this.nextNum++;
            JShellTool.this.mapSnippet.put(sn, new SnippetInfo(sn, this, tid));
            return tid;
        }

        String tidNext() {
            return this.prefix + this.nextNum;
        }
    }

    private class SaveHandler
    implements Consumer<String> {
        String src;
        Set<String> currSrcs;

        SaveHandler(String src, Set<String> ss) {
            this.src = src;
            this.currSrcs = ss;
        }

        @Override
        public void accept(String s) {
            if (!s.equals(this.src)) {
                this.src = s;
                try {
                    LinkedHashSet<String> nextSrcs = new LinkedHashSet<String>();
                    boolean failed = false;
                    while (true) {
                        SourceCodeAnalysis.CompletionInfo an = JShellTool.this.analysis.analyzeCompletion(s);
                        if (!an.completeness.isComplete) break;
                        String tsrc = this.trimNewlines(an.source);
                        if (!failed && !this.currSrcs.contains(tsrc)) {
                            failed = JShellTool.this.processCompleteSource(tsrc);
                        }
                        nextSrcs.add(tsrc);
                        if (an.remaining.isEmpty()) break;
                        s = an.remaining;
                    }
                    this.currSrcs = nextSrcs;
                }
                catch (IllegalStateException ex) {
                    JShellTool.this.hard("Resetting...", new Object[0]);
                    JShellTool.this.resetState();
                    this.currSrcs = new LinkedHashSet<String>();
                }
            }
        }

        private String trimNewlines(String s) {
            int e;
            int b;
            for (b = 0; b < s.length() && s.charAt(b) == '\n'; ++b) {
            }
            for (e = s.length() - 1; e >= 0 && s.charAt(e) == '\n'; --e) {
            }
            return s.substring(b, e + 1);
        }
    }

    private static interface SnippetPredicate
    extends Predicate<Snippet> {
    }

    static final class FixedCompletionProvider
    implements CompletionProvider {
        private final String[] alternatives;

        public FixedCompletionProvider(String ... alternatives) {
            this.alternatives = alternatives;
        }

        @Override
        public List<SourceCodeAnalysis.Suggestion> completionSuggestions(String input, int cursor, int[] anchor) {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            for (String alternative : this.alternatives) {
                if (!alternative.startsWith(input)) continue;
                result.add(new SourceCodeAnalysis.Suggestion(alternative, false));
            }
            anchor[0] = 0;
            return result;
        }
    }

    static enum CommandKind {
        NORMAL(true, true, true),
        REPLAY(true, true, true),
        HIDDEN(true, false, false),
        HELP_ONLY(false, true, false),
        HELP_SUBJECT(false, false, false);

        final boolean isRealCommand;
        final boolean showInHelp;
        final boolean shouldSuggestCompletions;

        private CommandKind(boolean isRealCommand, boolean showInHelp, boolean shouldSuggestCompletions) {
            this.isRealCommand = isRealCommand;
            this.showInHelp = showInHelp;
            this.shouldSuggestCompletions = shouldSuggestCompletions;
        }
    }

    static interface CompletionProvider {
        public List<SourceCodeAnalysis.Suggestion> completionSuggestions(String var1, int var2, int[] var3);
    }

    static final class Command {
        public final String command;
        public final String params;
        public final String description;
        public final String help;
        public final Function<String, Boolean> run;
        public final CompletionProvider completions;
        public final CommandKind kind;

        public Command(String command, String params, String description, String help, Function<String, Boolean> run, CompletionProvider completions) {
            this(command, params, description, help, run, completions, CommandKind.NORMAL);
        }

        public Command(String command, String description, String help, CommandKind kind) {
            this(command, null, description, help, arg -> {
                throw new IllegalStateException();
            }, EMPTY_COMPLETION_PROVIDER, kind);
        }

        public Command(String command, String params, String description, String help, Function<String, Boolean> run, CompletionProvider completions, CommandKind kind) {
            this.command = command;
            this.params = params;
            this.description = description;
            this.help = help;
            this.run = run;
            this.completions = completions;
            this.kind = kind;
        }
    }
}

