/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.model;

import java.util.AbstractList;
import java.util.Iterator;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Scope;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Symbol;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Filter;

public class FilteredMemberList
extends AbstractList<Symbol> {
    private final Scope scope;

    public FilteredMemberList(Scope scope) {
        this.scope = scope;
    }

    @Override
    public int size() {
        int cnt = 0;
        for (Symbol sym : this.scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (FilteredMemberList.unwanted(sym)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public Symbol get(int index) {
        for (Symbol sym : this.scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (FilteredMemberList.unwanted(sym) || index-- != 0) continue;
            return sym;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this.scope.getSymbols(new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol t) {
                return !FilteredMemberList.unwanted(t);
            }
        }, Scope.LookupKind.NON_RECURSIVE).iterator();
    }

    private static boolean unwanted(Symbol s) {
        return s == null || (s.flags() & 0x1000L) != 0L;
    }
}

