// Autogenerated code. Do not modify.
package org.inferred.freebuilder.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import javax.annotation.Generated;
import org.inferred.freebuilder.processor.Datatype.StandardMethod;
import org.inferred.freebuilder.processor.Datatype.UnderrideLevel;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.TypeClass;

/**
 * Auto-generated superclass of {@link Datatype.Builder}, derived from the API of {@link Datatype}.
 */
@Generated("org.inferred.freebuilder.processor.Processor")
abstract class Datatype_Builder {

  /** Creates a new builder using {@code value} as a template. */
  public static Datatype.Builder from(Datatype value) {
    return new Datatype.Builder().mergeFrom(value);
  }

  private enum Property {
    TYPE("type"),
    INTERFACE_TYPE("interfaceType"),
    BUILDER("builder"),
    EXTENSIBLE("extensible"),
    GENERATED_BUILDER("generatedBuilder"),
    VALUE_TYPE("valueType"),
    PARTIAL_TYPE("partialType"),
    PROPERTY_ENUM("propertyEnum"),
    BUILDER_SERIALIZABLE("builderSerializable"),
    HAS_TO_BUILDER_METHOD("hasToBuilderMethod"),
    VALUE_TYPE_VISIBILITY("valueTypeVisibility"),
    ;

    private final String name;

    private Property(String name) {
      this.name = name;
    }

    @Override
    public String toString() {
      return name;
    }
  }

  private TypeClass type;
  private boolean interfaceType;
  private Type builder;
  private boolean extensible;
  // Store a nullable object instead of an Optional. Escape analysis then
  // allows the JVM to optimize away the Optional objects created by and
  // passed to our API.
  private BuilderFactory builderFactory = null;
  private TypeClass generatedBuilder;
  private TypeClass valueType;
  private TypeClass partialType;
  private TypeClass propertyEnum;
  private final LinkedHashMap<StandardMethod, UnderrideLevel> standardMethodUnderrides =
      new LinkedHashMap<>();
  private boolean builderSerializable;
  private boolean hasToBuilderMethod;
  private List<Excerpt> generatedBuilderAnnotations = ImmutableList.of();
  private List<Excerpt> valueTypeAnnotations = ImmutableList.of();
  private Datatype.Visibility valueTypeVisibility;
  private List<Excerpt> nestedClasses = ImmutableList.of();
  private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

  /**
   * Sets the value to be returned by {@link Datatype#getType()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code type} is null
   */
  public Datatype.Builder setType(TypeClass type) {
    this.type = Objects.requireNonNull(type);
    _unsetProperties.remove(Property.TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getType()} by applying {@code mapper} to
   * it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapType(UnaryOperator<TypeClass> mapper) {
    Objects.requireNonNull(mapper);
    return setType(mapper.apply(getType()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getType() {
    Preconditions.checkState(!_unsetProperties.contains(Property.TYPE), "type not set");
    return type;
  }

  /**
   * Sets the value to be returned by {@link Datatype#isInterfaceType()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setInterfaceType(boolean interfaceType) {
    this.interfaceType = interfaceType;
    _unsetProperties.remove(Property.INTERFACE_TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#isInterfaceType()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapInterfaceType(UnaryOperator<Boolean> mapper) {
    Objects.requireNonNull(mapper);
    return setInterfaceType(mapper.apply(isInterfaceType()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#isInterfaceType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean isInterfaceType() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.INTERFACE_TYPE), "interfaceType not set");
    return interfaceType;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilder()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code builder} is null
   */
  public Datatype.Builder setBuilder(Type builder) {
    this.builder = Objects.requireNonNull(builder);
    _unsetProperties.remove(Property.BUILDER);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getBuilder()} by applying {@code mapper}
   * to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapBuilder(UnaryOperator<Type> mapper) {
    Objects.requireNonNull(mapper);
    return setBuilder(mapper.apply(getBuilder()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getBuilder()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public Type getBuilder() {
    Preconditions.checkState(!_unsetProperties.contains(Property.BUILDER), "builder not set");
    return builder;
  }

  /**
   * Sets the value to be returned by {@link Datatype#isExtensible()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setExtensible(boolean extensible) {
    this.extensible = extensible;
    _unsetProperties.remove(Property.EXTENSIBLE);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#isExtensible()} by applying {@code mapper}
   * to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapExtensible(UnaryOperator<Boolean> mapper) {
    Objects.requireNonNull(mapper);
    return setExtensible(mapper.apply(isExtensible()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#isExtensible()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean isExtensible() {
    Preconditions.checkState(!_unsetProperties.contains(Property.EXTENSIBLE), "extensible not set");
    return extensible;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code builderFactory} is null
   */
  public Datatype.Builder setBuilderFactory(BuilderFactory builderFactory) {
    this.builderFactory = Objects.requireNonNull(builderFactory);
    return (Datatype.Builder) this;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setBuilderFactory(Optional<? extends BuilderFactory> builderFactory) {
    if (builderFactory.isPresent()) {
      return setBuilderFactory(builderFactory.get());
    } else {
      return clearBuilderFactory();
    }
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setNullableBuilderFactory(BuilderFactory builderFactory) {
    if (builderFactory != null) {
      return setBuilderFactory(builderFactory);
    } else {
      return clearBuilderFactory();
    }
  }

  /**
   * If the value to be returned by {@link Datatype#getBuilderFactory()} is present, replaces it by
   * applying {@code mapper} to it and using the result.
   *
   * <p>If the result is null, clears the value.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null
   */
  public Datatype.Builder mapBuilderFactory(UnaryOperator<BuilderFactory> mapper) {
    return setBuilderFactory(getBuilderFactory().map(mapper));
  }

  /**
   * Sets the value to be returned by {@link Datatype#getBuilderFactory()} to {@link
   * Optional#empty() Optional.empty()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearBuilderFactory() {
    builderFactory = null;
    return (Datatype.Builder) this;
  }

  /** Returns the value that will be returned by {@link Datatype#getBuilderFactory()}. */
  public Optional<BuilderFactory> getBuilderFactory() {
    return Optional.ofNullable(builderFactory);
  }

  /**
   * Sets the value to be returned by {@link Datatype#getGeneratedBuilder()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code generatedBuilder} is null
   */
  public Datatype.Builder setGeneratedBuilder(TypeClass generatedBuilder) {
    this.generatedBuilder = Objects.requireNonNull(generatedBuilder);
    _unsetProperties.remove(Property.GENERATED_BUILDER);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getGeneratedBuilder()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapGeneratedBuilder(UnaryOperator<TypeClass> mapper) {
    Objects.requireNonNull(mapper);
    return setGeneratedBuilder(mapper.apply(getGeneratedBuilder()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getGeneratedBuilder()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getGeneratedBuilder() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.GENERATED_BUILDER), "generatedBuilder not set");
    return generatedBuilder;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getValueType()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code valueType} is null
   */
  public Datatype.Builder setValueType(TypeClass valueType) {
    this.valueType = Objects.requireNonNull(valueType);
    _unsetProperties.remove(Property.VALUE_TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getValueType()} by applying {@code mapper}
   * to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapValueType(UnaryOperator<TypeClass> mapper) {
    Objects.requireNonNull(mapper);
    return setValueType(mapper.apply(getValueType()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getValueType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getValueType() {
    Preconditions.checkState(!_unsetProperties.contains(Property.VALUE_TYPE), "valueType not set");
    return valueType;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getPartialType()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code partialType} is null
   */
  public Datatype.Builder setPartialType(TypeClass partialType) {
    this.partialType = Objects.requireNonNull(partialType);
    _unsetProperties.remove(Property.PARTIAL_TYPE);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getPartialType()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapPartialType(UnaryOperator<TypeClass> mapper) {
    Objects.requireNonNull(mapper);
    return setPartialType(mapper.apply(getPartialType()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getPartialType()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getPartialType() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.PARTIAL_TYPE), "partialType not set");
    return partialType;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getPropertyEnum()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code propertyEnum} is null
   */
  public Datatype.Builder setPropertyEnum(TypeClass propertyEnum) {
    this.propertyEnum = Objects.requireNonNull(propertyEnum);
    _unsetProperties.remove(Property.PROPERTY_ENUM);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getPropertyEnum()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapPropertyEnum(UnaryOperator<TypeClass> mapper) {
    Objects.requireNonNull(mapper);
    return setPropertyEnum(mapper.apply(getPropertyEnum()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getPropertyEnum()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public TypeClass getPropertyEnum() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.PROPERTY_ENUM), "propertyEnum not set");
    return propertyEnum;
  }

  /**
   * Associates {@code key} with {@code value} in the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}. If the map previously contained a mapping for the key,
   * the old value is replaced by the specified value.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if either {@code key} or {@code value} are null
   */
  public Datatype.Builder putStandardMethodUnderrides(StandardMethod key, UnderrideLevel value) {
    Objects.requireNonNull(key);
    Objects.requireNonNull(value);
    standardMethodUnderrides.put(key, value);
    return (Datatype.Builder) this;
  }

  /**
   * Copies all of the mappings from {@code map} to the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code map} is null or contains a null key or value
   */
  public Datatype.Builder putAllStandardMethodUnderrides(
      Map<? extends StandardMethod, ? extends UnderrideLevel> map) {
    for (Map.Entry<? extends StandardMethod, ? extends UnderrideLevel> entry : map.entrySet()) {
      putStandardMethodUnderrides(entry.getKey(), entry.getValue());
    }
    return (Datatype.Builder) this;
  }

  /**
   * Removes the mapping for {@code key} from the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}, if one is present.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code key} is null
   */
  public Datatype.Builder removeStandardMethodUnderrides(StandardMethod key) {
    Objects.requireNonNull(key);
    standardMethodUnderrides.remove(key);
    return (Datatype.Builder) this;
  }

  /**
   * Invokes {@code mutator} with the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}.
   *
   * <p>This method mutates the map in-place. {@code mutator} is a void consumer, so any value
   * returned from a lambda will be ignored. Take care not to call pure functions, like {@link
   * Collection#stream()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mutator} is null
   */
  public Datatype.Builder mutateStandardMethodUnderrides(
      Consumer<? super Map<StandardMethod, UnderrideLevel>> mutator) {
    // If putStandardMethodUnderrides is overridden, this method will be updated to delegate to it
    mutator.accept(standardMethodUnderrides);
    return (Datatype.Builder) this;
  }

  /**
   * Removes all of the mappings from the map to be returned from {@link
   * Datatype#getStandardMethodUnderrides()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearStandardMethodUnderrides() {
    standardMethodUnderrides.clear();
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the map that will be returned by {@link
   * Datatype#getStandardMethodUnderrides()}. Changes to this builder will be reflected in the view.
   */
  public Map<StandardMethod, UnderrideLevel> getStandardMethodUnderrides() {
    return Collections.unmodifiableMap(standardMethodUnderrides);
  }

  /**
   * Sets the value to be returned by {@link Datatype#isBuilderSerializable()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setBuilderSerializable(boolean builderSerializable) {
    this.builderSerializable = builderSerializable;
    _unsetProperties.remove(Property.BUILDER_SERIALIZABLE);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#isBuilderSerializable()} by applying
   * {@code mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapBuilderSerializable(UnaryOperator<Boolean> mapper) {
    Objects.requireNonNull(mapper);
    return setBuilderSerializable(mapper.apply(isBuilderSerializable()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#isBuilderSerializable()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean isBuilderSerializable() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.BUILDER_SERIALIZABLE), "builderSerializable not set");
    return builderSerializable;
  }

  /**
   * Sets the value to be returned by {@link Datatype#getHasToBuilderMethod()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder setHasToBuilderMethod(boolean hasToBuilderMethod) {
    this.hasToBuilderMethod = hasToBuilderMethod;
    _unsetProperties.remove(Property.HAS_TO_BUILDER_METHOD);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getHasToBuilderMethod()} by applying
   * {@code mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapHasToBuilderMethod(UnaryOperator<Boolean> mapper) {
    Objects.requireNonNull(mapper);
    return setHasToBuilderMethod(mapper.apply(getHasToBuilderMethod()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getHasToBuilderMethod()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public boolean getHasToBuilderMethod() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD), "hasToBuilderMethod not set");
    return hasToBuilderMethod;
  }

  /**
   * Adds {@code element} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addGeneratedBuilderAnnotations(Excerpt element) {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = new ArrayList<>(generatedBuilderAnnotations);
    }
    generatedBuilderAnnotations.add(Objects.requireNonNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addGeneratedBuilderAnnotations(Excerpt... elements) {
    return addAllGeneratedBuilderAnnotations(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllGeneratedBuilderAnnotations(
      Spliterator<? extends Excerpt> elements) {
    if ((elements.characteristics() & Spliterator.SIZED) != 0) {
      long elementsSize = elements.estimateSize();
      if (elementsSize > 0 && elementsSize <= Integer.MAX_VALUE) {
        if (generatedBuilderAnnotations instanceof ImmutableList) {
          generatedBuilderAnnotations = new ArrayList<>(generatedBuilderAnnotations);
        }
        ((ArrayList<?>) generatedBuilderAnnotations)
            .ensureCapacity(generatedBuilderAnnotations.size() + (int) elementsSize);
      }
    }
    elements.forEachRemaining(this::addGeneratedBuilderAnnotations);
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllGeneratedBuilderAnnotations(
      BaseStream<? extends Excerpt, ?> elements) {
    return addAllGeneratedBuilderAnnotations(elements.spliterator());
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllGeneratedBuilderAnnotations(Iterable<? extends Excerpt> elements) {
    return addAllGeneratedBuilderAnnotations(elements.spliterator());
  }

  /**
   * Applies {@code mutator} to the list to be returned from {@link
   * Datatype#getGeneratedBuilderAnnotations()}.
   *
   * <p>This method mutates the list in-place. {@code mutator} is a void consumer, so any value
   * returned from a lambda will be ignored. Take care not to call pure functions, like {@link
   * Collection#stream()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mutator} is null
   */
  public Datatype.Builder mutateGeneratedBuilderAnnotations(
      Consumer<? super List<Excerpt>> mutator) {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = new ArrayList<>(generatedBuilderAnnotations);
    }
    // If addGeneratedBuilderAnnotations is overridden, this method will be updated to delegate to it
    mutator.accept(generatedBuilderAnnotations);
    return (Datatype.Builder) this;
  }

  /**
   * Clears the list to be returned from {@link Datatype#getGeneratedBuilderAnnotations()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearGeneratedBuilderAnnotations() {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = ImmutableList.of();
    } else {
      generatedBuilderAnnotations.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the list that will be returned by {@link
   * Datatype#getGeneratedBuilderAnnotations()}. Changes to this builder will be reflected in the
   * view.
   */
  public List<Excerpt> getGeneratedBuilderAnnotations() {
    if (generatedBuilderAnnotations instanceof ImmutableList) {
      generatedBuilderAnnotations = new ArrayList<>(generatedBuilderAnnotations);
    }
    return Collections.unmodifiableList(generatedBuilderAnnotations);
  }

  /**
   * Adds {@code element} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addValueTypeAnnotations(Excerpt element) {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = new ArrayList<>(valueTypeAnnotations);
    }
    valueTypeAnnotations.add(Objects.requireNonNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addValueTypeAnnotations(Excerpt... elements) {
    return addAllValueTypeAnnotations(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllValueTypeAnnotations(Spliterator<? extends Excerpt> elements) {
    if ((elements.characteristics() & Spliterator.SIZED) != 0) {
      long elementsSize = elements.estimateSize();
      if (elementsSize > 0 && elementsSize <= Integer.MAX_VALUE) {
        if (valueTypeAnnotations instanceof ImmutableList) {
          valueTypeAnnotations = new ArrayList<>(valueTypeAnnotations);
        }
        ((ArrayList<?>) valueTypeAnnotations)
            .ensureCapacity(valueTypeAnnotations.size() + (int) elementsSize);
      }
    }
    elements.forEachRemaining(this::addValueTypeAnnotations);
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllValueTypeAnnotations(BaseStream<? extends Excerpt, ?> elements) {
    return addAllValueTypeAnnotations(elements.spliterator());
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllValueTypeAnnotations(Iterable<? extends Excerpt> elements) {
    return addAllValueTypeAnnotations(elements.spliterator());
  }

  /**
   * Applies {@code mutator} to the list to be returned from {@link
   * Datatype#getValueTypeAnnotations()}.
   *
   * <p>This method mutates the list in-place. {@code mutator} is a void consumer, so any value
   * returned from a lambda will be ignored. Take care not to call pure functions, like {@link
   * Collection#stream()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mutator} is null
   */
  public Datatype.Builder mutateValueTypeAnnotations(Consumer<? super List<Excerpt>> mutator) {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = new ArrayList<>(valueTypeAnnotations);
    }
    // If addValueTypeAnnotations is overridden, this method will be updated to delegate to it
    mutator.accept(valueTypeAnnotations);
    return (Datatype.Builder) this;
  }

  /**
   * Clears the list to be returned from {@link Datatype#getValueTypeAnnotations()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearValueTypeAnnotations() {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = ImmutableList.of();
    } else {
      valueTypeAnnotations.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the list that will be returned by {@link
   * Datatype#getValueTypeAnnotations()}. Changes to this builder will be reflected in the view.
   */
  public List<Excerpt> getValueTypeAnnotations() {
    if (valueTypeAnnotations instanceof ImmutableList) {
      valueTypeAnnotations = new ArrayList<>(valueTypeAnnotations);
    }
    return Collections.unmodifiableList(valueTypeAnnotations);
  }

  /**
   * Sets the value to be returned by {@link Datatype#getValueTypeVisibility()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code valueTypeVisibility} is null
   */
  public Datatype.Builder setValueTypeVisibility(Datatype.Visibility valueTypeVisibility) {
    this.valueTypeVisibility = Objects.requireNonNull(valueTypeVisibility);
    _unsetProperties.remove(Property.VALUE_TYPE_VISIBILITY);
    return (Datatype.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link Datatype#getValueTypeVisibility()} by applying
   * {@code mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Builder mapValueTypeVisibility(UnaryOperator<Datatype.Visibility> mapper) {
    Objects.requireNonNull(mapper);
    return setValueTypeVisibility(mapper.apply(getValueTypeVisibility()));
  }

  /**
   * Returns the value that will be returned by {@link Datatype#getValueTypeVisibility()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public Datatype.Visibility getValueTypeVisibility() {
    Preconditions.checkState(
        !_unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY), "valueTypeVisibility not set");
    return valueTypeVisibility;
  }

  /**
   * Adds {@code element} to the list to be returned from {@link Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code element} is null
   */
  public Datatype.Builder addNestedClasses(Excerpt element) {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = new ArrayList<>(nestedClasses);
    }
    nestedClasses.add(Objects.requireNonNull(element));
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addNestedClasses(Excerpt... elements) {
    return addAllNestedClasses(Arrays.asList(elements));
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllNestedClasses(Spliterator<? extends Excerpt> elements) {
    if ((elements.characteristics() & Spliterator.SIZED) != 0) {
      long elementsSize = elements.estimateSize();
      if (elementsSize > 0 && elementsSize <= Integer.MAX_VALUE) {
        if (nestedClasses instanceof ImmutableList) {
          nestedClasses = new ArrayList<>(nestedClasses);
        }
        ((ArrayList<?>) nestedClasses).ensureCapacity(nestedClasses.size() + (int) elementsSize);
      }
    }
    elements.forEachRemaining(this::addNestedClasses);
    return (Datatype.Builder) this;
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllNestedClasses(BaseStream<? extends Excerpt, ?> elements) {
    return addAllNestedClasses(elements.spliterator());
  }

  /**
   * Adds each element of {@code elements} to the list to be returned from {@link
   * Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code elements} is null or contains a null element
   */
  public Datatype.Builder addAllNestedClasses(Iterable<? extends Excerpt> elements) {
    return addAllNestedClasses(elements.spliterator());
  }

  /**
   * Applies {@code mutator} to the list to be returned from {@link Datatype#getNestedClasses()}.
   *
   * <p>This method mutates the list in-place. {@code mutator} is a void consumer, so any value
   * returned from a lambda will be ignored. Take care not to call pure functions, like {@link
   * Collection#stream()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mutator} is null
   */
  public Datatype.Builder mutateNestedClasses(Consumer<? super List<Excerpt>> mutator) {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = new ArrayList<>(nestedClasses);
    }
    // If addNestedClasses is overridden, this method will be updated to delegate to it
    mutator.accept(nestedClasses);
    return (Datatype.Builder) this;
  }

  /**
   * Clears the list to be returned from {@link Datatype#getNestedClasses()}.
   *
   * @return this {@code Builder} object
   */
  public Datatype.Builder clearNestedClasses() {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = ImmutableList.of();
    } else {
      nestedClasses.clear();
    }
    return (Datatype.Builder) this;
  }

  /**
   * Returns an unmodifiable view of the list that will be returned by {@link
   * Datatype#getNestedClasses()}. Changes to this builder will be reflected in the view.
   */
  public List<Excerpt> getNestedClasses() {
    if (nestedClasses instanceof ImmutableList) {
      nestedClasses = new ArrayList<>(nestedClasses);
    }
    return Collections.unmodifiableList(nestedClasses);
  }

  /** Sets all property values using the given {@code Datatype} as a template. */
  public Datatype.Builder mergeFrom(Datatype value) {
    Datatype_Builder defaults = new Datatype.Builder();
    if (defaults._unsetProperties.contains(Property.TYPE)
        || !Objects.equals(value.getType(), defaults.getType())) {
      setType(value.getType());
    }
    if (defaults._unsetProperties.contains(Property.INTERFACE_TYPE)
        || value.isInterfaceType() != defaults.isInterfaceType()) {
      setInterfaceType(value.isInterfaceType());
    }
    if (defaults._unsetProperties.contains(Property.BUILDER)
        || !Objects.equals(value.getBuilder(), defaults.getBuilder())) {
      setBuilder(value.getBuilder());
    }
    if (defaults._unsetProperties.contains(Property.EXTENSIBLE)
        || value.isExtensible() != defaults.isExtensible()) {
      setExtensible(value.isExtensible());
    }
    value.getBuilderFactory().ifPresent(this::setBuilderFactory);
    if (defaults._unsetProperties.contains(Property.GENERATED_BUILDER)
        || !Objects.equals(value.getGeneratedBuilder(), defaults.getGeneratedBuilder())) {
      setGeneratedBuilder(value.getGeneratedBuilder());
    }
    if (defaults._unsetProperties.contains(Property.VALUE_TYPE)
        || !Objects.equals(value.getValueType(), defaults.getValueType())) {
      setValueType(value.getValueType());
    }
    if (defaults._unsetProperties.contains(Property.PARTIAL_TYPE)
        || !Objects.equals(value.getPartialType(), defaults.getPartialType())) {
      setPartialType(value.getPartialType());
    }
    if (defaults._unsetProperties.contains(Property.PROPERTY_ENUM)
        || !Objects.equals(value.getPropertyEnum(), defaults.getPropertyEnum())) {
      setPropertyEnum(value.getPropertyEnum());
    }
    putAllStandardMethodUnderrides(value.getStandardMethodUnderrides());
    if (defaults._unsetProperties.contains(Property.BUILDER_SERIALIZABLE)
        || value.isBuilderSerializable() != defaults.isBuilderSerializable()) {
      setBuilderSerializable(value.isBuilderSerializable());
    }
    if (defaults._unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)
        || value.getHasToBuilderMethod() != defaults.getHasToBuilderMethod()) {
      setHasToBuilderMethod(value.getHasToBuilderMethod());
    }
    if (value instanceof Value && generatedBuilderAnnotations == ImmutableList.<Excerpt>of()) {
      generatedBuilderAnnotations = ImmutableList.copyOf(value.getGeneratedBuilderAnnotations());
    } else {
      addAllGeneratedBuilderAnnotations(value.getGeneratedBuilderAnnotations());
    }
    if (value instanceof Value && valueTypeAnnotations == ImmutableList.<Excerpt>of()) {
      valueTypeAnnotations = ImmutableList.copyOf(value.getValueTypeAnnotations());
    } else {
      addAllValueTypeAnnotations(value.getValueTypeAnnotations());
    }
    if (defaults._unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)
        || !Objects.equals(value.getValueTypeVisibility(), defaults.getValueTypeVisibility())) {
      setValueTypeVisibility(value.getValueTypeVisibility());
    }
    if (value instanceof Value && nestedClasses == ImmutableList.<Excerpt>of()) {
      nestedClasses = ImmutableList.copyOf(value.getNestedClasses());
    } else {
      addAllNestedClasses(value.getNestedClasses());
    }
    return (Datatype.Builder) this;
  }

  /**
   * Copies values from the given {@code Builder}. Does not affect any properties not set on the
   * input.
   */
  public Datatype.Builder mergeFrom(Datatype.Builder template) {
    // Upcast to access private fields; otherwise, oddly, we get an access violation.
    Datatype_Builder base = template;
    Datatype_Builder defaults = new Datatype.Builder();
    if (!base._unsetProperties.contains(Property.TYPE)
        && (defaults._unsetProperties.contains(Property.TYPE)
            || !Objects.equals(template.getType(), defaults.getType()))) {
      setType(template.getType());
    }
    if (!base._unsetProperties.contains(Property.INTERFACE_TYPE)
        && (defaults._unsetProperties.contains(Property.INTERFACE_TYPE)
            || template.isInterfaceType() != defaults.isInterfaceType())) {
      setInterfaceType(template.isInterfaceType());
    }
    if (!base._unsetProperties.contains(Property.BUILDER)
        && (defaults._unsetProperties.contains(Property.BUILDER)
            || !Objects.equals(template.getBuilder(), defaults.getBuilder()))) {
      setBuilder(template.getBuilder());
    }
    if (!base._unsetProperties.contains(Property.EXTENSIBLE)
        && (defaults._unsetProperties.contains(Property.EXTENSIBLE)
            || template.isExtensible() != defaults.isExtensible())) {
      setExtensible(template.isExtensible());
    }
    template.getBuilderFactory().ifPresent(this::setBuilderFactory);
    if (!base._unsetProperties.contains(Property.GENERATED_BUILDER)
        && (defaults._unsetProperties.contains(Property.GENERATED_BUILDER)
            || !Objects.equals(template.getGeneratedBuilder(), defaults.getGeneratedBuilder()))) {
      setGeneratedBuilder(template.getGeneratedBuilder());
    }
    if (!base._unsetProperties.contains(Property.VALUE_TYPE)
        && (defaults._unsetProperties.contains(Property.VALUE_TYPE)
            || !Objects.equals(template.getValueType(), defaults.getValueType()))) {
      setValueType(template.getValueType());
    }
    if (!base._unsetProperties.contains(Property.PARTIAL_TYPE)
        && (defaults._unsetProperties.contains(Property.PARTIAL_TYPE)
            || !Objects.equals(template.getPartialType(), defaults.getPartialType()))) {
      setPartialType(template.getPartialType());
    }
    if (!base._unsetProperties.contains(Property.PROPERTY_ENUM)
        && (defaults._unsetProperties.contains(Property.PROPERTY_ENUM)
            || !Objects.equals(template.getPropertyEnum(), defaults.getPropertyEnum()))) {
      setPropertyEnum(template.getPropertyEnum());
    }
    putAllStandardMethodUnderrides(base.standardMethodUnderrides);
    if (!base._unsetProperties.contains(Property.BUILDER_SERIALIZABLE)
        && (defaults._unsetProperties.contains(Property.BUILDER_SERIALIZABLE)
            || template.isBuilderSerializable() != defaults.isBuilderSerializable())) {
      setBuilderSerializable(template.isBuilderSerializable());
    }
    if (!base._unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)
        && (defaults._unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)
            || template.getHasToBuilderMethod() != defaults.getHasToBuilderMethod())) {
      setHasToBuilderMethod(template.getHasToBuilderMethod());
    }
    addAllGeneratedBuilderAnnotations(base.generatedBuilderAnnotations);
    addAllValueTypeAnnotations(base.valueTypeAnnotations);
    if (!base._unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)
        && (defaults._unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)
            || !Objects.equals(
                template.getValueTypeVisibility(), defaults.getValueTypeVisibility()))) {
      setValueTypeVisibility(template.getValueTypeVisibility());
    }
    addAllNestedClasses(base.nestedClasses);
    return (Datatype.Builder) this;
  }

  /** Resets the state of this builder. */
  public Datatype.Builder clear() {
    Datatype_Builder defaults = new Datatype.Builder();
    type = defaults.type;
    interfaceType = defaults.interfaceType;
    builder = defaults.builder;
    extensible = defaults.extensible;
    builderFactory = defaults.builderFactory;
    generatedBuilder = defaults.generatedBuilder;
    valueType = defaults.valueType;
    partialType = defaults.partialType;
    propertyEnum = defaults.propertyEnum;
    standardMethodUnderrides.clear();
    builderSerializable = defaults.builderSerializable;
    hasToBuilderMethod = defaults.hasToBuilderMethod;
    clearGeneratedBuilderAnnotations();
    clearValueTypeAnnotations();
    valueTypeVisibility = defaults.valueTypeVisibility;
    clearNestedClasses();
    _unsetProperties.clear();
    _unsetProperties.addAll(defaults._unsetProperties);
    return (Datatype.Builder) this;
  }

  /**
   * Returns a newly-created {@link Datatype} based on the contents of the {@code Builder}.
   *
   * @throws IllegalStateException if any field has not been set
   */
  public Datatype build() {
    Preconditions.checkState(_unsetProperties.isEmpty(), "Not set: %s", _unsetProperties);
    return new Value(this);
  }

  /**
   * Returns a newly-created partial {@link Datatype} for use in unit tests. State checking will not
   * be performed. Unset properties will throw an {@link UnsupportedOperationException} when
   * accessed via the partial object.
   *
   * <p>Partials should only ever be used in tests. They permit writing robust test cases that won't
   * fail if this type gains more application-level constraints (e.g. new required fields) in
   * future. If you require partially complete values in production code, consider using a Builder.
   */
  @VisibleForTesting()
  public Datatype buildPartial() {
    return new Partial(this);
  }

  private static final class Value extends Datatype {
    private final TypeClass type;
    private final boolean interfaceType;
    private final Type builder;
    private final boolean extensible;
    // Store a nullable object instead of an Optional. Escape analysis then
    // allows the JVM to optimize away the Optional objects created by our
    // getter method.
    private final BuilderFactory builderFactory;
    private final TypeClass generatedBuilder;
    private final TypeClass valueType;
    private final TypeClass partialType;
    private final TypeClass propertyEnum;
    private final ImmutableMap<StandardMethod, UnderrideLevel> standardMethodUnderrides;
    private final boolean builderSerializable;
    private final boolean hasToBuilderMethod;
    private final ImmutableList<Excerpt> generatedBuilderAnnotations;
    private final ImmutableList<Excerpt> valueTypeAnnotations;
    private final Visibility valueTypeVisibility;
    private final ImmutableList<Excerpt> nestedClasses;

    private Value(Datatype_Builder builder) {
      this.type = builder.type;
      this.interfaceType = builder.interfaceType;
      this.builder = builder.builder;
      this.extensible = builder.extensible;
      this.builderFactory = builder.builderFactory;
      this.generatedBuilder = builder.generatedBuilder;
      this.valueType = builder.valueType;
      this.partialType = builder.partialType;
      this.propertyEnum = builder.propertyEnum;
      this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
      this.builderSerializable = builder.builderSerializable;
      this.hasToBuilderMethod = builder.hasToBuilderMethod;
      this.generatedBuilderAnnotations = ImmutableList.copyOf(builder.generatedBuilderAnnotations);
      this.valueTypeAnnotations = ImmutableList.copyOf(builder.valueTypeAnnotations);
      this.valueTypeVisibility = builder.valueTypeVisibility;
      this.nestedClasses = ImmutableList.copyOf(builder.nestedClasses);
    }

    @Override
    public TypeClass getType() {
      return type;
    }

    @Override
    public boolean isInterfaceType() {
      return interfaceType;
    }

    @Override
    public Type getBuilder() {
      return builder;
    }

    @Override
    public boolean isExtensible() {
      return extensible;
    }

    @Override
    public Optional<BuilderFactory> getBuilderFactory() {
      return Optional.ofNullable(builderFactory);
    }

    @Override
    public TypeClass getGeneratedBuilder() {
      return generatedBuilder;
    }

    @Override
    public TypeClass getValueType() {
      return valueType;
    }

    @Override
    public TypeClass getPartialType() {
      return partialType;
    }

    @Override
    public TypeClass getPropertyEnum() {
      return propertyEnum;
    }

    @Override
    public ImmutableMap<StandardMethod, UnderrideLevel> getStandardMethodUnderrides() {
      return standardMethodUnderrides;
    }

    @Override
    public boolean isBuilderSerializable() {
      return builderSerializable;
    }

    @Override
    public boolean getHasToBuilderMethod() {
      return hasToBuilderMethod;
    }

    @Override
    public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
      return generatedBuilderAnnotations;
    }

    @Override
    public ImmutableList<Excerpt> getValueTypeAnnotations() {
      return valueTypeAnnotations;
    }

    @Override
    public Visibility getValueTypeVisibility() {
      return valueTypeVisibility;
    }

    @Override
    public ImmutableList<Excerpt> getNestedClasses() {
      return nestedClasses;
    }

    @Override
    public boolean equals(Object obj) {
      if (!(obj instanceof Value)) {
        return false;
      }
      Value other = (Value) obj;
      return Objects.equals(type, other.type)
          && interfaceType == other.interfaceType
          && Objects.equals(builder, other.builder)
          && extensible == other.extensible
          && Objects.equals(builderFactory, other.builderFactory)
          && Objects.equals(generatedBuilder, other.generatedBuilder)
          && Objects.equals(valueType, other.valueType)
          && Objects.equals(partialType, other.partialType)
          && Objects.equals(propertyEnum, other.propertyEnum)
          && Objects.equals(standardMethodUnderrides, other.standardMethodUnderrides)
          && builderSerializable == other.builderSerializable
          && hasToBuilderMethod == other.hasToBuilderMethod
          && Objects.equals(generatedBuilderAnnotations, other.generatedBuilderAnnotations)
          && Objects.equals(valueTypeAnnotations, other.valueTypeAnnotations)
          && Objects.equals(valueTypeVisibility, other.valueTypeVisibility)
          && Objects.equals(nestedClasses, other.nestedClasses);
    }

    @Override
    public int hashCode() {
      return Objects.hash(
          type,
          interfaceType,
          builder,
          extensible,
          builderFactory,
          generatedBuilder,
          valueType,
          partialType,
          propertyEnum,
          standardMethodUnderrides,
          builderSerializable,
          hasToBuilderMethod,
          generatedBuilderAnnotations,
          valueTypeAnnotations,
          valueTypeVisibility,
          nestedClasses);
    }

    @Override
    public String toString() {
      StringBuilder result =
          new StringBuilder("Datatype{type=")
              .append(type)
              .append(", interfaceType=")
              .append(interfaceType)
              .append(", builder=")
              .append(builder)
              .append(", extensible=")
              .append(extensible);
      if (builderFactory != null) {
        result.append(", builderFactory=").append(builderFactory);
      }
      return result
          .append(", generatedBuilder=")
          .append(generatedBuilder)
          .append(", valueType=")
          .append(valueType)
          .append(", partialType=")
          .append(partialType)
          .append(", propertyEnum=")
          .append(propertyEnum)
          .append(", standardMethodUnderrides=")
          .append(standardMethodUnderrides)
          .append(", builderSerializable=")
          .append(builderSerializable)
          .append(", hasToBuilderMethod=")
          .append(hasToBuilderMethod)
          .append(", generatedBuilderAnnotations=")
          .append(generatedBuilderAnnotations)
          .append(", valueTypeAnnotations=")
          .append(valueTypeAnnotations)
          .append(", valueTypeVisibility=")
          .append(valueTypeVisibility)
          .append(", nestedClasses=")
          .append(nestedClasses)
          .append("}")
          .toString();
    }
  }

  private static final class Partial extends Datatype {
    private final TypeClass type;
    private final boolean interfaceType;
    private final Type builder;
    private final boolean extensible;
    // Store a nullable object instead of an Optional. Escape analysis then
    // allows the JVM to optimize away the Optional objects created by our
    // getter method.
    private final BuilderFactory builderFactory;
    private final TypeClass generatedBuilder;
    private final TypeClass valueType;
    private final TypeClass partialType;
    private final TypeClass propertyEnum;
    private final ImmutableMap<StandardMethod, UnderrideLevel> standardMethodUnderrides;
    private final boolean builderSerializable;
    private final boolean hasToBuilderMethod;
    private final ImmutableList<Excerpt> generatedBuilderAnnotations;
    private final ImmutableList<Excerpt> valueTypeAnnotations;
    private final Visibility valueTypeVisibility;
    private final ImmutableList<Excerpt> nestedClasses;
    private final EnumSet<Property> _unsetProperties;

    Partial(Datatype_Builder builder) {
      this.type = builder.type;
      this.interfaceType = builder.interfaceType;
      this.builder = builder.builder;
      this.extensible = builder.extensible;
      this.builderFactory = builder.builderFactory;
      this.generatedBuilder = builder.generatedBuilder;
      this.valueType = builder.valueType;
      this.partialType = builder.partialType;
      this.propertyEnum = builder.propertyEnum;
      this.standardMethodUnderrides = ImmutableMap.copyOf(builder.standardMethodUnderrides);
      this.builderSerializable = builder.builderSerializable;
      this.hasToBuilderMethod = builder.hasToBuilderMethod;
      this.generatedBuilderAnnotations = ImmutableList.copyOf(builder.generatedBuilderAnnotations);
      this.valueTypeAnnotations = ImmutableList.copyOf(builder.valueTypeAnnotations);
      this.valueTypeVisibility = builder.valueTypeVisibility;
      this.nestedClasses = ImmutableList.copyOf(builder.nestedClasses);
      this._unsetProperties = builder._unsetProperties.clone();
    }

    @Override
    public TypeClass getType() {
      if (_unsetProperties.contains(Property.TYPE)) {
        throw new UnsupportedOperationException("type not set");
      }
      return type;
    }

    @Override
    public boolean isInterfaceType() {
      if (_unsetProperties.contains(Property.INTERFACE_TYPE)) {
        throw new UnsupportedOperationException("interfaceType not set");
      }
      return interfaceType;
    }

    @Override
    public Type getBuilder() {
      if (_unsetProperties.contains(Property.BUILDER)) {
        throw new UnsupportedOperationException("builder not set");
      }
      return builder;
    }

    @Override
    public boolean isExtensible() {
      if (_unsetProperties.contains(Property.EXTENSIBLE)) {
        throw new UnsupportedOperationException("extensible not set");
      }
      return extensible;
    }

    @Override
    public Optional<BuilderFactory> getBuilderFactory() {
      return Optional.ofNullable(builderFactory);
    }

    @Override
    public TypeClass getGeneratedBuilder() {
      if (_unsetProperties.contains(Property.GENERATED_BUILDER)) {
        throw new UnsupportedOperationException("generatedBuilder not set");
      }
      return generatedBuilder;
    }

    @Override
    public TypeClass getValueType() {
      if (_unsetProperties.contains(Property.VALUE_TYPE)) {
        throw new UnsupportedOperationException("valueType not set");
      }
      return valueType;
    }

    @Override
    public TypeClass getPartialType() {
      if (_unsetProperties.contains(Property.PARTIAL_TYPE)) {
        throw new UnsupportedOperationException("partialType not set");
      }
      return partialType;
    }

    @Override
    public TypeClass getPropertyEnum() {
      if (_unsetProperties.contains(Property.PROPERTY_ENUM)) {
        throw new UnsupportedOperationException("propertyEnum not set");
      }
      return propertyEnum;
    }

    @Override
    public ImmutableMap<StandardMethod, UnderrideLevel> getStandardMethodUnderrides() {
      return standardMethodUnderrides;
    }

    @Override
    public boolean isBuilderSerializable() {
      if (_unsetProperties.contains(Property.BUILDER_SERIALIZABLE)) {
        throw new UnsupportedOperationException("builderSerializable not set");
      }
      return builderSerializable;
    }

    @Override
    public boolean getHasToBuilderMethod() {
      if (_unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)) {
        throw new UnsupportedOperationException("hasToBuilderMethod not set");
      }
      return hasToBuilderMethod;
    }

    @Override
    public ImmutableList<Excerpt> getGeneratedBuilderAnnotations() {
      return generatedBuilderAnnotations;
    }

    @Override
    public ImmutableList<Excerpt> getValueTypeAnnotations() {
      return valueTypeAnnotations;
    }

    @Override
    public Visibility getValueTypeVisibility() {
      if (_unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)) {
        throw new UnsupportedOperationException("valueTypeVisibility not set");
      }
      return valueTypeVisibility;
    }

    @Override
    public ImmutableList<Excerpt> getNestedClasses() {
      return nestedClasses;
    }

    @Override
    public boolean equals(Object obj) {
      if (!(obj instanceof Partial)) {
        return false;
      }
      Partial other = (Partial) obj;
      return Objects.equals(type, other.type)
          && interfaceType == other.interfaceType
          && Objects.equals(builder, other.builder)
          && extensible == other.extensible
          && Objects.equals(builderFactory, other.builderFactory)
          && Objects.equals(generatedBuilder, other.generatedBuilder)
          && Objects.equals(valueType, other.valueType)
          && Objects.equals(partialType, other.partialType)
          && Objects.equals(propertyEnum, other.propertyEnum)
          && Objects.equals(standardMethodUnderrides, other.standardMethodUnderrides)
          && builderSerializable == other.builderSerializable
          && hasToBuilderMethod == other.hasToBuilderMethod
          && Objects.equals(generatedBuilderAnnotations, other.generatedBuilderAnnotations)
          && Objects.equals(valueTypeAnnotations, other.valueTypeAnnotations)
          && Objects.equals(valueTypeVisibility, other.valueTypeVisibility)
          && Objects.equals(nestedClasses, other.nestedClasses)
          && Objects.equals(_unsetProperties, other._unsetProperties);
    }

    @Override
    public int hashCode() {
      return Objects.hash(
          type,
          interfaceType,
          builder,
          extensible,
          builderFactory,
          generatedBuilder,
          valueType,
          partialType,
          propertyEnum,
          standardMethodUnderrides,
          builderSerializable,
          hasToBuilderMethod,
          generatedBuilderAnnotations,
          valueTypeAnnotations,
          valueTypeVisibility,
          nestedClasses,
          _unsetProperties);
    }

    @Override
    public String toString() {
      StringBuilder result = new StringBuilder("partial Datatype{");
      if (!_unsetProperties.contains(Property.TYPE)) {
        result.append("type=").append(type).append(", ");
      }
      if (!_unsetProperties.contains(Property.INTERFACE_TYPE)) {
        result.append("interfaceType=").append(interfaceType).append(", ");
      }
      if (!_unsetProperties.contains(Property.BUILDER)) {
        result.append("builder=").append(builder).append(", ");
      }
      if (!_unsetProperties.contains(Property.EXTENSIBLE)) {
        result.append("extensible=").append(extensible).append(", ");
      }
      if (builderFactory != null) {
        result.append("builderFactory=").append(builderFactory).append(", ");
      }
      if (!_unsetProperties.contains(Property.GENERATED_BUILDER)) {
        result.append("generatedBuilder=").append(generatedBuilder).append(", ");
      }
      if (!_unsetProperties.contains(Property.VALUE_TYPE)) {
        result.append("valueType=").append(valueType).append(", ");
      }
      if (!_unsetProperties.contains(Property.PARTIAL_TYPE)) {
        result.append("partialType=").append(partialType).append(", ");
      }
      if (!_unsetProperties.contains(Property.PROPERTY_ENUM)) {
        result.append("propertyEnum=").append(propertyEnum).append(", ");
      }
      result.append("standardMethodUnderrides=").append(standardMethodUnderrides);
      if (!_unsetProperties.contains(Property.BUILDER_SERIALIZABLE)) {
        result.append(", builderSerializable=").append(builderSerializable);
      }
      if (!_unsetProperties.contains(Property.HAS_TO_BUILDER_METHOD)) {
        result.append(", hasToBuilderMethod=").append(hasToBuilderMethod);
      }
      result
          .append(", generatedBuilderAnnotations=")
          .append(generatedBuilderAnnotations)
          .append(", valueTypeAnnotations=")
          .append(valueTypeAnnotations);
      if (!_unsetProperties.contains(Property.VALUE_TYPE_VISIBILITY)) {
        result.append(", valueTypeVisibility=").append(valueTypeVisibility);
      }
      return result.append(", nestedClasses=").append(nestedClasses).append("}").toString();
    }
  }
}
