package org.inferred.freebuilder.processor;

import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.TypeClass;

class GeneratedStub extends GeneratedType {

  private final QualifiedName datatype;
  private final TypeClass stub;

  GeneratedStub(QualifiedName datatype, TypeClass stub) {
    this.datatype = datatype;
    this.stub = stub;
  }

  @Override
  public void addTo(SourceBuilder code) {
    code.addLine("// Autogenerated code. Do not modify.")
        .addLine("package %s;", stub.getQualifiedName().getPackage())
        .addLine("")
        .addLine("/**")
        .addLine(" * Placeholder. Create {@code %s.Builder} and subclass this type.", datatype)
        .addLine(" */")
        .add(Excerpts.generated(Processor.class))
        .addLine("abstract class %s {}", stub.declaration());
  }

  @Override
  protected void addFields(FieldReceiver fields) {
    fields.add("datatype", datatype);
    fields.add("stub", stub);
  }
}
