/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.BaseStream;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.BuildableType;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.BuildableList;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.Variable;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

class BuildableListProperty
extends PropertyCodeGenerator {
    private final boolean needsSafeVarargs;
    private final boolean overridesValueInstanceVarargsAddMethod;
    private final boolean overridesBuilderVarargsAddMethod;
    private final BuildableType element;

    private BuildableListProperty(Datatype datatype, Property property, boolean needsSafeVarargs, boolean overridesValueInstanceVarargsAddMethod, boolean overridesBuilderVarargsAddMethod, BuildableType element) {
        super(datatype, property);
        this.needsSafeVarargs = needsSafeVarargs;
        this.overridesValueInstanceVarargsAddMethod = overridesValueInstanceVarargsAddMethod;
        this.overridesBuilderVarargsAddMethod = overridesBuilderVarargsAddMethod;
        this.element = element;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %1$s %2$s = new %1$s();", BuildableList.of(this.element), this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addValueInstanceAdd(code);
        this.addBuilderAdd(code);
        this.addValueInstanceVarargsAdd(code);
        this.addBuilderVarargsAdd(code);
        this.addSpliteratorValueInstanceAddAll(code);
        this.addSpliteratorBuilderAddAll(code);
        this.addIterableValueInstanceAddAll(code);
        this.addIterableBuilderAddAll(code);
        this.addStreamValueInstanceAddAll(code);
        this.addStreamBuilderAddAll(code);
        this.addMutate(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addValueInstanceAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>The element <em>may</em> be converted to/from a builder in this process;", new Object[0]).addLine(" * you should not rely on the instance you provide being (or not being) present", new Object[0]).addLine(" * in the final list.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.element.type()).addLine("  %s.addValue(element);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addBuilderAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds the value built by {@code builder} to the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>Only a copy of the builder will be stored; any changes made to it after", new Object[0]).addLine(" * returning from this method will not affect the value stored in the list.", new Object[0]).addLine(" *", new Object[0]).addLine(" * <p>The copied builder's {@link %s build()} method will not be called until", this.element.builderType().javadocNoArgMethodLink("build")).addLine(" * this object's {@link %s build() method} is, so if the builder's state is not", this.datatype.getBuilder().javadocNoArgMethodLink("build")).addLine(" * legal, you will not get failures until then.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code builder} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s builder) {", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.element.builderType()).addLine("  %s.add(%s.mergeFrom(builder));", this.property.getField(), this.element.builderFactory().newBuilder(this.element.builderType(), BuilderFactory.TypeInference.EXPLICIT_TYPES)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addJavadocForAddingMultipleValues(SourceBuilder code) {
        code.addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>Each element <em>may</em> be converted to/from a builder in this process;", new Object[0]).addLine(" * you should not rely on any of the instances you provide being (or not being)", new Object[0]).addLine(" * present in the final list.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
    }

    private void addJavadocForAddingMultipleBuilders(SourceBuilder code) {
        code.addLine("/**", new Object[0]).addLine(" * Adds the values built by each element of {@code elementBuilders} to", new Object[0]).addLine(" * the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>Only copies of the builders will be stored; any changes made to them after", new Object[0]).addLine(" * returning from this method will not affect the values stored in the list.", new Object[0]).addLine(" *", new Object[0]).addLine(" * <p>The copied builders' {@link %s build()} methods will not be called until", this.element.builderType().javadocNoArgMethodLink("build")).addLine(" * this object's {@link %s build() method} is, so if any builder's state is not", this.datatype.getBuilder().javadocNoArgMethodLink("build")).addLine(" * legal, you will not get failures until then.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elementBuilders} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
    }

    private void addValueInstanceVarargsAdd(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleValues(code);
        this.addSafeVarargsForPublicMethod(code, this.overridesValueInstanceVarargsAddMethod);
        code.add("%s %s(%s... elements) {%n", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.element.type()).addLine("  return %s(%s.asList(elements));", BuilderMethods.addAllMethod(this.property), Arrays.class).addLine("}", new Object[0]);
    }

    private void addBuilderVarargsAdd(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleBuilders(code);
        this.addSafeVarargsForPublicMethod(code, this.overridesBuilderVarargsAddMethod);
        code.add("%s %s(%s... elementBuilders) {%n", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.element.builderType()).addLine("  return %s(%s.asList(elementBuilders));", BuilderMethods.addAllBuildersOfMethod(this.property), Arrays.class).addLine("}", new Object[0]);
    }

    private void addSafeVarargsForPublicMethod(SourceBuilder code, boolean isOverridden) {
        if (this.needsSafeVarargs) {
            if (!isOverridden) {
                code.addLine("@%s", SafeVarargs.class).addLine("@%s({\"varargs\"})", SuppressWarnings.class);
            } else {
                code.addLine("@%s({\"unchecked\", \"varargs\"})", SuppressWarnings.class);
            }
        }
        code.add("public ", new Object[0]);
        if (this.needsSafeVarargs && !isOverridden) {
            code.add("final ", new Object[0]);
        }
    }

    private void addSpliteratorValueInstanceAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleValues(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Spliterator.class, this.element.type()).addLine("  if ((elements.characteristics() & %s.SIZED) != 0) {", Spliterator.class);
        Variable newSize = new Variable("newSize");
        code.addLine("    long %s = elements.estimateSize() + %s.size();", newSize, this.property.getField()).addLine("    if (%s <= Integer.MAX_VALUE) {", newSize).addLine("      %s.ensureCapacity((int) %s);", this.property.getField(), newSize).addLine("    }", new Object[0]).addLine("  }", new Object[0]).addLine("  elements.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addSpliteratorBuilderAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleBuilders(code);
        Variable newSize = new Variable("newSize");
        code.addLine("public %s %s(%s<? extends %s> elementBuilders) {", this.datatype.getBuilder(), BuilderMethods.addAllBuildersOfMethod(this.property), Spliterator.class, this.element.builderType()).addLine("  if ((elementBuilders.characteristics() & %s.SIZED) != 0) {", Spliterator.class).addLine("    long %s = elementBuilders.estimateSize() + %s.size();", newSize, this.property.getField()).addLine("    if (%s <= Integer.MAX_VALUE) {", newSize).addLine("      %s.ensureCapacity((int) %s);", this.property.getField(), newSize).addLine("    }", new Object[0]).addLine("  }", new Object[0]).addLine("  elementBuilders.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addIterableValueInstanceAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleValues(code);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.element.type());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  %s.addAllValues(elements);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder());
        } else {
            code.addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property));
        }
        code.addLine("}", new Object[0]);
    }

    private void addIterableBuilderAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleBuilders(code);
        code.addLine("public %s %s(%s<? extends %s> elementBuilders) {", this.datatype.getBuilder(), BuilderMethods.addAllBuildersOfMethod(this.property), Iterable.class, this.element.builderType()).addLine("  return %s(elementBuilders.spliterator());", BuilderMethods.addAllBuildersOfMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addStreamValueInstanceAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleValues(code);
        code.addLine("public %s %s(%s<? extends %s, ?> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), BaseStream.class, this.element.type()).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addStreamBuilderAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.addJavadocForAddingMultipleBuilders(code);
        code.addLine("public %s %s(%s<? extends %s, ?> elementBuilders) {", this.datatype.getBuilder(), BuilderMethods.addAllBuildersOfMethod(this.property), BaseStream.class, this.element.builderType()).addLine("  return %s(elementBuilders.spliterator());", BuilderMethods.addAllBuildersOfMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to a list of builders for the elements of the list", new Object[0]).addLine(" * that will be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the list in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s<? super %s<%s>> mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), Consumer.class, List.class, this.element.builderType()).addLine("  mutator.accept(%s);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable list of mutable builders for the elements of the", new Object[0]).addLine(" * list that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view, and changes to", new Object[0]).addLine(" * the element builders in the view will affect this builder.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", List.class, this.element.builderType(), BuilderMethods.getBuildersMethod(this.property)).addLine("  return %s.unmodifiableList(%s);", Collections.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        this.addFieldAssignment(code, finalField, builder, "build");
    }

    @Override
    public void addPartialFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        this.addFieldAssignment(code, finalField, builder, "buildPartial");
    }

    private void addFieldAssignment(SourceBuilder code, Excerpt finalField, String builder, String buildMethod) {
        code.addLine("%s = %s.%s();", finalField, this.property.getField().on(builder), buildMethod);
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.addAllBuildersOfMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s();", BuilderMethods.clearMethod(this.property));
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<BuildableListProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType type = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (type == null || !Util.erasesToAnyOf(type, Collection.class, List.class, ImmutableList.class)) {
                return Optional.empty();
            }
            if (Factory.disablingGetterExists(config)) {
                return Optional.empty();
            }
            TypeMirror rawElementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
            DeclaredType elementType = ModelUtils.maybeDeclared(rawElementType).orElse(null);
            if (elementType == null) {
                return Optional.empty();
            }
            DeclaredType elementBuilder = BuildableType.maybeBuilder(elementType, config.getElements(), config.getTypes()).orElse(null);
            if (elementBuilder == null) {
                return Optional.empty();
            }
            BuildableType element = BuildableType.create(elementType, elementBuilder, config.getElements(), config.getTypes());
            boolean needsSafeVarargs = ModelUtils.needsSafeVarargs(rawElementType);
            boolean overridesValueInstanceVarargsAddMethod = Factory.hasValueInstanceVarargsAddMethodOverride(config, rawElementType);
            boolean overridesBuilderVarargsAddMethod = Factory.hasBuilderVarargsAddMethodOverride(config, element.builderType());
            return Optional.of(new BuildableListProperty(config.getDatatype(), config.getProperty(), needsSafeVarargs, overridesValueInstanceVarargsAddMethod, overridesBuilderVarargsAddMethod, element));
        }

        private static boolean disablingGetterExists(PropertyCodeGenerator.Config config) {
            String getterName = config.getProperty().getGetterName();
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), getterName, new TypeMirror[0]);
        }

        private static boolean hasValueInstanceVarargsAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), config.getTypes().getArrayType(elementType));
        }

        private static boolean hasBuilderVarargsAddMethodOverride(PropertyCodeGenerator.Config config, Type builderType) {
            TypeMirror rawBuilderType = config.getElements().getTypeElement(builderType.getQualifiedName().toString()).asType();
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), config.getTypes().getArrayType(rawBuilderType));
        }
    }
}

