/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

class JacksonSupport {
    private static final String JSON_DESERIALIZE = "com.fasterxml.jackson.databind.annotation.JsonDeserialize";
    private static final QualifiedName JSON_PROPERTY = QualifiedName.of("com.fasterxml.jackson.annotation", "JsonProperty", new String[0]);
    private static final QualifiedName JACKSON_XML_PROPERTY = QualifiedName.of("com.fasterxml.jackson.dataformat.xml.annotation", "JacksonXmlProperty", new String[0]);
    private static final Set<QualifiedName> DISABLE_PROPERTY_ANNOTATIONS = ImmutableSet.of(QualifiedName.of("com.fasterxml.jackson.annotation", "JsonAnyGetter", new String[0]), QualifiedName.of("com.fasterxml.jackson.annotation", "JsonIgnore", new String[0]), QualifiedName.of("com.fasterxml.jackson.annotation", "JsonUnwrapped", new String[0]), QualifiedName.of("com.fasterxml.jackson.annotation", "JsonValue", new String[0]));

    public static Optional<JacksonSupport> create(TypeElement userValueType) {
        return ModelUtils.findAnnotationMirror((Element)userValueType, JSON_DESERIALIZE).map($ -> new JacksonSupport());
    }

    private JacksonSupport() {
    }

    public void addJacksonAnnotations(Property.Builder resultBuilder, ExecutableElement getterMethod) {
        Optional<AnnotationMirror> jsonPropertyAnnotation = ModelUtils.findAnnotationMirror((Element)getterMethod, JSON_PROPERTY);
        if (jsonPropertyAnnotation.isPresent()) {
            resultBuilder.addAccessorAnnotations(Excerpts.add("%s%n", jsonPropertyAnnotation.get()));
        } else if (JacksonSupport.generateDefaultAnnotations(getterMethod)) {
            resultBuilder.addAccessorAnnotations(Excerpts.add("@%s(\"%s\")%n", JSON_PROPERTY, resultBuilder.getName()));
        }
        Optional<AnnotationMirror> jacksonXmlPropertyAnnotation = ModelUtils.findAnnotationMirror((Element)getterMethod, JACKSON_XML_PROPERTY);
        if (jacksonXmlPropertyAnnotation.isPresent()) {
            resultBuilder.addAccessorAnnotations(Excerpts.add("%s%n", jacksonXmlPropertyAnnotation.get()));
        }
    }

    private static boolean generateDefaultAnnotations(ExecutableElement getterMethod) {
        for (AnnotationMirror annotationMirror : getterMethod.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            QualifiedName annotationType = QualifiedName.of(annotationTypeElement);
            if (!DISABLE_PROPERTY_ANNOTATIONS.contains(annotationType)) continue;
            return false;
        }
        return true;
    }
}

