/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import org.inferred.freebuilder.processor.MethodIntrospector;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public class JavacMethodIntrospector
extends MethodIntrospector {
    private final Trees trees;
    private static final SimpleTreeVisitor<TreeAnalysis, ?> OWN_METHOD_INVOCATIONS_FETCHER = new SimpleTreeVisitor<TreeAnalysis, Void>(){

        @Override
        public TreeAnalysis visitMethod(MethodTree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            for (StatementTree statementTree : node.getBody().getStatements()) {
                TreeAnalysis statementAnalysis = statementTree.accept(this, p);
                result.names.addAll(statementAnalysis.names);
                if (!statementAnalysis.explicitReturn) continue;
                result.explicitReturn = true;
                return result;
            }
            return result;
        }

        @Override
        public TreeAnalysis visitExpressionStatement(ExpressionStatementTree node, Void p) {
            return node.getExpression().accept(this, p);
        }

        @Override
        public TreeAnalysis visitMethodInvocation(MethodInvocationTree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            Name identifier = (Name)node.getMethodSelect().accept(OWNED_IDENTIFIER, null);
            if (identifier != null) {
                result.names.add(identifier);
            }
            return result;
        }

        @Override
        protected TreeAnalysis defaultAction(Tree node, Void p) {
            TreeAnalysis result = new TreeAnalysis();
            result.explicitReturn = RETURN_TREE_FINDER.scan(node, null) != null;
            return result;
        }
    };
    private static final SimpleTreeVisitor<Name, ?> OWNED_IDENTIFIER = new SimpleTreeVisitor<Name, Void>(){

        @Override
        public Name visitIdentifier(IdentifierTree node, Void p) {
            return node.getName();
        }

        @Override
        public Name visitMemberSelect(MemberSelectTree node, Void p) {
            ExpressionTree lhs = node.getExpression();
            if (lhs.getKind() != Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (!((IdentifierTree)lhs).getName().contentEquals("this")) {
                return null;
            }
            return node.getIdentifier();
        }
    };
    private static final TreeScanner<ReturnTree, ?> RETURN_TREE_FINDER = new TreeScanner<ReturnTree, Void>(){

        @Override
        public ReturnTree visitReturn(ReturnTree node, Void p) {
            return node;
        }

        @Override
        public ReturnTree reduce(ReturnTree r1, ReturnTree r2) {
            return r1 != null ? r1 : r2;
        }
    };
    private static final TreeScanner<?, BiConsumer<MethodInvocationTree, Name>> OWN_METHOD_INVOCATIONS_VISITOR = new TreeScanner<Void, BiConsumer<MethodInvocationTree, Name>>(){

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, BiConsumer<MethodInvocationTree, Name> biConsumer) {
            Name identifier = (Name)OWNED_IDENTIFIER.visit(node.getMethodSelect(), null);
            if (identifier != null) {
                biConsumer.accept(node, identifier);
            }
            return (Void)super.visitMethodInvocation(node, biConsumer);
        }
    };

    public static MethodIntrospector instance(ProcessingEnvironment env) {
        return new JavacMethodIntrospector(Trees.instance(env));
    }

    private JavacMethodIntrospector(Trees trees) {
        this.trees = trees;
    }

    @Override
    public Set<Name> getOwnMethodInvocations(ExecutableElement method) {
        try {
            return ImmutableSet.copyOf(this.trees.getTree(method).accept(OWN_METHOD_INVOCATIONS_FETCHER, null).names);
        }
        catch (RuntimeException e) {
            return ImmutableSet.of();
        }
    }

    @Override
    public void visitAllOwnMethodInvocations(ExecutableElement method, MethodIntrospector.OwnMethodInvocationVisitor visitor) {
        this.trees.getTree(method).accept(OWN_METHOD_INVOCATIONS_VISITOR, (tree, methodName) -> visitor.visitInvocation((Name)methodName, (kind, msg) -> {
            CompilationUnitTree compilationUnit = this.trees.getPath(method).getCompilationUnit();
            this.trees.printMessage(kind, msg, (Tree)tree, compilationUnit);
        }));
    }

    private static class TreeAnalysis {
        private final Set<Name> names = new HashSet<Name>();
        private boolean explicitReturn = false;

        private TreeAnalysis() {
        }
    }
}

