/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

abstract class Property_Builder {
    private TypeMirror type;
    private TypeMirror boxedType = null;
    private String name;
    private String capitalizedName;
    private String allCapsName;
    private boolean usingBeanConvention;
    private String getterName;
    private boolean fullyCheckedCast;
    private List<Excerpt> accessorAnnotations = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Property_Builder() {
    }

    public static Property.Builder from(org.inferred.freebuilder.processor.Property value) {
        return new Property.Builder().mergeFrom(value);
    }

    public Property.Builder setType(TypeMirror type) {
        this.type = Objects.requireNonNull(type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (Property.Builder)this;
    }

    public Property.Builder mapType(UnaryOperator<TypeMirror> mapper) {
        Objects.requireNonNull(mapper);
        return this.setType((TypeMirror)mapper.apply(this.getType()));
    }

    public TypeMirror getType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.TYPE), "type not set");
        return this.type;
    }

    public Property.Builder setBoxedType(TypeMirror boxedType) {
        this.boxedType = Objects.requireNonNull(boxedType);
        return (Property.Builder)this;
    }

    public Property.Builder setBoxedType(Optional<? extends TypeMirror> boxedType) {
        if (boxedType.isPresent()) {
            return this.setBoxedType(boxedType.get());
        }
        return this.clearBoxedType();
    }

    public Property.Builder setNullableBoxedType(TypeMirror boxedType) {
        if (boxedType != null) {
            return this.setBoxedType(boxedType);
        }
        return this.clearBoxedType();
    }

    public Property.Builder mapBoxedType(UnaryOperator<TypeMirror> mapper) {
        return this.setBoxedType(this.getBoxedType().map(mapper));
    }

    public Property.Builder clearBoxedType() {
        this.boxedType = null;
        return (Property.Builder)this;
    }

    public Optional<TypeMirror> getBoxedType() {
        return Optional.ofNullable(this.boxedType);
    }

    public Property.Builder setName(String name) {
        this.name = Objects.requireNonNull(name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (Property.Builder)this;
    }

    public Property.Builder mapName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.NAME), "name not set");
        return this.name;
    }

    public Property.Builder setCapitalizedName(String capitalizedName) {
        this.capitalizedName = Objects.requireNonNull(capitalizedName);
        this._unsetProperties.remove((Object)Property.CAPITALIZED_NAME);
        return (Property.Builder)this;
    }

    public Property.Builder mapCapitalizedName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setCapitalizedName((String)mapper.apply(this.getCapitalizedName()));
    }

    public String getCapitalizedName() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.CAPITALIZED_NAME), "capitalizedName not set");
        return this.capitalizedName;
    }

    public Property.Builder setAllCapsName(String allCapsName) {
        this.allCapsName = Objects.requireNonNull(allCapsName);
        this._unsetProperties.remove((Object)Property.ALL_CAPS_NAME);
        return (Property.Builder)this;
    }

    public Property.Builder mapAllCapsName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setAllCapsName((String)mapper.apply(this.getAllCapsName()));
    }

    public String getAllCapsName() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.ALL_CAPS_NAME), "allCapsName not set");
        return this.allCapsName;
    }

    public Property.Builder setUsingBeanConvention(boolean usingBeanConvention) {
        this.usingBeanConvention = usingBeanConvention;
        this._unsetProperties.remove((Object)Property.USING_BEAN_CONVENTION);
        return (Property.Builder)this;
    }

    public Property.Builder mapUsingBeanConvention(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.setUsingBeanConvention((Boolean)mapper.apply(this.isUsingBeanConvention()));
    }

    public boolean isUsingBeanConvention() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.USING_BEAN_CONVENTION), "usingBeanConvention not set");
        return this.usingBeanConvention;
    }

    public Property.Builder setGetterName(String getterName) {
        this.getterName = Objects.requireNonNull(getterName);
        this._unsetProperties.remove((Object)Property.GETTER_NAME);
        return (Property.Builder)this;
    }

    public Property.Builder mapGetterName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setGetterName((String)mapper.apply(this.getGetterName()));
    }

    public String getGetterName() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.GETTER_NAME), "getterName not set");
        return this.getterName;
    }

    public Property.Builder setFullyCheckedCast(boolean fullyCheckedCast) {
        this.fullyCheckedCast = fullyCheckedCast;
        this._unsetProperties.remove((Object)Property.FULLY_CHECKED_CAST);
        return (Property.Builder)this;
    }

    public Property.Builder mapFullyCheckedCast(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.setFullyCheckedCast((Boolean)mapper.apply(this.isFullyCheckedCast()));
    }

    public boolean isFullyCheckedCast() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST), "fullyCheckedCast not set");
        return this.fullyCheckedCast;
    }

    public Property.Builder addAccessorAnnotations(Excerpt element) {
        if (this.accessorAnnotations instanceof ImmutableList) {
            this.accessorAnnotations = new ArrayList<Excerpt>(this.accessorAnnotations);
        }
        this.accessorAnnotations.add(Objects.requireNonNull(element));
        return (Property.Builder)this;
    }

    public Property.Builder addAccessorAnnotations(Excerpt ... elements) {
        return this.addAllAccessorAnnotations(Arrays.asList(elements));
    }

    public Property.Builder addAllAccessorAnnotations(Spliterator<? extends Excerpt> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.accessorAnnotations instanceof ImmutableList) {
                this.accessorAnnotations = new ArrayList<Excerpt>(this.accessorAnnotations);
            }
            ((ArrayList)this.accessorAnnotations).ensureCapacity(this.accessorAnnotations.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addAccessorAnnotations);
        return (Property.Builder)this;
    }

    public Property.Builder addAllAccessorAnnotations(BaseStream<? extends Excerpt, ?> elements) {
        return this.addAllAccessorAnnotations(elements.spliterator());
    }

    public Property.Builder addAllAccessorAnnotations(Iterable<? extends Excerpt> elements) {
        return this.addAllAccessorAnnotations(elements.spliterator());
    }

    public Property.Builder mutateAccessorAnnotations(Consumer<? super List<Excerpt>> mutator) {
        if (this.accessorAnnotations instanceof ImmutableList) {
            this.accessorAnnotations = new ArrayList<Excerpt>(this.accessorAnnotations);
        }
        mutator.accept(this.accessorAnnotations);
        return (Property.Builder)this;
    }

    public Property.Builder clearAccessorAnnotations() {
        if (this.accessorAnnotations instanceof ImmutableList) {
            this.accessorAnnotations = ImmutableList.of();
        } else {
            this.accessorAnnotations.clear();
        }
        return (Property.Builder)this;
    }

    public List<Excerpt> getAccessorAnnotations() {
        if (this.accessorAnnotations instanceof ImmutableList) {
            this.accessorAnnotations = new ArrayList<Excerpt>(this.accessorAnnotations);
        }
        return Collections.unmodifiableList(this.accessorAnnotations);
    }

    public Property.Builder mergeFrom(org.inferred.freebuilder.processor.Property value) {
        Property.Builder _defaults = new Property.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals(value.getType(), ((Property_Builder)_defaults).getType())) {
            this.setType(value.getType());
        }
        value.getBoxedType().ifPresent(this::setBoxedType);
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((Property_Builder)_defaults).getName())) {
            this.setName(value.getName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.CAPITALIZED_NAME) || !Objects.equals(value.getCapitalizedName(), ((Property_Builder)_defaults).getCapitalizedName())) {
            this.setCapitalizedName(value.getCapitalizedName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.ALL_CAPS_NAME) || !Objects.equals(value.getAllCapsName(), ((Property_Builder)_defaults).getAllCapsName())) {
            this.setAllCapsName(value.getAllCapsName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.USING_BEAN_CONVENTION) || value.isUsingBeanConvention() != ((Property_Builder)_defaults).isUsingBeanConvention()) {
            this.setUsingBeanConvention(value.isUsingBeanConvention());
        }
        if (_defaults._unsetProperties.contains((Object)Property.GETTER_NAME) || !Objects.equals(value.getGetterName(), ((Property_Builder)_defaults).getGetterName())) {
            this.setGetterName(value.getGetterName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST) || value.isFullyCheckedCast() != ((Property_Builder)_defaults).isFullyCheckedCast()) {
            this.setFullyCheckedCast(value.isFullyCheckedCast());
        }
        if (value instanceof Value && this.accessorAnnotations == ImmutableList.of()) {
            this.accessorAnnotations = ImmutableList.copyOf(value.getAccessorAnnotations());
        } else {
            this.addAllAccessorAnnotations(value.getAccessorAnnotations());
        }
        return (Property.Builder)this;
    }

    public Property.Builder mergeFrom(Property.Builder template) {
        Property.Builder base = template;
        Property.Builder _defaults = new Property.Builder();
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !_defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals(template.getType(), ((Property_Builder)_defaults).getType()))) {
            this.setType(template.getType());
        }
        template.getBoxedType().ifPresent(this::setBoxedType);
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((Property_Builder)_defaults).getName()))) {
            this.setName(template.getName());
        }
        if (!(base._unsetProperties.contains((Object)Property.CAPITALIZED_NAME) || !_defaults._unsetProperties.contains((Object)Property.CAPITALIZED_NAME) && Objects.equals(template.getCapitalizedName(), ((Property_Builder)_defaults).getCapitalizedName()))) {
            this.setCapitalizedName(template.getCapitalizedName());
        }
        if (!(base._unsetProperties.contains((Object)Property.ALL_CAPS_NAME) || !_defaults._unsetProperties.contains((Object)Property.ALL_CAPS_NAME) && Objects.equals(template.getAllCapsName(), ((Property_Builder)_defaults).getAllCapsName()))) {
            this.setAllCapsName(template.getAllCapsName());
        }
        if (!base._unsetProperties.contains((Object)Property.USING_BEAN_CONVENTION) && (_defaults._unsetProperties.contains((Object)Property.USING_BEAN_CONVENTION) || template.isUsingBeanConvention() != ((Property_Builder)_defaults).isUsingBeanConvention())) {
            this.setUsingBeanConvention(template.isUsingBeanConvention());
        }
        if (!(base._unsetProperties.contains((Object)Property.GETTER_NAME) || !_defaults._unsetProperties.contains((Object)Property.GETTER_NAME) && Objects.equals(template.getGetterName(), ((Property_Builder)_defaults).getGetterName()))) {
            this.setGetterName(template.getGetterName());
        }
        if (!base._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST) && (_defaults._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST) || template.isFullyCheckedCast() != ((Property_Builder)_defaults).isFullyCheckedCast())) {
            this.setFullyCheckedCast(template.isFullyCheckedCast());
        }
        this.addAllAccessorAnnotations(base.accessorAnnotations);
        return (Property.Builder)this;
    }

    public Property.Builder clear() {
        Property.Builder _defaults = new Property.Builder();
        this.type = _defaults.type;
        this.boxedType = _defaults.boxedType;
        this.name = _defaults.name;
        this.capitalizedName = _defaults.capitalizedName;
        this.allCapsName = _defaults.allCapsName;
        this.usingBeanConvention = _defaults.usingBeanConvention;
        this.getterName = _defaults.getterName;
        this.fullyCheckedCast = _defaults.fullyCheckedCast;
        this.clearAccessorAnnotations();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Property.Builder)this;
    }

    public org.inferred.freebuilder.processor.Property build() {
        Preconditions.checkState(this._unsetProperties.isEmpty(), "Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public org.inferred.freebuilder.processor.Property buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends org.inferred.freebuilder.processor.Property {
        private final TypeMirror type;
        private final TypeMirror boxedType;
        private final String name;
        private final String capitalizedName;
        private final String allCapsName;
        private final boolean usingBeanConvention;
        private final String getterName;
        private final boolean fullyCheckedCast;
        private final ImmutableList<Excerpt> accessorAnnotations;
        private final EnumSet<Property> _unsetProperties;

        Partial(Property_Builder builder) {
            this.type = builder.type;
            this.boxedType = builder.boxedType;
            this.name = builder.name;
            this.capitalizedName = builder.capitalizedName;
            this.allCapsName = builder.allCapsName;
            this.usingBeanConvention = builder.usingBeanConvention;
            this.getterName = builder.getterName;
            this.fullyCheckedCast = builder.fullyCheckedCast;
            this.accessorAnnotations = ImmutableList.copyOf(builder.accessorAnnotations);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public TypeMirror getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        public Optional<TypeMirror> getBoxedType() {
            return Optional.ofNullable(this.boxedType);
        }

        @Override
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        public String getCapitalizedName() {
            if (this._unsetProperties.contains((Object)Property.CAPITALIZED_NAME)) {
                throw new UnsupportedOperationException("capitalizedName not set");
            }
            return this.capitalizedName;
        }

        @Override
        public String getAllCapsName() {
            if (this._unsetProperties.contains((Object)Property.ALL_CAPS_NAME)) {
                throw new UnsupportedOperationException("allCapsName not set");
            }
            return this.allCapsName;
        }

        @Override
        public boolean isUsingBeanConvention() {
            if (this._unsetProperties.contains((Object)Property.USING_BEAN_CONVENTION)) {
                throw new UnsupportedOperationException("usingBeanConvention not set");
            }
            return this.usingBeanConvention;
        }

        @Override
        public String getGetterName() {
            if (this._unsetProperties.contains((Object)Property.GETTER_NAME)) {
                throw new UnsupportedOperationException("getterName not set");
            }
            return this.getterName;
        }

        @Override
        public boolean isFullyCheckedCast() {
            if (this._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST)) {
                throw new UnsupportedOperationException("fullyCheckedCast not set");
            }
            return this.fullyCheckedCast;
        }

        @Override
        public ImmutableList<Excerpt> getAccessorAnnotations() {
            return this.accessorAnnotations;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.boxedType, other.boxedType) && Objects.equals(this.name, other.name) && Objects.equals(this.capitalizedName, other.capitalizedName) && Objects.equals(this.allCapsName, other.allCapsName) && this.usingBeanConvention == other.usingBeanConvention && Objects.equals(this.getterName, other.getterName) && this.fullyCheckedCast == other.fullyCheckedCast && Objects.equals(this.accessorAnnotations, other.accessorAnnotations) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.boxedType, this.name, this.capitalizedName, this.allCapsName, this.usingBeanConvention, this.getterName, this.fullyCheckedCast, this.accessorAnnotations, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial Property{");
            if (!this._unsetProperties.contains((Object)Property.TYPE)) {
                result.append("type=").append(this.type).append(", ");
            }
            if (this.boxedType != null) {
                result.append("boxedType=").append(this.boxedType).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.NAME)) {
                result.append("name=").append(this.name).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.CAPITALIZED_NAME)) {
                result.append("capitalizedName=").append(this.capitalizedName).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.ALL_CAPS_NAME)) {
                result.append("allCapsName=").append(this.allCapsName).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.USING_BEAN_CONVENTION)) {
                result.append("usingBeanConvention=").append(this.usingBeanConvention).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.GETTER_NAME)) {
                result.append("getterName=").append(this.getterName).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.FULLY_CHECKED_CAST)) {
                result.append("fullyCheckedCast=").append(this.fullyCheckedCast).append(", ");
            }
            return result.append("accessorAnnotations=").append(this.accessorAnnotations).append("}").toString();
        }
    }

    private static final class Value
    extends org.inferred.freebuilder.processor.Property {
        private final TypeMirror type;
        private final TypeMirror boxedType;
        private final String name;
        private final String capitalizedName;
        private final String allCapsName;
        private final boolean usingBeanConvention;
        private final String getterName;
        private final boolean fullyCheckedCast;
        private final ImmutableList<Excerpt> accessorAnnotations;

        private Value(Property_Builder builder) {
            this.type = builder.type;
            this.boxedType = builder.boxedType;
            this.name = builder.name;
            this.capitalizedName = builder.capitalizedName;
            this.allCapsName = builder.allCapsName;
            this.usingBeanConvention = builder.usingBeanConvention;
            this.getterName = builder.getterName;
            this.fullyCheckedCast = builder.fullyCheckedCast;
            this.accessorAnnotations = ImmutableList.copyOf(builder.accessorAnnotations);
        }

        @Override
        public TypeMirror getType() {
            return this.type;
        }

        @Override
        public Optional<TypeMirror> getBoxedType() {
            return Optional.ofNullable(this.boxedType);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getCapitalizedName() {
            return this.capitalizedName;
        }

        @Override
        public String getAllCapsName() {
            return this.allCapsName;
        }

        @Override
        public boolean isUsingBeanConvention() {
            return this.usingBeanConvention;
        }

        @Override
        public String getGetterName() {
            return this.getterName;
        }

        @Override
        public boolean isFullyCheckedCast() {
            return this.fullyCheckedCast;
        }

        @Override
        public ImmutableList<Excerpt> getAccessorAnnotations() {
            return this.accessorAnnotations;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.boxedType, other.boxedType) && Objects.equals(this.name, other.name) && Objects.equals(this.capitalizedName, other.capitalizedName) && Objects.equals(this.allCapsName, other.allCapsName) && this.usingBeanConvention == other.usingBeanConvention && Objects.equals(this.getterName, other.getterName) && this.fullyCheckedCast == other.fullyCheckedCast && Objects.equals(this.accessorAnnotations, other.accessorAnnotations);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.boxedType, this.name, this.capitalizedName, this.allCapsName, this.usingBeanConvention, this.getterName, this.fullyCheckedCast, this.accessorAnnotations);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Property{type=").append(this.type);
            if (this.boxedType != null) {
                result.append(", boxedType=").append(this.boxedType);
            }
            return result.append(", name=").append(this.name).append(", capitalizedName=").append(this.capitalizedName).append(", allCapsName=").append(this.allCapsName).append(", usingBeanConvention=").append(this.usingBeanConvention).append(", getterName=").append(this.getterName).append(", fullyCheckedCast=").append(this.fullyCheckedCast).append(", accessorAnnotations=").append(this.accessorAnnotations).append("}").toString();
        }
    }

    private static enum Property {
        TYPE("type"),
        NAME("name"),
        CAPITALIZED_NAME("capitalizedName"),
        ALL_CAPS_NAME("allCapsName"),
        USING_BEAN_CONVENTION("usingBeanConvention"),
        GETTER_NAME("getterName"),
        FULLY_CHECKED_CAST("fullyCheckedCast");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

