/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.LazyName;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;

public class CheckedNavigableSet
extends ValueType
implements Excerpt {
    public static final LazyName TYPE = LazyName.of("CheckedNavigableSet", new CheckedNavigableSet());

    private CheckedNavigableSet() {
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A set implementation that delegates to a provided add method", new Object[0]).addLine(" * to perform element validation and insertion into a backing set.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class %s<E> extends %s<E> implements %s<E> {", TYPE, AbstractSet.class, NavigableSet.class).addLine("", new Object[0]).addLine("  private final %s<E> set;", NavigableSet.class).addLine("  private final %s<E> add;", Consumer.class).addLine("  private final E fromElement;", new Object[0]).addLine("  private final boolean fromInclusive;", new Object[0]).addLine("  private final E toElement;", new Object[0]).addLine("  private final boolean toInclusive;", new Object[0]).addLine("", new Object[0]).addLine("  %s(%s<E> set, %s<E> add) {", TYPE, NavigableSet.class, Consumer.class).addLine("    this.set = set;", new Object[0]).addLine("    this.add = add;", new Object[0]).addLine("    this.fromElement = null;", new Object[0]).addLine("    this.fromInclusive = false;", new Object[0]).addLine("    this.toElement = null;", new Object[0]).addLine("    this.toInclusive = false;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  %s(", TYPE).addLine("      %s<E> set,", NavigableSet.class).addLine("      %s<E> add,", Consumer.class).addLine("      E fromElement,", new Object[0]).addLine("      boolean fromInclusive,", new Object[0]).addLine("      E toElement,", new Object[0]).addLine("      boolean toInclusive) {", new Object[0]).addLine("    this.set = set;", new Object[0]).addLine("    this.add = add;", new Object[0]).addLine("    this.fromElement = fromElement;", new Object[0]).addLine("    this.fromInclusive = fromInclusive;", new Object[0]).addLine("    this.toElement = toElement;", new Object[0]).addLine("    this.toInclusive = toInclusive;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> iterator() {", Iterator.class).addLine("    return set.iterator();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int size() {", new Object[0]).addLine("    return set.size();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean contains(Object e) {", new Object[0]).addLine("    return set.contains(e);", new Object[0]).addLine("  }", new Object[0]);
        CheckedNavigableSet.addAddMethod(code);
        code.addLine("", new Object[0]).addLine("  @Override public boolean remove(Object e) {", new Object[0]).addLine("    return set.remove(e);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<? super E> comparator() {", Comparator.class).addLine("    return set.comparator();", new Object[0]).addLine("  }", new Object[0]);
        CheckedNavigableSet.addSubSetMethod(code);
        code.addLine("", new Object[0]).addLine("  @Override public E first() {", new Object[0]).addLine("    return set.first();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E last() {", new Object[0]).addLine("    return set.last();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E lower(E element) {", new Object[0]).addLine("    return set.lower(element);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E floor(E element) {", new Object[0]).addLine("    return set.floor(element);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E ceiling(E element) {", new Object[0]).addLine("    return set.ceiling(element);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E higher(E element) {", new Object[0]).addLine("    return set.higher(element);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E pollFirst() {", new Object[0]).addLine("    return set.pollFirst();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public E pollLast() {", new Object[0]).addLine("    return set.pollLast();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> descendingSet() {", NavigableSet.class).addLine("    %s<E> descendingSet = set.descendingSet();", NavigableSet.class).addLine("    return new %s(", TYPE).addLine("        descendingSet, add, toElement, toInclusive, fromElement, fromInclusive);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> descendingIterator() {", Iterator.class).addLine("    return set.descendingIterator();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> subSet(", NavigableSet.class).addLine("      E fromElement,", new Object[0]).addLine("      boolean fromInclusive,", new Object[0]).addLine("      E toElement,", new Object[0]).addLine("      boolean toInclusive) {", new Object[0]).addLine("    %s.requireNonNull(fromElement);", Objects.class).addLine("    %s.requireNonNull(toElement);", Objects.class).addLine("    %s<E> subSet = set.subSet(", NavigableSet.class).addLine("        fromElement, fromInclusive, toElement, toInclusive);", new Object[0]).addLine("    return new %s<>(", TYPE).addLine("        subSet, add, fromElement, fromInclusive, toElement, toInclusive);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> headSet(", NavigableSet.class).addLine("      E toElement,", new Object[0]).addLine("      boolean inclusive) {", new Object[0]).addLine("    %s.requireNonNull(toElement);", Objects.class).addLine("    %s<E> headSet = set.headSet(toElement, inclusive);", NavigableSet.class).addLine("    return new %s<>(", TYPE).addLine("        headSet, add, fromElement, fromInclusive, toElement, inclusive);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> tailSet(", NavigableSet.class).addLine("      E fromElement,", new Object[0]).addLine("      boolean inclusive) {", new Object[0]).addLine("    %s.requireNonNull(fromElement);", Objects.class).addLine("    %s<E> tailSet = set.tailSet(fromElement, inclusive);", NavigableSet.class).addLine("    return new %s<>(", TYPE).addLine("        tailSet, add, fromElement, inclusive, toElement, toInclusive);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private static void addSubSetMethod(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  @Override public %s<E> subSet(E fromElement, E toElement) {", NavigableSet.class).addLine("    %s.requireNonNull(fromElement);", Objects.class).addLine("    %s.requireNonNull(toElement);", Objects.class).addLine("    %s<E> subSet = set.subSet(fromElement, true, toElement, false);", NavigableSet.class).addLine("    return new %s<>(", TYPE).addLine("        subSet, add, fromElement, true, toElement, false);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> headSet(E toElement) {", NavigableSet.class).addLine("    %s.requireNonNull(toElement);", Objects.class).addLine("    %s<E> headSet = set.headSet(toElement, false);", NavigableSet.class).addLine("    return new %s<>(", TYPE).addLine("        headSet, add, fromElement, fromInclusive, toElement, false);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<E> tailSet(E fromElement) {", NavigableSet.class).addLine("    %s.requireNonNull(fromElement);", Objects.class).addLine("    %s<E> tailSet = set.tailSet(fromElement, true);", NavigableSet.class).addLine("    return new %s<>(", TYPE).addLine("        tailSet, add, fromElement, true, toElement, toInclusive);", new Object[0]).addLine("  }", new Object[0]);
    }

    private static void addAddMethod(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  @Override public boolean add(E e) {", new Object[0]).addLine("    if (fromElement != null || toElement != null) {", new Object[0]).addLine("      %s<? super E> comparator = set.comparator();", Comparator.class).addLine("      if (comparator == null) {", new Object[0]).addLine("        @SuppressWarnings(\"unchecked\")", new Object[0]).addLine("        %1$s<? super E> lowerBound = (%1$s<? super E>) fromElement;", Comparable.class).addLine("        @SuppressWarnings(\"unchecked\")", new Object[0]).addLine("        %1$s<? super E> upperBound = (%1$s<? super E>) toElement;", Comparable.class).add(PreconditionExcerpts.checkArgument("lowerBound == null || lowerBound.compareTo(e) <= (fromInclusive ? 0 : -1)", "element must be %s %s (got %s)", "(fromInclusive ? \"at least\" : \"greater than\")", "lowerBound", "e")).add(PreconditionExcerpts.checkArgument("upperBound == null || upperBound.compareTo(e) >= (toInclusive ? 0 : 1)", "element must be %s %s (got %s)", "(toInclusive ? \"at most\" : \"less than\")", "upperBound", "e")).addLine("      } else {", new Object[0]).add(PreconditionExcerpts.checkArgument("fromElement == null || comparator.compare(fromElement, e) <= (fromInclusive ? 0 : -1)", "element must be %s %s (got %s) using comparator %s", "(fromInclusive ? \"at least\" : \"greater than\")", "fromElement", "e", "comparator")).add(PreconditionExcerpts.checkArgument("toElement == null || comparator.compare(toElement, e) >= (toInclusive ? 0 : 1)", "element must be %s %s (got %s) using comparator %s", "(toInclusive ? \"at most\" : \"less than\")", "toElement", "e", "comparator")).addLine("      }", new Object[0]).addLine("    }", new Object[0]).addLine("    if (!set.contains(e)) {", new Object[0]).addLine("      add.accept(e);", new Object[0]).addLine("      return true;", new Object[0]).addLine("    } else {", new Object[0]).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("  }", new Object[0]);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
    }
}

