/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.inferred.freebuilder.processor.excerpt.CheckedSet;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.LazyName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.Jsr305;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ForwardingSetMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Maps;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimaps;
import org.inferred.freebuilder.shaded.com.google.common.collect.SetMultimap;

public class CheckedSetMultimap
extends ValueType
implements Excerpt {
    public static final LazyName TYPE = LazyName.of("CheckedSetMultimap", new CheckedSetMultimap());

    protected CheckedSetMultimap() {
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A multimap implementation that delegates to a provided put method", new Object[0]).addLine(" * to perform entry validation and insertion into a backing multimap.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class %s<K, V> extends %s<K, V> {", TYPE, ForwardingSetMultimap.class).addLine("", new Object[0]).addLine("  private final %s<K, V> multimap;", SetMultimap.class).addLine("  private final %s<K, V> put;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> multimap, %s<K, V> put) {", TYPE, SetMultimap.class, BiConsumer.class).addLine("    this.multimap = multimap;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override protected %s<K, V> delegate() {", SetMultimap.class).addLine("    return multimap;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean put(%1$s K key, %1$s V value) {", Jsr305.nullable()).addLine("    put.accept(key, value);", new Object[0]).addLine("    return true;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean putAll(%s K key, %s<? extends V> values) {", Jsr305.nullable(), Iterable.class).addLine("    boolean anyModified = false;", new Object[0]).addLine("    for (V value : values) {", new Object[0]).addLine("      put.accept(key, value);", new Object[0]).addLine("      anyModified = true;", new Object[0]).addLine("    }", new Object[0]).addLine("    return anyModified;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean putAll(%s<? extends K, ? extends V> multimap) {", Multimap.class).addLine("    boolean anyModified = false;", new Object[0]).addLine("    for (%s<? extends K, ? extends V> entry : multimap.entries()) {", Map.Entry.class).addLine("      put.accept(entry.getKey(), entry.getValue());", new Object[0]).addLine("      anyModified = true;", new Object[0]).addLine("    }", new Object[0]).addLine("    return anyModified;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override", new Object[0]).addLine("  public %s<V> replaceValues(%s K key, %s<? extends V> values) {", Set.class, Jsr305.nullable(), Iterable.class).addLine("    %s.checkNotNull(values);", Preconditions.class).addLine("    %s<V> result = removeAll(key);", Set.class).addLine("    putAll(key, values);", new Object[0]).addLine("    return result;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<V> get(%s K key) {", Set.class, Jsr305.nullable()).addLine("    return new %s<>(", CheckedSet.TYPE).addLine("        multimap.get(key), value -> put.accept(key, value));", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<K, %s<V>> asMap() {", Map.class, Collection.class).addLine("    return %s.transformEntries(%s.asMap(multimap), (key, values) -> ", Maps.class, Multimaps.class).addLine("        (%s<V>) new %s<>(", Collection.class, CheckedSet.TYPE).addLine("            values, value -> put.accept(key, value)));", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
    }
}

