/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.ScopeHandler;

class CompilerReflection
implements ScopeHandler.Reflection {
    private final Elements elements;

    CompilerReflection(Elements elements) {
        this.elements = elements;
    }

    @Override
    public Optional<ScopeHandler.TypeInfo> find(String name) {
        TypeElement element = this.elements.getTypeElement(name);
        if (element == null) {
            return Optional.empty();
        }
        return Optional.of(new ElementsTypeInfo(this.elements, element));
    }

    private static class ElementsTypeInfo
    implements ScopeHandler.TypeInfo {
        private final Elements elements;
        private final TypeElement element;
        private final QualifiedName name;

        ElementsTypeInfo(Elements elements, TypeElement element) {
            this.elements = elements;
            this.element = element;
            this.name = QualifiedName.of(element);
        }

        @Override
        public QualifiedName name() {
            return this.name;
        }

        @Override
        public ScopeHandler.Visibility visibility() {
            Set<Modifier> modifiers = this.element.getModifiers();
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                return ScopeHandler.Visibility.PUBLIC;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED)) {
                return ScopeHandler.Visibility.PROTECTED;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE)) {
                return ScopeHandler.Visibility.PRIVATE;
            }
            return ScopeHandler.Visibility.PACKAGE;
        }

        @Override
        public Stream<ScopeHandler.TypeInfo> supertypes() {
            return Stream.concat(this.create(this.element.getSuperclass()), this.element.getInterfaces().stream().flatMap(this::create));
        }

        @Override
        public Stream<ScopeHandler.TypeInfo> nestedTypes() {
            return ElementFilter.typesIn(this.element.getEnclosedElements()).stream().map(element -> new ElementsTypeInfo(this.elements, (TypeElement)element));
        }

        private Stream<ScopeHandler.TypeInfo> create(TypeMirror mirror) {
            TypeElement element = ModelUtils.maybeAsTypeElement(mirror).orElse(null);
            if (element == null) {
                return Stream.of(new ScopeHandler.TypeInfo[0]);
            }
            return Stream.of(new ElementsTypeInfo(this.elements, element));
        }
    }
}

