/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.util.MethodFinder;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;

public class FunctionalType
extends ValueType {
    private final Type functionalInterface;
    private final String methodName;
    private final List<TypeMirror> parameters;
    private final TypeMirror returnType;

    public static FunctionalType consumer(TypeMirror type) {
        Preconditions.checkArgument(!type.getKind().isPrimitive(), "Unexpected primitive type %s", type);
        return new FunctionalType(QualifiedName.of(Consumer.class).withParameters(type, new TypeMirror[0]), "accept", ImmutableList.of(type), null);
    }

    public static FunctionalType unaryOperator(TypeMirror type) {
        Preconditions.checkArgument(!type.getKind().isPrimitive(), "Unexpected primitive type %s", type);
        return new FunctionalType(QualifiedName.of(UnaryOperator.class).withParameters(type, new TypeMirror[0]), "apply", ImmutableList.of(type), type);
    }

    public static FunctionalType primitiveUnaryOperator(PrimitiveType type) {
        switch (type.getKind()) {
            case INT: {
                return new FunctionalType(Type.from(IntUnaryOperator.class), "applyAsInt", ImmutableList.of(type), type);
            }
            case LONG: {
                return new FunctionalType(Type.from(LongUnaryOperator.class), "applyAsLong", ImmutableList.of(type), type);
            }
            case DOUBLE: {
                return new FunctionalType(Type.from(DoubleUnaryOperator.class), "applyAsDouble", ImmutableList.of(type), type);
            }
        }
        throw new IllegalArgumentException("No primitive unary operator exists for " + type);
    }

    public static FunctionalType unboxedUnaryOperator(TypeMirror type, Types types) {
        switch (type.getKind()) {
            case INT: 
            case LONG: 
            case DOUBLE: {
                return FunctionalType.primitiveUnaryOperator((PrimitiveType)type);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case FLOAT: {
                return FunctionalType.unaryOperator(types.boxedClass((PrimitiveType)type).asType());
            }
        }
        return FunctionalType.unaryOperator(type);
    }

    public static FunctionalType functionalTypeAcceptedByMethod(DeclaredType type, String methodName, FunctionalType prototype, Elements elements, Types types) {
        return FunctionalType.functionalTypesAcceptedByMethod(type, methodName, elements, types).stream().filter(functionalType -> FunctionalType.isAssignable(functionalType, prototype, types)).findAny().orElse(prototype);
    }

    public static List<FunctionalType> functionalTypesAcceptedByMethod(DeclaredType type, String methodName, Elements elements, Types types) {
        TypeElement typeElement = ModelUtils.asElement(type);
        return MethodFinder.methodsOn(typeElement, elements, errorType -> {}).stream().filter(method -> method.getSimpleName().contentEquals(methodName) && method.getParameters().size() == 1).flatMap(method -> {
            ExecutableType methodType = (ExecutableType)types.asMemberOf(type, (Element)method);
            TypeMirror parameter = Iterables.getOnlyElement(methodType.getParameterTypes());
            return FunctionalType.maybeFunctionalType(parameter, elements, types).map(Stream::of).orElse(Stream.of(new FunctionalType[0]));
        }).collect(Collectors.toList());
    }

    public static Optional<FunctionalType> maybeFunctionalType(TypeMirror type, Elements elements, Types types) {
        return ModelUtils.maybeDeclared(type).flatMap(declaredType -> FunctionalType.maybeFunctionalType(declaredType, elements, types));
    }

    public static Optional<FunctionalType> maybeFunctionalType(DeclaredType type, Elements elements, Types types) {
        TypeElement typeElement = ModelUtils.asElement(type);
        if (!typeElement.getKind().isInterface()) {
            return Optional.empty();
        }
        Set<ExecutableElement> abstractMethods = ModelUtils.only(Modifier.ABSTRACT, MethodFinder.methodsOn(typeElement, elements, errorType -> {}));
        if (abstractMethods.size() != 1) {
            return Optional.empty();
        }
        ExecutableElement method = Iterables.getOnlyElement(abstractMethods);
        ExecutableType methodType = (ExecutableType)types.asMemberOf(type, method);
        return Optional.of(new FunctionalType(Type.from(type), method.getSimpleName().toString(), methodType.getParameterTypes(), methodType.getReturnType()));
    }

    public static boolean isAssignable(FunctionalType fromType, FunctionalType toType, Types types) {
        if (toType.getParameters().size() != fromType.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < toType.getParameters().size(); ++i) {
            TypeMirror toParam;
            TypeMirror fromParam = fromType.getParameters().get(i);
            if (FunctionalType.isAssignable(fromParam, toParam = toType.getParameters().get(i), types)) continue;
            return false;
        }
        return FunctionalType.isAssignable(fromType.getReturnType(), toType.getReturnType(), types);
    }

    private static boolean isAssignable(TypeMirror fromParam, TypeMirror toParam, Types types) {
        if (FunctionalType.isVoid(fromParam) || FunctionalType.isVoid(toParam)) {
            return FunctionalType.isVoid(fromParam) && FunctionalType.isVoid(toParam);
        }
        return types.isAssignable(fromParam, toParam);
    }

    private static boolean isVoid(TypeMirror type) {
        return type == null || type.getKind() == TypeKind.VOID;
    }

    private FunctionalType(Type functionalInterface, String methodName, Collection<? extends TypeMirror> parameters, TypeMirror returnType) {
        this.functionalInterface = functionalInterface;
        this.methodName = methodName;
        this.parameters = ImmutableList.copyOf(parameters);
        this.returnType = returnType;
    }

    public Type getFunctionalInterface() {
        return this.functionalInterface;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<TypeMirror> getParameters() {
        return this.parameters;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public boolean canReturnNull() {
        return !this.returnType.getKind().isPrimitive();
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("functionalInterface", this.functionalInterface);
        fields.add("methodName", this.methodName);
        ArrayList<String> parametersAsStrings = new ArrayList<String>();
        for (TypeMirror parameter : this.parameters) {
            parametersAsStrings.add(parameter.toString());
        }
        fields.add("parameters", parametersAsStrings);
        fields.add("returnType", this.returnType.toString());
    }

    @Override
    public String toString() {
        return this.functionalInterface.toString();
    }
}

