/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Scope;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;

public class LazyName
extends ValueType
implements Excerpt,
Scope.Key<Declaration> {
    private final String preferredName;
    private final Excerpt definition;

    public static void addLazyDefinitions(SourceBuilder code) {
        HashSet<Declaration> defined = new HashSet<Declaration>();
        List declarations = code.scope().keysOfType(Declaration.class).stream().sorted().collect(Collectors.toList());
        while (!defined.containsAll(declarations)) {
            for (Declaration declaration : declarations) {
                if (!defined.add(declaration)) continue;
                code.add(code.scope().get(declaration).definition);
            }
            declarations = code.scope().keysOfType(Declaration.class).stream().sorted().collect(Collectors.toList());
        }
    }

    public static <E extends ValueType> LazyName of(String preferredName, E definition) {
        return new LazyName(preferredName, (Excerpt)((Object)definition));
    }

    private LazyName(String preferredName, Excerpt definition) {
        this.preferredName = preferredName;
        this.definition = definition;
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("preferredName", this.preferredName);
        fields.add("definition", this.definition);
    }

    @Override
    public Scope.Level level() {
        return Scope.Level.FILE;
    }

    @Override
    public void addTo(SourceBuilder code) {
        Declaration declaration = code.scope().computeIfAbsent(this, () -> {
            int attempt = 1;
            Declaration name = new Declaration(this.preferredName);
            LazyName existingExcerpt;
            while ((existingExcerpt = code.scope().putIfAbsent(name, this)) != null) {
                name = new Declaration(this.preferredName + ++attempt);
            }
            return name;
        });
        code.add(declaration.name, new Object[0]);
    }

    static class Declaration
    extends ValueType
    implements Comparable<Declaration>,
    Scope.Key<LazyName> {
        private final String name;

        Declaration(String name) {
            this.name = name;
        }

        @Override
        public Scope.Level level() {
            return Scope.Level.FILE;
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("name", this.name);
        }

        @Override
        public int compareTo(Declaration other) {
            return this.name.compareTo(other.name);
        }
    }
}

