/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.MissingFormatArgumentException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateApplier {
    private static final Pattern PARAM = Pattern.compile("%([%ns]|([1-9]\\d*)\\$s)");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Object[] params;
    private TextAppender textAppender;
    private ParamAppender paramAppender;
    private int nextParam = 0;

    public static TemplateApplier withParams(Object[] params) {
        return new TemplateApplier(params);
    }

    private TemplateApplier(Object[] params) {
        this.params = params;
    }

    public TemplateApplier onText(TextAppender textAppender) {
        this.textAppender = textAppender;
        return this;
    }

    public TemplateApplier onParam(ParamAppender paramAppender) {
        this.paramAppender = paramAppender;
        return this;
    }

    public TemplateApplier parse(CharSequence template) {
        int offset = 0;
        Matcher matcher = PARAM.matcher(template);
        while (matcher.find()) {
            if (offset != matcher.start()) {
                this.textAppender.append(template, offset, matcher.start());
            }
            if (matcher.group(1).contentEquals("%")) {
                this.textAppender.append("%", 0, 1);
            } else if (matcher.group(1).contentEquals("n")) {
                this.textAppender.append(LINE_SEPARATOR, 0, LINE_SEPARATOR.length());
            } else if (matcher.group(1).contentEquals("s")) {
                if (this.nextParam >= this.params.length) {
                    throw new MissingFormatArgumentException(matcher.group());
                }
                this.paramAppender.append(this.params[this.nextParam++]);
            } else {
                int index = Integer.parseInt(matcher.group(2)) - 1;
                if (index >= this.params.length) {
                    throw new MissingFormatArgumentException(matcher.group());
                }
                this.paramAppender.append(this.params[index]);
            }
            offset = matcher.end();
        }
        if (offset != template.length()) {
            this.textAppender.append(template, offset, template.length());
        }
        return this;
    }

    public static interface ParamAppender {
        public void append(Object var1);
    }

    public static interface TextAppender {
        public void append(CharSequence var1, int var2, int var3);
    }
}

