/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util.feature;

import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.processor.util.feature.FeatureSet;
import org.inferred.freebuilder.processor.util.feature.FeatureType;

public enum JavaxPackage implements Feature<JavaxPackage>
{
    AVAILABLE("javax"),
    UNAVAILABLE("No javax");

    public static final FeatureType<JavaxPackage> JAVAX;
    private static final QualifiedName GENERATED;
    private final String humanReadableFormat;

    private JavaxPackage(String humanReadableFormat) {
        this.humanReadableFormat = humanReadableFormat;
    }

    public Optional<QualifiedName> generated() {
        return this.ifAvailable(GENERATED);
    }

    public String toString() {
        return this.humanReadableFormat;
    }

    private static boolean hasType(Elements elements, QualifiedName type) {
        return elements.getTypeElement(type.toString()) != null;
    }

    private <T> Optional<T> ifAvailable(T value) {
        return this == AVAILABLE ? Optional.of(value) : Optional.empty();
    }

    static {
        JAVAX = new FeatureType<JavaxPackage>(){

            @Override
            protected JavaxPackage testDefault(FeatureSet features) {
                return UNAVAILABLE;
            }

            @Override
            protected JavaxPackage forEnvironment(ProcessingEnvironment env, FeatureSet features) {
                return JavaxPackage.hasType(env.getElementUtils(), GENERATED) ? AVAILABLE : UNAVAILABLE;
            }
        };
        GENERATED = QualifiedName.of("javax.annotation", "Generated", new String[0]);
    }
}

