/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.GeneratedType;
import org.inferred.freebuilder.processor.Processor;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.ToStringGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.FieldAccess;
import org.inferred.freebuilder.processor.util.LazyName;
import org.inferred.freebuilder.processor.util.ObjectsExcerpts;
import org.inferred.freebuilder.processor.util.PreconditionExcerpts;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.Variable;
import org.inferred.freebuilder.processor.util.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

class GeneratedBuilder
extends GeneratedType {
    static final FieldAccess UNSET_PROPERTIES = new FieldAccess("_unsetProperties");
    private final Datatype datatype;
    private final Map<Property, PropertyCodeGenerator> generatorsByProperty;
    private static final Predicate<PropertyCodeGenerator> IS_REQUIRED = generator -> generator.initialState() == PropertyCodeGenerator.Initially.REQUIRED;

    GeneratedBuilder(Datatype datatype, Map<Property, PropertyCodeGenerator> generatorsByProperty) {
        this.datatype = datatype;
        this.generatorsByProperty = generatorsByProperty;
    }

    Datatype getDatatype() {
        return this.datatype;
    }

    public Map<Property, PropertyCodeGenerator> getGeneratorsByProperty() {
        return this.generatorsByProperty;
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("datatype", this.datatype);
        fields.add("generatorsByProperty", this.generatorsByProperty);
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("// Autogenerated code. Do not modify.", new Object[0]).addLine("package %s;", this.datatype.getGeneratedBuilder().getQualifiedName().getPackage()).addLine("", new Object[0]);
        this.addBuilderTypeDeclaration(code);
        code.addLine(" {", new Object[0]);
        this.addStaticFromMethod(code);
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED)) {
            this.addPropertyEnum(code);
        }
        this.addFieldDeclarations(code);
        this.addAccessors(code);
        this.addMergeFromValueMethod(code);
        this.addMergeFromBuilderMethod(code);
        this.addClearMethod(code);
        this.addBuildMethod(code);
        this.addBuildPartialMethod(code);
        this.addValueType(code);
        this.addPartialType(code);
        this.datatype.getNestedClasses().forEach(code::add);
        LazyName.addLazyDefinitions(code);
        code.addLine("}", new Object[0]);
    }

    private void addBuilderTypeDeclaration(SourceBuilder code) {
        code.addLine("/**", new Object[0]).addLine(" * Auto-generated superclass of %s,", this.datatype.getBuilder().javadocLink()).addLine(" * derived from the API of %s.", this.datatype.getType().javadocLink()).addLine(" */", new Object[0]).add(Excerpts.generated(Processor.class));
        this.datatype.getGeneratedBuilderAnnotations().forEach(code::add);
        code.add("abstract class %s", this.datatype.getGeneratedBuilder().declaration());
        if (this.datatype.isBuilderSerializable()) {
            code.add(" implements %s", Serializable.class);
        }
    }

    private void addStaticFromMethod(SourceBuilder code) {
        BuilderFactory builderFactory = this.datatype.getBuilderFactory().orElse(null);
        if (builderFactory == null) {
            return;
        }
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Creates a new builder using {@code value} as a template.", new Object[0]).addLine(" */", new Object[0]).addLine("public static %s %s from(%s value) {", this.datatype.getType().declarationParameters(), this.datatype.getBuilder(), this.datatype.getType()).addLine("  return %s.mergeFrom(value);", builderFactory.newBuilder(this.datatype.getBuilder(), BuilderFactory.TypeInference.EXPLICIT_TYPES)).addLine("}", new Object[0]);
    }

    private void addFieldDeclarations(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.generatorsByProperty.values().forEach(generator -> generator.addBuilderFieldDeclaration(code));
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED)) {
            code.addLine("private final %s<%s> %s =", EnumSet.class, this.datatype.getPropertyEnum(), UNSET_PROPERTIES).addLine("    %s.allOf(%s.class);", EnumSet.class, this.datatype.getPropertyEnum());
        }
    }

    private void addAccessors(SourceBuilder body) {
        this.generatorsByProperty.values().forEach(generator -> generator.addBuilderFieldAccessors(body));
    }

    private void addBuildMethod(SourceBuilder code) {
        boolean hasRequiredProperties = this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a newly-created %s based on the contents of the {@code %s}.", this.datatype.getType().javadocLink(), this.datatype.getBuilder().getSimpleName());
        if (hasRequiredProperties) {
            code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if any field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s build() {", this.datatype.getType());
        if (hasRequiredProperties) {
            code.add(PreconditionExcerpts.checkState("%1$s.isEmpty()", "Not set: %1$s", UNSET_PROPERTIES));
        }
        code.addLine("  return %s(this);", this.datatype.getValueType().constructor()).addLine("}", new Object[0]);
    }

    private void addMergeFromValueMethod(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets all property values using the given {@code %s} as a template.", this.datatype.getType().getQualifiedName()).addLine(" */", new Object[0]).addLine("public %s mergeFrom(%s value) {", this.datatype.getBuilder(), this.datatype.getType());
        this.generatorsByProperty.values().forEach(generator -> generator.addMergeFromValue(code, "value"));
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMergeFromBuilderMethod(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Copies values from the given {@code %s}.", this.datatype.getBuilder().getSimpleName()).addLine(" * Does not affect any properties not set on the input.", new Object[0]).addLine(" */", new Object[0]).addLine("public %1$s mergeFrom(%1$s template) {", this.datatype.getBuilder());
        this.generatorsByProperty.values().forEach(generator -> generator.addMergeFromBuilder(code, "template"));
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClearMethod(SourceBuilder code) {
        Optional<Variable> defaults;
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Resets the state of this builder.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s clear() {", this.datatype.getBuilder());
        this.generatorsByProperty.values().forEach(codeGenerator -> codeGenerator.addClearField(code));
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED) && (defaults = Declarations.freshBuilder(code, this.datatype)).isPresent()) {
            code.addLine("  %s.clear();", UNSET_PROPERTIES).addLine("  %s.addAll(%s);", UNSET_PROPERTIES, UNSET_PROPERTIES.on(defaults.get()));
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addBuildPartialMethod(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns a newly-created partial %s", this.datatype.getType().javadocLink()).addLine(" * for use in unit tests. State checking will not be performed.", new Object[0]);
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED)) {
            code.addLine(" * Unset properties will throw an {@link %s}", UnsupportedOperationException.class).addLine(" * when accessed via the partial object.", new Object[0]);
        }
        if (this.datatype.getHasToBuilderMethod() && this.datatype.getBuilderFactory().equals(Optional.of(BuilderFactory.NO_ARGS_CONSTRUCTOR))) {
            code.addLine(" *", new Object[0]).addLine(" * <p>The builder returned by a partial's {@link %s#toBuilder() toBuilder}", this.datatype.getType()).addLine(" * method overrides {@link %s#build() build()} to return another partial.", this.datatype.getBuilder()).addLine(" * This allows for robust tests of modify-rebuild code.", new Object[0]);
        }
        code.addLine(" *", new Object[0]).addLine(" * <p>Partials should only ever be used in tests. They permit writing robust", new Object[0]).addLine(" * test cases that won't fail if this type gains more application-level", new Object[0]).addLine(" * constraints (e.g. new required fields) in future. If you require partially", new Object[0]).addLine(" * complete values in production code, consider using a Builder.", new Object[0]).addLine(" */", new Object[0]);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("@%s()", VisibleForTesting.class);
        }
        code.addLine("public %s buildPartial() {", this.datatype.getType()).addLine("  return %s(this);", this.datatype.getPartialType().constructor()).addLine("}", new Object[0]);
    }

    private void addPropertyEnum(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("private enum %s {", this.datatype.getPropertyEnum().getSimpleName());
        this.generatorsByProperty.forEach((property, generator) -> {
            if (generator.initialState() == PropertyCodeGenerator.Initially.REQUIRED) {
                code.addLine("  %s(\"%s\"),", property.getAllCapsName(), property.getName());
            }
        });
        code.addLine("  ;", new Object[0]).addLine("", new Object[0]).addLine("  private final %s name;", String.class).addLine("", new Object[0]).addLine("  private %s(%s name) {", this.datatype.getPropertyEnum().getSimpleName(), String.class).addLine("    this.name = name;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @%s public %s toString() {", Override.class, String.class).addLine("    return name;", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private void addValueType(SourceBuilder code) {
        code.addLine("", new Object[0]);
        this.datatype.getValueTypeAnnotations().forEach(code::add);
        code.addLine("%s static final class %s %s {", this.datatype.getValueTypeVisibility(), this.datatype.getValueType().declaration(), GeneratedBuilder.extending(this.datatype.getType(), this.datatype.isInterfaceType()));
        this.generatorsByProperty.forEach((property, generator) -> generator.addValueFieldDeclaration(code, property.getField()));
        this.addValueTypeConstructor(code);
        this.addValueTypeGetters(code);
        if (this.datatype.getHasToBuilderMethod()) {
            this.addValueTypeToBuilder(code);
        }
        switch (this.datatype.standardMethodUnderride(Datatype.StandardMethod.EQUALS)) {
            case ABSENT: {
                this.addValueTypeEquals(code);
                break;
            }
            case OVERRIDEABLE: {
                this.addValueTypeEqualsOverride(code);
                break;
            }
        }
        if (this.datatype.standardMethodUnderride(Datatype.StandardMethod.HASH_CODE) == Datatype.UnderrideLevel.ABSENT) {
            this.addValueTypeHashCode(code);
        }
        if (this.datatype.standardMethodUnderride(Datatype.StandardMethod.TO_STRING) == Datatype.UnderrideLevel.ABSENT) {
            ToStringGenerator.addToString(code, this.datatype, this.generatorsByProperty, false);
        }
        code.addLine("}", new Object[0]);
    }

    private void addValueTypeConstructor(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  private %s(%s builder) {", this.datatype.getValueType().getSimpleName(), this.datatype.getGeneratedBuilder());
        this.generatorsByProperty.forEach((property, generator) -> generator.addFinalFieldAssignment(code, property.getField().on("this"), "builder"));
        code.addLine("  }", new Object[0]);
    }

    private void addValueTypeGetters(SourceBuilder code) {
        this.generatorsByProperty.forEach((property, generator) -> {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class);
            generator.addAccessorAnnotations(code);
            generator.addGetterAnnotations(code);
            code.addLine("  public %s %s() {", property.getType(), property.getGetterName());
            code.add("    return ", new Object[0]);
            generator.addReadValueFragment(code, property.getField());
            code.add(";\n", new Object[0]);
            code.addLine("  }", new Object[0]);
        });
    }

    private void addValueTypeToBuilder(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s toBuilder() {", this.datatype.getBuilder());
        BuilderFactory builderFactory = this.datatype.getBuilderFactory().orElse(null);
        if (builderFactory != null) {
            code.addLine("    return %s.mergeFrom(this);", builderFactory.newBuilder(this.datatype.getBuilder(), BuilderFactory.TypeInference.EXPLICIT_TYPES));
        } else {
            code.addLine("    throw new %s();", UnsupportedOperationException.class);
        }
        code.addLine("  }", new Object[0]);
    }

    private void addValueTypeEquals(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    if (!(obj instanceof %s)) {", this.datatype.getValueType().getQualifiedName()).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) obj;", this.datatype.getValueType().withWildcards());
        if (this.generatorsByProperty.isEmpty()) {
            code.addLine("    return true;", new Object[0]);
        } else {
            String prefix = "    return ";
            for (Property property : this.generatorsByProperty.keySet()) {
                code.add(prefix, new Object[0]);
                code.add(ObjectsExcerpts.equals(property.getField(), property.getField().on("other"), property.getType().getKind()));
                prefix = "\n        && ";
            }
            code.add(";\n", new Object[0]);
        }
        code.addLine("  }", new Object[0]);
    }

    private void addValueTypeEqualsOverride(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    return (!(obj instanceof %s) && super.equals(obj));", this.datatype.getPartialType().getQualifiedName()).addLine("  }", new Object[0]);
    }

    private void addValueTypeHashCode(SourceBuilder code) {
        FieldAccessList fields = GeneratedBuilder.getFields(this.generatorsByProperty.keySet());
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public int hashCode() {", new Object[0]).addLine("    return %s.hash(%s);", Objects.class, fields).addLine("  }", new Object[0]);
    }

    private void addPartialType(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("private static final class %s %s {", this.datatype.getPartialType().declaration(), GeneratedBuilder.extending(this.datatype.getType(), this.datatype.isInterfaceType()));
        this.addPartialFields(code);
        this.addPartialConstructor(code);
        this.addPartialGetters(code);
        this.addPartialToBuilderMethod(code);
        if (this.datatype.standardMethodUnderride(Datatype.StandardMethod.EQUALS) != Datatype.UnderrideLevel.FINAL) {
            this.addPartialEquals(code);
        }
        if (this.datatype.standardMethodUnderride(Datatype.StandardMethod.HASH_CODE) != Datatype.UnderrideLevel.FINAL) {
            this.addPartialHashCode(code);
        }
        if (this.datatype.standardMethodUnderride(Datatype.StandardMethod.TO_STRING) != Datatype.UnderrideLevel.FINAL) {
            ToStringGenerator.addToString(code, this.datatype, this.generatorsByProperty, true);
        }
        code.addLine("}", new Object[0]);
    }

    private void addPartialFields(SourceBuilder code) {
        this.generatorsByProperty.forEach((property, generator) -> generator.addValueFieldDeclaration(code, property.getField()));
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED)) {
            code.addLine("  private final %s<%s> %s;", EnumSet.class, this.datatype.getPropertyEnum(), UNSET_PROPERTIES);
        }
    }

    private void addPartialConstructor(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  %s(%s builder) {", this.datatype.getPartialType().getSimpleName(), this.datatype.getGeneratedBuilder());
        this.generatorsByProperty.forEach((property, generator) -> generator.addPartialFieldAssignment(code, property.getField().on("this"), "builder"));
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED)) {
            code.addLine("    %s = %s.clone();", UNSET_PROPERTIES.on("this"), UNSET_PROPERTIES.on("builder"));
        }
        code.addLine("  }", new Object[0]);
    }

    private void addPartialGetters(SourceBuilder code) {
        this.generatorsByProperty.forEach((property, generator) -> {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class);
            generator.addAccessorAnnotations(code);
            generator.addGetterAnnotations(code);
            code.addLine("  public %s %s() {", property.getType(), property.getGetterName());
            if (generator.initialState() == PropertyCodeGenerator.Initially.REQUIRED) {
                code.addLine("    if (%s.contains(%s.%s)) {", UNSET_PROPERTIES, this.datatype.getPropertyEnum(), property.getAllCapsName()).addLine("      throw new %s(\"%s not set\");", UnsupportedOperationException.class, property.getName()).addLine("    }", new Object[0]);
            }
            code.add("    return ", new Object[0]);
            generator.addReadValueFragment(code, property.getField());
            code.add(";\n", new Object[0]);
            code.addLine("  }", new Object[0]);
        });
    }

    private void addPartialToBuilderMethod(SourceBuilder code) {
        if (!this.datatype.getHasToBuilderMethod()) {
            return;
        }
        if (this.datatype.isExtensible()) {
            code.addLine("", new Object[0]).addLine("  private static class PartialBuilder%s extends %s {", this.datatype.getType().declarationParameters(), this.datatype.getBuilder()).addLine("    @Override public %s build() {", this.datatype.getType()).addLine("      return buildPartial();", new Object[0]).addLine("    }", new Object[0]).addLine("  }", new Object[0]);
        }
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s toBuilder() {", this.datatype.getBuilder());
        Variable builder = new Variable("builder");
        if (this.datatype.isExtensible()) {
            code.addLine("    %s builder = new PartialBuilder%s();", this.datatype.getBuilder(), this.datatype.getBuilder().diamondOperator());
            this.generatorsByProperty.values().forEach(generator -> generator.addSetBuilderFromPartial(code, builder));
            code.addLine("    return %s;", builder);
        } else {
            code.addLine("    throw new %s();", UnsupportedOperationException.class);
        }
        code.addLine("  }", new Object[0]);
    }

    private void addPartialEquals(SourceBuilder code) {
        boolean hasRequiredProperties = this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED);
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean equals(Object obj) {", new Object[0]).addLine("    if (!(obj instanceof %s)) {", this.datatype.getPartialType().getQualifiedName()).addLine("      return false;", new Object[0]).addLine("    }", new Object[0]).addLine("    %1$s other = (%1$s) obj;", this.datatype.getPartialType().withWildcards());
        if (this.generatorsByProperty.isEmpty()) {
            code.addLine("    return true;", new Object[0]);
        } else {
            String prefix = "    return ";
            for (Property property : this.generatorsByProperty.keySet()) {
                code.add(prefix, new Object[0]);
                code.add(ObjectsExcerpts.equals(property.getField(), property.getField().on("other"), property.getType().getKind()));
                prefix = "\n        && ";
            }
            if (hasRequiredProperties) {
                code.add(prefix, new Object[0]);
                code.add("%s.equals(%s, %s)", Objects.class, UNSET_PROPERTIES, UNSET_PROPERTIES.on("other"));
            }
            code.add(";\n", new Object[0]);
        }
        code.addLine("  }", new Object[0]);
    }

    private void addPartialHashCode(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public int hashCode() {", new Object[0]);
        FieldAccessList fields = GeneratedBuilder.getFields(this.generatorsByProperty.keySet());
        if (this.generatorsByProperty.values().stream().anyMatch(IS_REQUIRED)) {
            fields = fields.plus(UNSET_PROPERTIES);
        }
        code.addLine("    return %s.hash(%s);", Objects.class, fields).addLine("  }", new Object[0]);
    }

    private static Excerpt extending(Object type, boolean isInterface) {
        return Excerpts.add(isInterface ? "implements %s" : "extends %s", type);
    }

    private static FieldAccessList getFields(Collection<Property> properties) {
        ImmutableList.Builder fieldAccesses = ImmutableList.builder();
        properties.forEach(property -> fieldAccesses.add(property.getField()));
        return new FieldAccessList((List<FieldAccess>)((Object)fieldAccesses.build()));
    }

    private static class FieldAccessList
    implements Excerpt {
        private final List<FieldAccess> fieldAccesses;

        FieldAccessList(List<FieldAccess> fieldAccesses) {
            this.fieldAccesses = ImmutableList.copyOf(fieldAccesses);
        }

        @Override
        public void addTo(SourceBuilder source) {
            String separator = "";
            for (FieldAccess field : this.fieldAccesses) {
                source.add(separator, new Object[0]).add(field);
                separator = ", ";
            }
        }

        public FieldAccessList plus(FieldAccess fieldAccess) {
            return new FieldAccessList((List<FieldAccess>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.fieldAccesses)).add(fieldAccess)).build()));
        }
    }
}

