/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.Variable;
import org.inferred.freebuilder.shaded.com.google.common.annotations.GwtCompatible;

class GwtSupport {
    private static final QualifiedName CUSTOM_FIELD_SERIALIZER = QualifiedName.of("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "CustomFieldSerializer", new String[0]);
    private static final QualifiedName SERIALIZATION_EXCEPTION = QualifiedName.of("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "SerializationException", new String[0]);
    private static final QualifiedName SERIALIZATION_STREAM_READER = QualifiedName.of("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "SerializationStreamReader", new String[0]);
    private static final QualifiedName SERIALIZATION_STREAM_WRITER = QualifiedName.of("org.inferred.freebuilder.shaded.com.google.gwt.user.client.rpc", "SerializationStreamWriter", new String[0]);

    GwtSupport() {
    }

    public static Datatype.Builder gwtMetadata(TypeElement type, Datatype datatype, Map<Property, PropertyCodeGenerator> generatorsByProperty) {
        Datatype.Builder extraMetadata = new Datatype.Builder();
        Optional<AnnotationMirror> annotation = ModelUtils.findAnnotationMirror((Element)type, GwtCompatible.class);
        if (annotation.isPresent()) {
            extraMetadata.addGeneratedBuilderAnnotations(Excerpts.add("@%s%n", GwtCompatible.class));
            Optional<AnnotationValue> serializable = ModelUtils.findProperty(annotation.get(), "serializable");
            if (serializable.isPresent() && serializable.get().getValue().equals(Boolean.TRUE)) {
                extraMetadata.setValueTypeVisibility(Datatype.Visibility.PACKAGE);
                extraMetadata.addValueTypeAnnotations(Excerpts.add("@%s(serializable = true)%n", GwtCompatible.class));
                extraMetadata.addNestedClasses(new CustomValueSerializer(datatype, generatorsByProperty));
                extraMetadata.addNestedClasses(new GwtWhitelist(datatype, generatorsByProperty.keySet()));
            }
        }
        return extraMetadata;
    }

    private static String withInitialCapital(Object obj) {
        String s = obj.toString();
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static final class GwtWhitelist
    extends ValueType
    implements Excerpt {
        private final Datatype datatype;
        private final Collection<Property> properties;

        private GwtWhitelist(Datatype datatype, Collection<Property> properties) {
            this.datatype = datatype;
            this.properties = properties;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("/** This class exists solely to ensure GWT whitelists all required types. */", new Object[0]).addLine("@%s(serializable = true)", GwtCompatible.class).addLine("static final class GwtWhitelist%s %s %s {", this.datatype.getType().declarationParameters(), this.datatype.isInterfaceType() ? "implements " : "extends ", this.datatype.getType()).addLine("", new Object[0]);
            for (Property property : this.properties) {
                code.addLine("  %s %s;", property.getType(), property.getField());
            }
            code.addLine("", new Object[0]).addLine("  private GwtWhitelist() {", new Object[0]).addLine("    throw new %s();", UnsupportedOperationException.class).addLine("   }", new Object[0]);
            for (Property property : this.properties) {
                code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s %s() {", property.getType(), property.getGetterName()).addLine("    throw new %s();", UnsupportedOperationException.class).addLine("  }", new Object[0]);
            }
            code.addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("datatype", this.datatype);
            fields.add("generatorsByProperty", this.properties);
        }
    }

    private static final class CustomValueSerializer
    extends ValueType
    implements Excerpt {
        private final Datatype datatype;
        private final Map<Property, PropertyCodeGenerator> generatorsByProperty;

        private CustomValueSerializer(Datatype datatype, Map<Property, PropertyCodeGenerator> generatorsByProperty) {
            this.datatype = datatype;
            this.generatorsByProperty = generatorsByProperty;
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("@%s", GwtCompatible.class);
            if (this.datatype.getType().isParameterized()) {
                code.addLine("@%s(\"unchecked\")", SuppressWarnings.class);
            }
            code.addLine("public static class Value_CustomFieldSerializer", new Object[0]).addLine("    extends %s<%s> {", CUSTOM_FIELD_SERIALIZER, this.datatype.getValueType()).addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public void deserializeInstance(%s reader, %s instance) { }", SERIALIZATION_STREAM_READER, this.datatype.getValueType()).addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public boolean hasCustomInstantiateInstance() {", new Object[0]).addLine("    return true;", new Object[0]).addLine("  }", new Object[0]);
            this.addInstantiateInstance(code);
            this.addSerializeInstance(code);
            code.addLine("", new Object[0]).addLine("  private static final Value_CustomFieldSerializer INSTANCE = new Value_CustomFieldSerializer();", new Object[0]).addLine("", new Object[0]).addLine("  public static void deserialize(%s reader, %s instance) {", SERIALIZATION_STREAM_READER, this.datatype.getValueType()).addLine("    INSTANCE.deserializeInstance(reader, instance);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  public static %s instantiate(%s reader)", this.datatype.getValueType(), SERIALIZATION_STREAM_READER).addLine("      throws %s {", SERIALIZATION_EXCEPTION).addLine("    return INSTANCE.instantiateInstance(reader);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  public static void serialize(%s writer, %s instance)", SERIALIZATION_STREAM_WRITER, this.datatype.getValueType()).addLine("      throws %s {", SERIALIZATION_EXCEPTION).addLine("    INSTANCE.serializeInstance(writer, instance);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        private void addInstantiateInstance(SourceBuilder code) {
            Variable builder = new Variable("builder");
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public %s instantiateInstance(%s reader) throws %s {", this.datatype.getValueType(), SERIALIZATION_STREAM_READER, SERIALIZATION_EXCEPTION).addLine("    %1$s %2$s = new %1$s();", this.datatype.getBuilder(), builder);
            for (Property property : this.generatorsByProperty.keySet()) {
                Variable temporary = new Variable(property.getName());
                if (property.getType().getKind().isPrimitive()) {
                    code.addLine("    %s %s = reader.read%s();", property.getType(), temporary, GwtSupport.withInitialCapital(property.getType()));
                    this.generatorsByProperty.get(property).addSetFromResult(code, builder, temporary);
                    continue;
                }
                if (String.class.getName().equals(property.getType().toString())) {
                    code.addLine("    %s %s = reader.readString();", property.getType(), temporary);
                    this.generatorsByProperty.get(property).addSetFromResult(code, builder, temporary);
                    continue;
                }
                code.addLine("    try {", new Object[0]);
                if (!property.isFullyCheckedCast()) {
                    code.addLine("      @SuppressWarnings(\"unchecked\")", new Object[0]);
                }
                code.addLine("      %1$s %2$s = (%1$s) reader.readObject();", property.getType(), temporary);
                this.generatorsByProperty.get(property).addSetFromResult(code, builder, temporary);
                code.addLine("    } catch (%s e) {", ClassCastException.class).addLine("      throw new %s(", SERIALIZATION_EXCEPTION).addLine("          \"Wrong type for property '%s'\", e);", property.getName()).addLine("    }", new Object[0]);
            }
            code.addLine("    return (%s) %s.build();", this.datatype.getValueType(), builder).addLine("  }", new Object[0]);
        }

        private void addSerializeInstance(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("  @%s", Override.class).addLine("  public void serializeInstance(%s writer, %s instance)", SERIALIZATION_STREAM_WRITER, this.datatype.getValueType()).addLine("      throws %s {", SERIALIZATION_EXCEPTION);
            for (Property property : this.generatorsByProperty.keySet()) {
                if (property.getType().getKind().isPrimitive()) {
                    code.add("    writer.write%s(", GwtSupport.withInitialCapital(property.getType()));
                } else if (String.class.getName().equals(property.getType().toString())) {
                    code.add("    writer.writeString(", new Object[0]);
                } else {
                    code.add("    writer.writeObject(", new Object[0]);
                }
                this.generatorsByProperty.get(property).addReadValueFragment(code, property.getField().on("instance"));
                code.add(");\n", new Object[0]);
            }
            code.addLine("  }", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("datatype", this.datatype);
            fields.add("generatorsByProperty", this.generatorsByProperty);
        }
    }
}

