/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Collection;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.BaseStream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.Property;
import org.inferred.freebuilder.processor.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.Util;
import org.inferred.freebuilder.processor.excerpt.CheckedMultiset;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.FunctionalType;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.Variable;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMultiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.LinkedHashMultiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multisets;

class MultisetProperty
extends PropertyCodeGenerator {
    private final boolean needsSafeVarargs;
    private final boolean overridesSetCountMethod;
    private final boolean overridesVarargsAddMethod;
    private final TypeMirror elementType;
    private final Optional<TypeMirror> unboxedType;
    private final FunctionalType mutatorType;

    MultisetProperty(Datatype datatype, Property property, boolean needsSafeVarargs, boolean overridesSetCountMethod, boolean overridesVarargsAddMethod, TypeMirror elementType, Optional<TypeMirror> unboxedType, FunctionalType mutatorType) {
        super(datatype, property);
        this.needsSafeVarargs = needsSafeVarargs;
        this.overridesSetCountMethod = overridesSetCountMethod;
        this.overridesVarargsAddMethod = overridesVarargsAddMethod;
        this.elementType = elementType;
        this.unboxedType = unboxedType;
        this.mutatorType = mutatorType;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %1$s<%2$s> %3$s = %1$s.create();", LinkedHashMultiset.class, this.elementType, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addAdd(code);
        this.addVarargsAdd(code);
        this.addSpliteratorAddAll(code);
        this.addStreamAddAll(code);
        this.addIterableAddAll(code);
        this.addAddCopiesTo(code);
        this.addMutate(code);
        this.addClear(code);
        this.addSetCountOf(code);
        this.addGetter(code);
    }

    private void addAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the multiset to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType)).addLine("  %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addVarargsAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the multiset to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
        }
        code.addLine(" */", new Object[0]);
        if (this.needsSafeVarargs) {
            if (!this.overridesVarargsAddMethod) {
                code.addLine("@%s", SafeVarargs.class).addLine("@%s({\"varargs\"})", SuppressWarnings.class);
            } else {
                code.addLine("@%s({\"unchecked\", \"varargs\"})", SuppressWarnings.class);
            }
        }
        code.add("public ", new Object[0]);
        if (this.needsSafeVarargs && !this.overridesVarargsAddMethod) {
            code.add("final ", new Object[0]);
        }
        code.add("%s %s(%s... elements) {\n", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType)).addLine("  for (%s element : elements) {", this.unboxedType.orElse(this.elementType)).addLine("    %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addSpliteratorAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Spliterator.class, this.elementType).addLine("  elements.forEachRemaining(element -> {", new Object[0]).addLine("    %s(element, 1);", BuilderMethods.addCopiesMethod(this.property)).addLine("  });", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addStreamAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s, ?> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), BaseStream.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addIterableAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addJavadocForAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the multiset to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
    }

    private void addAddCopiesTo(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a number of occurrences of {@code element} to the multiset to be", new Object[0]).addLine(" * returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" * @throws IllegalArgumentException if {@code occurrences} is negative", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s element, int occurrences) {", this.datatype.getBuilder(), BuilderMethods.addCopiesMethod(this.property), this.unboxedType.orElse(this.elementType)).addLine("  %s(element, %s.count(element) + occurrences);", BuilderMethods.setCountMethod(this.property), this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the multiset to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the multiset in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        if (this.overridesSetCountMethod) {
            code.addLine("  mutator.%s(new %s<>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedMultiset.TYPE, this.property.getField(), BuilderMethods.setCountMethod(this.property));
        } else {
            code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.setCountMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the multiset to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addSetCountOf(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds or removes the necessary occurrences of {@code element} to/from the", new Object[0]).addLine(" * multiset to be returned from %s, such that it attains the", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * desired count.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" * @throws IllegalArgumentException if {@code occurrences} is negative", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s element, int occurrences) {", this.datatype.getBuilder(), BuilderMethods.setCountMethod(this.property), this.unboxedType.orElse(this.elementType));
        if (!this.unboxedType.isPresent()) {
            code.addLine("  %s.checkNotNull(element);", Preconditions.class);
        }
        code.addLine("  %s.setCount(element, occurrences);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the multiset that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", Multiset.class, this.elementType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableMultiset(%s);", Multisets.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s.copyOf(%s);", finalField, ImmutableMultiset.class, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.addAllMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s.clear();", this.property.getField());
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<MultisetProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType type = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (type == null || !Util.erasesToAnyOf(type, Multiset.class, ImmutableMultiset.class)) {
                return Optional.empty();
            }
            TypeMirror elementType = Util.upperBound(config.getElements(), type.getTypeArguments().get(0));
            Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
            boolean needsSafeVarargs = ModelUtils.needsSafeVarargs(unboxedType.orElse(elementType));
            boolean overridesSetCountMethod = Factory.hasSetCountMethodOverride(config, unboxedType.orElse(elementType));
            boolean overridesVarargsAddMethod = Factory.hasVarargsAddMethodOverride(config, unboxedType.orElse(elementType));
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(config.getProperty()), FunctionalType.consumer(Factory.multiset(elementType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new MultisetProperty(config.getDatatype(), config.getProperty(), needsSafeVarargs, overridesSetCountMethod, overridesVarargsAddMethod, elementType, unboxedType, mutatorType));
        }

        private static boolean hasSetCountMethodOverride(PropertyCodeGenerator.Config config, TypeMirror type) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.setCountMethod(config.getProperty()), type, config.getTypes().getPrimitiveType(TypeKind.INT));
        }

        private static boolean hasVarargsAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), config.getTypes().getArrayType(elementType));
        }

        private static TypeMirror multiset(TypeMirror elementType, Elements elements, Types types) {
            TypeElement multisetType = elements.getTypeElement(Multiset.class.getName());
            return types.getDeclaredType(multisetType, elementType);
        }
    }
}

