/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.LazyName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.ValueType;

public class CheckedMap
extends ValueType
implements Excerpt {
    public static final LazyName TYPE = LazyName.of("CheckedMap", new CheckedMap());

    private CheckedMap() {
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A map implementation that delegates to a provided put method", new Object[0]).addLine(" * to perform entry validation and insertion into a backing map.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class %s<K, V> extends %s<K, V> {", TYPE, AbstractMap.class).addLine("", new Object[0]).addLine("  private final %s<K, V> map;", Map.class).addLine("  private final %s<K, V> put;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> map, %s<K, V> put) {", TYPE, Map.class, BiConsumer.class).addLine("    this.map = map;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V get(Object key) {", new Object[0]).addLine("    return map.get(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean containsKey(Object key) {", new Object[0]).addLine("    return map.containsKey(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V put(K key, V value) {", new Object[0]).addLine("    V oldValue = map.get(key);", new Object[0]).addLine("    put.accept(key, value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V remove(Object key) {", new Object[0]).addLine("    return map.remove(key);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void clear() {", new Object[0]).addLine("    map.clear();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<%s<K, V>> entrySet() {", Set.class, Map.Entry.class).addLine("    return new %s<>(map.entrySet(), put);", CheckedEntrySet.TYPE).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
    }

    private static class CheckedEntrySet
    extends ValueType
    implements Excerpt {
        static final LazyName TYPE = LazyName.of("CheckedEntrySet", new CheckedEntrySet());

        private CheckedEntrySet() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static class %s<K, V> extends %s<%s<K, V>> {", TYPE, AbstractSet.class, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<%s<K, V>> set;", Set.class, Map.Entry.class).addLine("  private final %s<K, V> put;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<%s<K, V>> set, %s<K, V> put) {", TYPE, Set.class, Map.Entry.class, BiConsumer.class).addLine("    this.set = set;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int size() {", new Object[0]).addLine("    return set.size();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<%s<K, V>> iterator() {", Iterator.class, Map.Entry.class).addLine("    return new %s<K, V>(set.iterator(), put);", CheckedEntryIterator.TYPE).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean contains(Object o) {", new Object[0]).addLine("    return set.contains(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean remove(Object o) {", new Object[0]).addLine("    return set.remove(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void clear() {", new Object[0]).addLine("    set.clear();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static class CheckedEntryIterator
    extends ValueType
    implements Excerpt {
        static final LazyName TYPE = LazyName.of("CheckedEntryIterator", new CheckedEntryIterator());

        private CheckedEntryIterator() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static class %s<K, V> implements %s<%s<K, V>> {", TYPE, Iterator.class, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<%s<K, V>> iterator;", Iterator.class, Map.Entry.class).addLine("  private final %s<K, V> put;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(", TYPE).addLine("      %s<%s<K, V>> iterator,", Iterator.class, Map.Entry.class).addLine("      %s<K, V> put) {", BiConsumer.class).addLine("    this.iterator = iterator;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean hasNext() {", new Object[0]).addLine("    return iterator.hasNext();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public %s<K, V> next() {", Map.Entry.class).addLine("    return new %s<K, V>(iterator.next(), put);", CheckedEntry.TYPE).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public void remove() {", new Object[0]).addLine("    iterator.remove();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static class CheckedEntry
    extends ValueType
    implements Excerpt {
        static final LazyName TYPE = LazyName.of("CheckedEntry", new CheckedEntry());

        private CheckedEntry() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static class %s<K, V> implements %s<K, V> {", TYPE, Map.Entry.class).addLine("", new Object[0]).addLine("  private final %s<K, V> entry;", Map.Entry.class).addLine("  private final %s<K, V> put;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<K, V> entry, %s<K, V> put) {", TYPE, Map.Entry.class, BiConsumer.class).addLine("    this.entry = entry;", new Object[0]).addLine("    this.put = put;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public K getKey() {", new Object[0]).addLine("    return entry.getKey();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V getValue() {", new Object[0]).addLine("    return entry.getValue();", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public V setValue(V value) {", new Object[0]).addLine("    %s.requireNonNull(value);", Objects.class).addLine("    V oldValue = entry.getValue();", new Object[0]).addLine("    put.accept(entry.getKey(), value);", new Object[0]).addLine("    return oldValue;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean equals(Object o) {", new Object[0]).addLine("    return entry.equals(o);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int hashCode() {", new Object[0]).addLine("    return entry.hashCode();", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }
}

