/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.inferred.freebuilder.shaded.com.google.common.collect.FluentIterable;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public abstract class Scope {
    private static final Object RECURSION_SENTINEL = new Object();
    private final Map<Key<?>, Object> entries = new LinkedHashMap();
    private final Scope parent;

    protected Scope() {
        this.parent = null;
    }

    protected Scope(Scope parent) {
        this.parent = parent;
    }

    protected abstract boolean canStore(Key<?> var1);

    public boolean isEmpty() {
        return (this.parent == null || this.parent.isEmpty()) && this.entries.isEmpty();
    }

    public boolean contains(Key<?> key) {
        return this.get(key) != null;
    }

    public <V> V get(Key<V> key) {
        Object value = this.entries.get(key);
        if (value == RECURSION_SENTINEL) {
            throw new ConcurrentModificationException("Cannot access scope key " + key + " while computing its value");
        }
        if (value != null) {
            return (V)value;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public <V> V computeIfAbsent(Key<V> key, Supplier<V> supplier) {
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        if (this.canStore(key)) {
            this.entries.put(key, RECURSION_SENTINEL);
            value = supplier.get();
            this.entries.put(key, Objects.requireNonNull(value));
            return value;
        }
        if (this.parent != null) {
            return this.parent.computeIfAbsent(key, supplier);
        }
        throw new IllegalStateException("Not in " + key.level().toString().toLowerCase() + " scope");
    }

    public <V> Set<V> keysOfType(Class<V> keyType) {
        ImmutableSet.Builder keys = ImmutableSet.builder();
        if (this.parent != null) {
            keys.addAll(this.parent.keysOfType(keyType));
        }
        keys.addAll(FluentIterable.from(this.entries.keySet()).filter(keyType).toSet());
        return keys.build();
    }

    public <V> V putIfAbsent(Key<V> key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.canStore(key)) {
            Object existingValue = this.entries.get(key);
            if (value == RECURSION_SENTINEL) {
                throw new ConcurrentModificationException("Cannot access scope key " + key + " while computing its value");
            }
            if (existingValue == null) {
                this.entries.put(key, value);
            }
            return (V)existingValue;
        }
        if (this.parent != null) {
            return this.parent.putIfAbsent(key, value);
        }
        throw new IllegalStateException("Not in " + key.level().toString().toLowerCase() + " scope");
    }

    static class MethodScope
    extends Scope {
        MethodScope(Scope parent) {
            super(parent);
        }

        @Override
        protected boolean canStore(Key<?> key) {
            return key.level() == Level.METHOD;
        }
    }

    static class FileScope
    extends Scope {
        FileScope() {
        }

        @Override
        protected boolean canStore(Key<?> key) {
            return key.level() == Level.FILE;
        }
    }

    public static interface Key<V> {
        public Level level();
    }

    public static enum Level {
        FILE,
        METHOD;

    }
}

