/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.shaded.com.google.common.collect.HashMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.SetMultimap;

class ScopeHandler {
    private static final String UNIVERSALLY_VISIBLE_PACKAGE = "java.lang";
    private final Reflection reflect;
    private final Map<QualifiedName, Visibility> typeVisibility = new HashMap<QualifiedName, Visibility>();
    private final Map<QualifiedName, SetMultimap<String, QualifiedName>> visibleTypes = new HashMap<QualifiedName, SetMultimap<String, QualifiedName>>();
    private final Map<String, QualifiedName> generatedTypes = new HashMap<String, QualifiedName>();

    ScopeHandler(Reflection reflect) {
        this.reflect = reflect;
    }

    ScopeState visibilityIn(String pkg, QualifiedName type) {
        if (pkg == null) {
            return this.visibilityIn(UNIVERSALLY_VISIBLE_PACKAGE, type);
        }
        if (this.isTopLevelType(pkg, type.getSimpleName())) {
            if (type.isTopLevel() && type.getPackage().equals(pkg)) {
                return ScopeState.IN_SCOPE;
            }
            return ScopeState.HIDDEN;
        }
        if (!pkg.equals(UNIVERSALLY_VISIBLE_PACKAGE)) {
            return this.visibilityIn(UNIVERSALLY_VISIBLE_PACKAGE, type);
        }
        return ScopeState.IMPORTABLE;
    }

    ScopeState visibilityIn(QualifiedName scope, QualifiedName type) {
        Set<QualifiedName> possibleConflicts = this.typesInScope(scope).get(type.getSimpleName());
        if (possibleConflicts.equals(ImmutableSet.of(type))) {
            return ScopeState.IN_SCOPE;
        }
        if (!possibleConflicts.isEmpty()) {
            return ScopeState.HIDDEN;
        }
        if (!scope.isTopLevel()) {
            return this.visibilityIn(scope.enclosingType(), type);
        }
        return this.visibilityIn(scope.getPackage(), type);
    }

    void declareGeneratedType(Visibility visibility, QualifiedName generatedType, Set<String> supertypes) {
        this.generatedTypes.put(generatedType.toString(), generatedType);
        this.typeVisibility.put(generatedType, visibility);
        if (!generatedType.isTopLevel()) {
            ScopeHandler.get(this.visibleTypes, generatedType.enclosingType()).put(generatedType.getSimpleName(), generatedType);
        }
        SetMultimap<String, QualifiedName> visibleInScope = ScopeHandler.get(this.visibleTypes, generatedType);
        supertypes.stream().flatMap(this::lookup).forEach(supertype -> {
            for (QualifiedName type : this.typesInScope((QualifiedName)supertype).values()) {
                if (!ScopeHandler.maybeVisibleInScope(generatedType, this.visibilityOf(type), type)) continue;
                visibleInScope.put(type.getSimpleName(), type);
            }
        });
    }

    private Stream<QualifiedName> lookup(String typename) {
        if (this.generatedTypes.containsKey(typename)) {
            return Stream.of(this.generatedTypes.get(typename));
        }
        return this.reflect.find(typename).map(TypeInfo::name).map(Stream::of).orElse(Stream.of(new QualifiedName[0]));
    }

    private boolean isTopLevelType(String pkg, String simpleName) {
        String name = pkg + "." + simpleName;
        return this.generatedTypes.containsKey(name) || this.reflect.find(name).isPresent();
    }

    private static <K1, K2, V> SetMultimap<K2, V> get(Map<K1, SetMultimap<K2, V>> map, K1 key) {
        SetMultimap<K2, V> result = map.get(key);
        if (result == null) {
            result = HashMultimap.create();
            map.put(key, result);
        }
        return result;
    }

    private SetMultimap<String, QualifiedName> typesInScope(QualifiedName scope) {
        return Optional.ofNullable(this.visibleTypes.get(scope)).orElseGet(() -> this.computeTypesInScope(scope));
    }

    private SetMultimap<String, QualifiedName> computeTypesInScope(QualifiedName scope) {
        HashMultimap<String, QualifiedName> visibleInScope = HashMultimap.create();
        this.visibleTypes.put(scope, visibleInScope);
        this.reflect.find(scope.toString()).ifPresent(element -> {
            element.supertypes().forEach(supertype -> this.typesInScope(supertype.name()).values().forEach(type -> {
                if (ScopeHandler.maybeVisibleInScope(scope, this.visibilityOf((QualifiedName)type), type)) {
                    visibleInScope.put(type.getSimpleName(), (QualifiedName)type);
                }
            }));
            element.nestedTypes().forEach(nested -> visibleInScope.put(nested.name().getSimpleName().toString(), nested.name()));
        });
        return visibleInScope;
    }

    private static boolean maybeVisibleInScope(QualifiedName scope, Visibility visibility, QualifiedName type) {
        switch (visibility) {
            case PUBLIC: 
            case PROTECTED: {
                return true;
            }
            case PACKAGE: {
                return scope.getPackage().equals(type.getPackage());
            }
            case PRIVATE: {
                return type.enclosingType().equals(scope);
            }
            case UNKNOWN: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown visibility " + (Object)((Object)visibility));
    }

    private Visibility visibilityOf(QualifiedName type) {
        return this.typeVisibility.computeIfAbsent(type, t -> this.reflect.find(t.toString()).get().visibility());
    }

    static interface TypeInfo {
        public QualifiedName name();

        public Visibility visibility();

        public Stream<TypeInfo> supertypes();

        public Stream<TypeInfo> nestedTypes();
    }

    static interface Reflection {
        public Optional<TypeInfo> find(String var1);
    }

    static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE,
        UNKNOWN;

    }

    static enum ScopeState {
        IN_SCOPE,
        HIDDEN,
        IMPORTABLE;

    }
}

